<?php

/*
 *
 * File ini bagian dari:
 *
 * OpenSID
 *
 * Sistem informasi desa sumber terbuka untuk memajukan desa
 *
 * Aplikasi dan source code ini dirilis berdasarkan lisensi GPL V3
 *
 * Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * Hak Cipta 2016 - 2025 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 *
 * Dengan ini diberikan izin, secara gratis, kepada siapa pun yang mendapatkan salinan
 * dari perangkat lunak ini dan file dokumentasi terkait ("Aplikasi Ini"), untuk diperlakukan
 * tanpa batasan, termasuk hak untuk menggunakan, menyalin, mengubah dan/atau mendistribusikan,
 * asal tunduk pada syarat berikut:
 *
 * Pemberitahuan hak cipta di atas dan pemberitahuan izin ini harus disertakan dalam
 * setiap salinan atau bagian penting Aplikasi Ini. Barang siapa yang menghapus atau menghilangkan
 * pemberitahuan ini melanggar ketentuan lisensi Aplikasi Ini.
 *
 * PERANGKAT LUNAK INI DISEDIAKAN "SEBAGAIMANA ADANYA", TANPA JAMINAN APA PUN, BAIK TERSURAT MAUPUN
 * TERSIRAT. PENULIS ATAU PEMEGANG HAK CIPTA SAMA SEKALI TIDAK BERTANGGUNG JAWAB ATAS KLAIM, KERUSAKAN ATAU
 * KEWAJIBAN APAPUN ATAS PENGGUNAAN ATAU LAINNYA TERKAIT APLIKASI INI.
 *
 * @package   OpenSID
 * @author    Tim Pengembang OpenDesa
 * @copyright Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * @copyright Hak Cipta 2016 - 2025 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 * @license   http://www.gnu.org/licenses/gpl.html GPL V3
 * @link      https://github.com/OpenSID/OpenSID
 *
 */

namespace App\Libraries\TinyMCE;

use App\Models\Pamong;

class KodeIsianPenandaTangan
{
    private readonly string $sebutanDesa;

    public function __construct(private $inputForm)
    {
        $this->sebutanDesa = ucwords((string) setting('sebutan desa'));
    }

    public static function get($inputForm): array
    {
        return (new self($inputForm))->kodeIsian();
    }

    public function kodeIsian(): array
    {
        $nama_desa = identitas('nama_desa');

        //Data penandatangan
        $kades = Pamong::kepalaDesa()->first();

        $ttd         = $this->inputForm['pilih_atas_nama'];
        $atas_nama   = $kades->pamong_jabatan . ' ' . $nama_desa;
        $jabatan     = $kades->pamong_jabatan;
        $jabatan_an  = $simbol_an = $simbol_ub = $ub_jabatan = '';
        $nama_pamong = $kades->pamong_nama;
        $nip_pamong  = $kades->pamong_nip;
        $niap_pamong = $kades->pamong_niap;

        $sekdes = Pamong::ttd('a.n')->first();
        if (preg_match('/a.n/i', (string) $ttd)) {
            $atas_nama   = 'a.n. ' . $kades->nama_jabatan . ' ' . $nama_desa . ' <br> ' . $sekdes->pamong_jabatan;
            $jabatan     = $sekdes->pamong_jabatan;
            $jabatan_an  = $jabatan;
            $simbol_an   = 'a.n.';
            $simbol_ub   = '';
            $ub_jabatan  = '';
            $nama_pamong = $sekdes->pamong_nama;
            $nip_pamong  = $sekdes->pamong_nip;
            $niap_pamong = $sekdes->pamong_niap;
        }

        if (preg_match('/u.b/i', (string) $ttd)) {
            $pamong      = Pamong::ttd('u.b')->find($this->inputForm['pamong_id']);
            $atas_nama   = 'a.n. ' . $kades->nama_jabatan . ' ' . $nama_desa . ' <br> ' . $sekdes->pamong_jabatan . '<br> u.b. <br>' . $pamong->jabatan->nama;
            $jabatan     = $pamong->pamong_jabatan;
            $jabatan_an  = $sekdes->pamong_jabatan;
            $simbol_an   = 'a.n.';
            $simbol_ub   = 'u.b';
            $ub_jabatan  = $jabatan;
            $nama_pamong = $pamong->pamong_nama;
            $nip_pamong  = $pamong->pamong_nip;
            $niap_pamong = $pamong->pamong_niap;
        }

        if (strlen($nip_pamong) > 10) {
            $sebutan_nip_desa = 'NIP';
            $nip              = $nip_pamong;
            $pamong_nip       = $sebutan_nip_desa . ' : ' . $nip;
        } else {
            $sebutan_nip_desa = setting('sebutan_nip_desa');
            if (! empty($niap_pamong)) {
                $nip        = $niap_pamong;
                $pamong_nip = $sebutan_nip_desa . ' : ' . $niap_pamong;
            } else {
                $pamong_nip = '';
            }
        }

        return [
            [
                'judul' => 'Simbol a.n.',
                'isian' => 'Simbol_an',
                'data'  => $simbol_an,
            ],
            [
                'judul' => 'Jabatan a.n.',
                'isian' => 'Jabatan_an',
                'data'  => $jabatan_an,
            ],
            [
                'judul' => 'Simbol u.b.',
                'isian' => 'Simbol_ub',
                'data'  => $simbol_ub,
            ],
            [
                'judul' => 'Jabatan u.b.',
                'isian' => 'Jabatan_ub',
                'data'  => $ub_jabatan,
            ],
            [
                'judul' => 'Atas Nama',
                'isian' => 'Atas_namA',
                'data'  => $atas_nama,
            ],
            [
                'judul' => 'Nama Pamong',
                'isian' => 'Nama_pamonG',
                'data'  => $nama_pamong,
            ],
            [
                'judul' => 'Jabatan Pamong',
                'isian' => 'JabataN',
                'data'  => $jabatan,
            ],
            [
                'judul' => 'Sebutan NIP ' . $this->sebutanDesa,
                'isian' => 'Sebutan_nip_desA',
                'data'  => $sebutan_nip_desa,
            ],
            [
                'case_sentence' => true,
                'judul'         => 'NIP Pamong',
                'isian'         => 'Nip_pamonG',
                'data'          => $nip,
            ],
            [
                'judul' => 'Sebutan NIP ' . $this->sebutanDesa . ' & NIP Pamong',
                'isian' => 'Form_nip_pamonG',
                'data'  => $pamong_nip,
            ],
        ];
    }
}
