tinymce.PluginManager.add("kodeisian", function (editor, url) {
    editor.ui.registry.addMenuButton("kodeisian", {
        text: "Kode Isian",
        fetch: function (callback) {
            var items = [];
            var urlKodeIsian = editor.getElement().getAttribute('data-urlkodeisian') ?? 'surat_master'
            $.ajax({
                type: "GET",
                url: SITE_URL + urlKodeIsian +"/kode_isian/" + editor.getElement().getAttribute('data-salintemplate') + "/" + $("#id_surat").val(),
                dataType: "json",
                processData: true,
                success: function (response) {
                    $.each(response, function (key, value) {
                        var menuItem = {
                            type: "nestedmenuitem",
                            text: key,
                            getSubmenuItems: function () {
                                return kode_isian(editor, value);
                            },
                        };
                        items.push(menuItem);
                    });

                    callback(items);
                },

                error: function (xhr, status, error) {
                    notifEditor("Error! " + xhr.status + "\n" + error, "error");
                },
            });
        },
    });
});

function kode_isian(editor, isian) {
    var kode_isian = [];

    $.each(isian, function (key, value) {
        // Case sentence untuk form isian nik, number dan jam.
        if (value?.case_sentence) {
            var combine = {
                type: "menuitem",
                text: value.judul,
                onAction: function () {
                    editor.insertContent(value.isian.normal);
                },
            };
        } else {
            var combine = {
                type: "nestedmenuitem",
                text: value.judul,
                getSubmenuItems: function () {
                    let isian = value.isian;
                    return [
                        {
                            type: "menuitem",
                            text: "Normal",
                            onAction: function () {
                                editor.insertContent(isian.normal);
                            },
                        },
                        {
                            type: "menuitem",
                            text: "huruf kecil",
                            onAction: function () {
                                editor.insertContent(isian.lower);
                            },
                        },
                        {
                            type: "menuitem",
                            text: "Huruf besar diawal kalimat",
                            onAction: function () {
                                editor.insertContent(isian.ucfirst);
                            },
                        },
                        {
                            type: "menuitem",
                            text: "Huruf Besar Tiap Kata",
                            onAction: function () {
                                editor.insertContent(isian.ucwords);
                            },
                        },
                        {
                            // Besar Semua
                            type: "menuitem",
                            text: "HURUF BESAR",
                            onAction: function () {
                                editor.insertContent(isian.upper);
                            },
                        },
                    ];
                },
            };
        }

        kode_isian.push(combine);
    });

    return kode_isian;
}
