<?php

/*
 *
 * File ini bagian dari:
 *
 * OpenSID
 *
 * Sistem informasi desa sumber terbuka untuk memajukan desa
 *
 * Aplikasi dan source code ini dirilis berdasarkan lisensi GPL V3
 *
 * Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * Hak Cipta 2016 - 2025 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 *
 * Dengan ini diberikan izin, secara gratis, kepada siapa pun yang mendapatkan salinan
 * dari perangkat lunak ini dan file dokumentasi terkait ("Aplikasi Ini"), untuk diperlakukan
 * tanpa batasan, termasuk hak untuk menggunakan, menyalin, mengubah dan/atau mendistribusikan,
 * asal tunduk pada syarat berikut:
 *
 * Pemberitahuan hak cipta di atas dan pemberitahuan izin ini harus disertakan dalam
 * setiap salinan atau bagian penting Aplikasi Ini. Barang siapa yang menghapus atau menghilangkan
 * pemberitahuan ini melanggar ketentuan lisensi Aplikasi Ini.
 *
 * PERANGKAT LUNAK INI DISEDIAKAN "SEBAGAIMANA ADANYA", TANPA JAMINAN APA PUN, BAIK TERSURAT MAUPUN
 * TERSIRAT. PENULIS ATAU PEMEGANG HAK CIPTA SAMA SEKALI TIDAK BERTANGGUNG JAWAB ATAS KLAIM, KERUSAKAN ATAU
 * KEWAJIBAN APAPUN ATAS PENGGUNAAN ATAU LAINNYA TERKAIT APLIKASI INI.
 *
 * @package   OpenSID
 * @author    Tim Pengembang OpenDesa
 * @copyright Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * @copyright Hak Cipta 2016 - 2025 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 * @license   http://www.gnu.org/licenses/gpl.html GPL V3
 * @link      https://github.com/OpenSID/OpenSID
 *
 */

defined('BASEPATH') || exit('No direct script access allowed');

class SettingModul extends CI_Model
{
    public function getData()
    {
        return [
            [
                'modul'      => 'Home',
                'slug'       => 'home',
                'url'        => 'beranda',
                'aktif'      => 1,
                'ikon'       => 'fa-home',
                'urut'       => 10,
                'level'      => 2,
                'hidden'     => 1,
                'ikon_kecil' => 'fa fa-home',
                'parent'     => 0,
            ],
            [
                'modul'      => 'Pengaturan Peta',
                'slug'       => 'pengaturan-peta',
                'url'        => 'plan',
                'aktif'      => 1,
                'ikon'       => 'fa-location-arrow',
                'urut'       => 9,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa fa-location-arrow',
                'parent'     => 9,
            ],
            [
                'modul'      => 'Identitas [Desa]',
                'slug'       => 'identitas-desa',
                'url'        => 'identitas_desa',
                'aktif'      => 1,
                'ikon'       => 'fa-id-card',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 200,
            ],
            [
                'modul'      => '[Pemerintah Desa]',
                'slug'       => 'pemerintah-desa',
                'url'        => 'pengurus/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-sitemap',
                'urut'       => 3,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 200,
            ],
            [
                'modul'      => 'Wilayah Administratif',
                'slug'       => 'wilayah-administratif',
                'url'        => 'wilayah/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-map',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 200,
            ],
            [
                'modul'      => 'Penduduk',
                'slug'       => 'penduduk',
                'url'        => 'penduduk/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-user',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 2,
            ],
            [
                'modul'      => 'Keluarga',
                'slug'       => 'keluarga',
                'url'        => 'keluarga/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-users',
                'urut'       => 3,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 2,
            ],
            [
                'modul'      => 'Rumah Tangga',
                'slug'       => 'rumah-tangga',
                'url'        => 'rtm/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-venus-mars',
                'urut'       => 4,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 2,
            ],
            [
                'modul'      => 'Kelompok',
                'slug'       => 'kelompok',
                'url'        => 'kelompok/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-sitemap',
                'urut'       => 5,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 2,
            ],
            [
                'modul'      => 'Data Suplemen',
                'slug'       => 'data-suplemen',
                'url'        => 'suplemen/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-slideshare',
                'urut'       => 6,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 2,
            ],
            [
                'modul'      => 'Calon Pemilih',
                'slug'       => 'calon-pemilih',
                'url'        => 'dpt/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-podcast',
                'urut'       => 7,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 2,
            ],
            [
                'modul'      => 'Statistik Kependudukan',
                'slug'       => 'statistik-kependudukan',
                'url'        => 'statistik/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-bar-chart',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 3,
            ],
            [
                'modul'      => 'Laporan Bulanan',
                'slug'       => 'laporan-bulanan',
                'url'        => 'laporan/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-file-text',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 3,
            ],
            [
                'modul'      => 'Laporan Kelompok Rentan',
                'slug'       => 'laporan-kelompok-rentan',
                'url'        => 'laporan_rentan/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-wheelchair',
                'urut'       => 3,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 3,
            ],
            [
                'modul'      => 'Pengaturan Surat',
                'slug'       => 'pengaturan-surat',
                'url'        => 'surat_master',
                'aktif'      => 1,
                'ikon'       => 'fa-cog',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 4,
            ],
            [
                'modul'      => 'Cetak Surat',
                'slug'       => 'cetak-surat',
                'url'        => 'surat',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 4,
            ],
            [
                'modul'      => 'Arsip Layanan',
                'slug'       => 'arsip-layanan',
                'url'        => 'keluar/clear/masuk',
                'aktif'      => 1,
                'ikon'       => 'fa-folder-open',
                'urut'       => 4,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 4,
            ],
            [
                'modul'      => 'Kirim Pesan',
                'slug'       => 'kirim-pesan',
                'url'        => 'sms',
                'aktif'      => 1,
                'ikon'       => 'fa-envelope-open-o',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 10,
            ],
            [
                'modul'      => 'Daftar Kontak',
                'slug'       => 'daftar-kontak',
                'url'        => 'daftar_kontak',
                'aktif'      => 1,
                'ikon'       => 'fa-id-card-o',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 10,
            ],
            [
                'modul'      => 'Modul',
                'slug'       => 'modul',
                'url'        => 'modul/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-tags',
                'urut'       => 1,
                'level'      => 1,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 11,
            ],
            [
                'modul'      => 'Aplikasi',
                'slug'       => 'aplikasi',
                'url'        => 'setting',
                'aktif'      => 1,
                'ikon'       => 'fa-codepen',
                'urut'       => 2,
                'level'      => 1,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 11,
            ],
            [
                'modul'      => 'Pengguna',
                'slug'       => 'pengguna',
                'url'        => 'man_user/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-users',
                'urut'       => 3,
                'level'      => 1,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 11,
            ],
            [
                'modul'      => 'Database',
                'slug'       => 'database',
                'url'        => 'database',
                'aktif'      => 1,
                'ikon'       => 'fa-database',
                'urut'       => 4,
                'level'      => 1,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 11,
            ],
            [
                'modul'      => 'Info Sistem',
                'slug'       => 'info-sistem',
                'url'        => 'info_sistem',
                'aktif'      => 1,
                'ikon'       => 'fa-server',
                'urut'       => 5,
                'level'      => 1,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 11,
            ],
            [
                'modul'      => 'Artikel',
                'slug'       => 'artikel',
                'url'        => 'web/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-file-movie-o',
                'urut'       => 1,
                'level'      => 4,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Widget',
                'slug'       => 'widget',
                'url'        => 'web_widget/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-windows',
                'urut'       => 2,
                'level'      => 4,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Menu',
                'slug'       => 'menu',
                'url'        => 'menu/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-bars',
                'urut'       => 3,
                'level'      => 4,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Komentar',
                'slug'       => 'komentar',
                'url'        => 'komentar/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-comments',
                'urut'       => 4,
                'level'      => 4,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Galeri',
                'slug'       => 'galeri',
                'url'        => 'gallery/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-image',
                'urut'       => 5,
                'level'      => 5,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Media Sosial',
                'slug'       => 'media-sosial',
                'url'        => 'sosmed',
                'aktif'      => 1,
                'ikon'       => 'fa-facebook',
                'urut'       => 7,
                'level'      => 4,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Slider',
                'slug'       => 'slider',
                'url'        => 'web/slider',
                'aktif'      => 1,
                'ikon'       => 'fa-film',
                'urut'       => 8,
                'level'      => 4,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Kotak Pesan',
                'slug'       => 'kotak-pesan',
                'url'        => 'mailbox/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-wechat',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 14,
            ],
            [
                'modul'      => 'Pendaftar Layanan Mandiri',
                'slug'       => 'pendaftar-layanan-mandiri',
                'url'        => 'mandiri/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-500px',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 14,
            ],
            [
                'modul'      => 'Surat Masuk',
                'slug'       => 'surat-masuk',
                'url'        => 'surat_masuk/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-sign-in',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'Surat Keluar',
                'slug'       => 'surat-keluar',
                'url'        => 'surat_keluar/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-sign-out',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'Inventaris',
                'slug'       => 'inventaris',
                'url'        => 'inventaris_tanah',
                'aktif'      => 1,
                'ikon'       => 'fa-cubes',
                'urut'       => 5,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'Peta',
                'slug'       => 'peta',
                'url'        => 'gis/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-globe',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa fa-globe',
                'parent'     => 9,
            ],
            [
                'modul'      => 'Klasifikasi Surat',
                'slug'       => 'klasifikasi-surat',
                'url'        => 'klasifikasi/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-code',
                'urut'       => 10,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-code',
                'parent'     => 15,
            ],
            [
                'modul'      => 'Teks Berjalan',
                'slug'       => 'teks-berjalan',
                'url'        => 'teks_berjalan',
                'aktif'      => 1,
                'ikon'       => 'fa-ellipsis-h',
                'urut'       => 9,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-ellipsis-h',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Kategori',
                'slug'       => 'kategori',
                'url'        => 'kategori',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 12,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Log Penduduk',
                'slug'       => 'log-penduduk',
                'url'        => 'penduduk_log',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 8,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 2,
            ],
            [
                'modul'      => 'analisis_kategori',
                'slug'       => 'analisis-kategori',
                'url'        => 'analisis_kategori',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 5,
            ],
            [
                'modul'      => 'analisis_indikator',
                'slug'       => 'analisis-indikator',
                'url'        => 'analisis_indikator',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 5,
            ],
            [
                'modul'      => 'analisis_klasifikasi',
                'slug'       => 'analisis-klasifikasi',
                'url'        => 'analisis_klasifikasi',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 5,
            ],
            [
                'modul'      => 'analisis_periode',
                'slug'       => 'analisis-periode',
                'url'        => 'analisis_periode',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 5,
            ],
            [
                'modul'      => 'analisis_respon',
                'slug'       => 'analisis-respon',
                'url'        => 'analisis_respon',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 5,
            ],
            [
                'modul'      => 'analisis_laporan',
                'slug'       => 'analisis-laporan',
                'url'        => 'analisis_laporan',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 5,
            ],
            [
                'modul'      => 'analisis_statistik_jawaban',
                'slug'       => 'analisis-statistik-jawaban',
                'url'        => 'analisis_statistik_jawaban',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 5,
            ],
            [
                'modul'      => 'api_inventaris_asset',
                'slug'       => 'api-inventaris-asset',
                'url'        => 'api_inventaris_asset',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 16,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'api_inventaris_gedung',
                'slug'       => 'api-inventaris-gedung',
                'url'        => 'api_inventaris_gedung',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 17,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'api_inventaris_gedung',
                'slug'       => 'api-inventaris-gedung-1',
                'url'        => 'api_inventaris_gedung',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 18,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'api_inventaris_jalan',
                'slug'       => 'api-inventaris-jalan',
                'url'        => 'api_inventaris_jalan',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 19,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'api_inventaris_konstruksi',
                'slug'       => 'api-inventaris-kontruksi',
                'url'        => 'api_inventaris_kontruksi',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 20,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'api_inventaris_peralatan',
                'slug'       => 'api-inventaris-peralatan',
                'url'        => 'api_inventaris_peralatan',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 21,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'api_inventaris_tanah',
                'slug'       => 'api-inventaris-tanah',
                'url'        => 'api_inventaris_tanah',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 22,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'inventaris_asset',
                'slug'       => 'inventaris-asset',
                'url'        => 'inventaris_asset',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 11,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'inventaris_gedung',
                'slug'       => 'inventaris-gedung',
                'url'        => 'inventaris_gedung',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 12,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'inventaris_jalan',
                'slug'       => 'inventaris-jalan',
                'url'        => 'inventaris_jalan',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 13,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'inventaris_kontruksi',
                'slug'       => 'inventaris-kontruksi',
                'url'        => 'inventaris_kontruksi',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 14,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'inventaris_peralatan',
                'slug'       => 'inventaris-peralatan',
                'url'        => 'inventaris_peralatan',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 15,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'laporan_inventaris',
                'slug'       => 'laporan-inventaris',
                'url'        => 'laporan_inventaris',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 23,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'plan',
                'slug'       => 'plan',
                'url'        => 'plan',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 11,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 9,
            ],
            [
                'modul'      => 'point',
                'slug'       => 'point',
                'url'        => 'point',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 12,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 9,
            ],
            [
                'modul'      => 'garis',
                'slug'       => 'garis',
                'url'        => 'garis',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 13,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 9,
            ],
            [
                'modul'      => 'line',
                'slug'       => 'line',
                'url'        => 'line',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 14,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 9,
            ],
            [
                'modul'      => 'area',
                'slug'       => 'area',
                'url'        => 'area',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 15,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 9,
            ],
            [
                'modul'      => 'polygon',
                'slug'       => 'polygon',
                'url'        => 'polygon',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 16,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 9,
            ],
            [
                'modul'      => 'Kategori Kelompok',
                'slug'       => 'kategori-kelompok',
                'url'        => 'kelompok_master',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 7,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 2,
            ],
            [
                'modul'      => 'Produk Hukum',
                'slug'       => 'produk-hukum',
                'url'        => 'dokumen_sekretariat/peraturan_desa',
                'aktif'      => 1,
                'ikon'       => 'fa-book',
                'urut'       => 3,
                'level'      => 2,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 15,
            ],
            [
                'modul'      => 'Informasi Publik',
                'slug'       => 'informasi-publik-1',
                'url'        => 'informasi_publik',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 52,
            ],
            [
                'modul'      => 'Daftar Persyaratan',
                'slug'       => 'daftar-persyaratan',
                'url'        => 'surat_mohon',
                'aktif'      => 1,
                'ikon'       => 'fa fa-book',
                'urut'       => 5,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 4,
            ],
            [
                'modul'      => 'Permohonan Surat',
                'slug'       => 'permohonan-surat',
                'url'        => 'permohonan_surat_admin',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 3,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 4,
            ],
            [
                'modul'      => 'Status [Desa]',
                'slug'       => 'status-desa',
                'url'        => 'status_desa',
                'aktif'      => 1,
                'ikon'       => 'fa-dot-circle-o',
                'urut'       => 4,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 200,
            ],
            [
                'modul'      => 'Pengaturan Grup',
                'slug'       => 'pengaturan-grup',
                'url'        => 'grup/clear',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 7,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 11,
            ],
            [
                'modul'      => 'Master Analisis',
                'slug'       => 'master-analisis',
                'url'        => 'analisis_master/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-check-square-o',
                'urut'       => 1,
                'level'      => 1,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-check-square-o',
                'parent'     => 5,
            ],
            [
                'modul'      => 'Pengaturan',
                'slug'       => 'pengaturan-analisis',
                'url'        => 'setting/analisis',
                'aktif'      => 1,
                'ikon'       => 'fa-gear',
                'urut'       => 2,
                'level'      => 1,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-gear',
                'parent'     => 5,
            ],
            [
                'modul'      => 'Impor Data',
                'slug'       => 'impor-data',
                'url'        => 'keuangan/impor_data',
                'aktif'      => 1,
                'ikon'       => 'fa-cloud-upload',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-cloud-upload',
                'parent'     => 201,
            ],
            [
                'modul'      => 'Laporan',
                'slug'       => 'laporan',
                'url'        => 'keuangan/laporan',
                'aktif'      => 1,
                'ikon'       => 'fa-bar-chart',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-bar-chart',
                'parent'     => 201,
            ],
            [
                'modul'      => 'Pengunjung',
                'slug'       => 'pengunjung',
                'url'        => 'pengunjung/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-bar-chart',
                'urut'       => 10,
                'level'      => 4,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 13,
            ],
            [
                'modul'      => 'Pendataan',
                'slug'       => 'pendataan',
                'url'        => 'covid19',
                'aktif'      => 1,
                'ikon'       => 'fa-list',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa fa-list',
                'parent'     => 206,
            ],
            [
                'modul'      => 'Pemantauan',
                'slug'       => 'pemantauan',
                'url'        => 'covid19/pantau',
                'aktif'      => 1,
                'ikon'       => 'fa-check',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa fa-check',
                'parent'     => 206,
            ],
            [
                'modul'      => 'Input Data',
                'slug'       => 'input-data',
                'url'        => 'keuangan_manual/manual_apbdes',
                'aktif'      => 1,
                'ikon'       => 'fa-keyboard-o',
                'urut'       => 3,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-keyboard-o',
                'parent'     => 201,
            ],
            [
                'modul'      => 'Laporan Manual',
                'slug'       => 'laporan-manual',
                'url'        => 'keuangan_manual/laporan_manual',
                'aktif'      => 1,
                'ikon'       => 'fa-bar-chart',
                'urut'       => 4,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-bar-chart',
                'parent'     => 201,
            ],
            [
                'modul'      => 'Pengaturan',
                'slug'       => 'pengaturan-web',
                'url'        => 'setting/web',
                'aktif'      => 1,
                'ikon'       => 'fa-gear',
                'urut'       => 11,
                'level'      => 4,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-gear',
                'parent'     => 13,
            ],
            [
                'modul'      => 'QR Code',
                'slug'       => 'qr-code',
                'url'        => 'setting/qrcode/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-qrcode',
                'urut'       => 6,
                'level'      => 1,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-qrcode',
                'parent'     => 11,
            ],
            [
                'modul'      => 'Daftar Persil',
                'slug'       => 'daftar-persil',
                'url'        => 'data_persil',
                'aktif'      => 1,
                'ikon'       => 'fa-list',
                'urut'       => 0,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 7,
            ],
            [
                'modul'      => 'C-Desa',
                'slug'       => 'c-desa',
                'url'        => 'cdesa',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 0,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 7,
            ],
            [
                'modul'      => 'Pembangunan',
                'slug'       => 'pembangunan',
                'url'        => 'admin_pembangunan',
                'aktif'      => 1,
                'ikon'       => 'fa-institution',
                'urut'       => 120,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-institution',
                'parent'     => 0,
            ],
            [
                'modul'      => 'Administrasi Umum',
                'slug'       => 'administrasi-umum',
                'url'        => 'bumindes_umum',
                'aktif'      => 1,
                'ikon'       => 'fa-bookmark',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa fa-bookmark',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Administrasi Penduduk',
                'slug'       => 'administrasi-penduduk',
                'url'        => 'bumindes_penduduk_induk/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-users',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa fa-users',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Administrasi Pembangunan',
                'slug'       => 'administrasi-pembangunan',
                'url'        => 'bumindes_rencana_pembangunan',
                'aktif'      => 1,
                'ikon'       => 'fa-university',
                'urut'       => 4,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa fa-university',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku Eskpedisi',
                'slug'       => 'buku-eskpedisi',
                'url'        => 'ekspedisi/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 10,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku Lembaran Dan Berita [Desa]',
                'slug'       => 'buku-lembaran-dan-berita-desa',
                'url'        => 'lembaran_desa/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 11,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Layanan Pelanggan',
                'slug'       => 'layanan-pelanggan',
                'url'        => 'pelanggan',
                'aktif'      => 1,
                'ikon'       => 'fa-credit-card',
                'urut'       => 5,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-credit-card',
                'parent'     => 200,
            ],
            [
                'modul'      => 'Pengaturan',
                'slug'       => 'pengaturan-layanan-mandiri',
                'url'        => 'setting/mandiri',
                'aktif'      => 1,
                'ikon'       => 'fa-gear',
                'urut'       => 6,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-gear',
                'parent'     => 14,
            ],
            [
                'modul'      => 'Buku Mutasi Penduduk',
                'slug'       => 'buku-mutasi-penduduk',
                'url'        => 'bumindes_penduduk_mutasi/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 15,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku Rekapitulasi Jumlah Penduduk',
                'slug'       => 'buku-rekapitulasi-jumlah-penduduk',
                'url'        => 'bumindes_penduduk_rekapitulasi/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 16,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku Penduduk Sementara',
                'slug'       => 'buku-penduduk-sementara',
                'url'        => 'bumindes_penduduk_sementara/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 17,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku KTP dan KK',
                'slug'       => 'buku-ktp-dan-kk',
                'url'        => 'bumindes_penduduk_ktpkk/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 18,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku Tanah Kas [Desa]',
                'slug'       => 'buku-tanah-kas-desa',
                'url'        => 'bumindes_tanah_kas_desa/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 12,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku Tanah di [Desa]',
                'slug'       => 'buku-tanah-di-desa',
                'url'        => 'bumindes_tanah_desa/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 13,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Pendapat',
                'slug'       => 'pendapat',
                'url'        => 'pendapat',
                'aktif'      => 1,
                'ikon'       => 'fa-thumbs-o-up',
                'urut'       => 5,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-thumbs-o-up',
                'parent'     => 14,
            ],
            [
                'modul'      => 'Buku Inventaris dan Kekayaan [Desa]',
                'slug'       => 'buku-inventaris-dan-kekayaan-desa',
                'url'        => 'bumindes_inventaris_kekayaan',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 14,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku Rencana Kerja Pembangunan',
                'slug'       => 'buku-rencana-kerja-pembangunan',
                'url'        => 'bumindes_rencana_pembangunan',
                'aktif'      => 1,
                'ikon'       => 'fa-files-o',
                'urut'       => 19,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Lapak',
                'slug'       => 'lapak',
                'url'        => 'lapak_admin',
                'aktif'      => 1,
                'ikon'       => 'fa-cart-plus',
                'urut'       => 122,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-cart-plus',
                'parent'     => 0,
            ],
            [
                'modul'      => 'Laporan APBDes',
                'slug'       => 'laporan-apbdes',
                'url'        => 'laporan_apbdes',
                'aktif'      => 1,
                'ikon'       => 'fa-file-text-o',
                'urut'       => 5,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-file-text-o',
                'parent'     => 201,
            ],
            [
                'modul'      => 'Sinkronisasi',
                'slug'       => 'sinkronisasi',
                'url'        => 'sinkronisasi',
                'aktif'      => 1,
                'ikon'       => ' fa-random',
                'urut'       => 125,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-random',
                'parent'     => 343,
            ],
            [
                'modul'      => 'Lembaga [Desa]',
                'slug'       => 'lembaga-desa',
                'url'        => 'lembaga/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-list',
                'urut'       => 4,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-list',
                'parent'     => 200,
            ],
            [
                'modul'      => 'Kategori Lembaga',
                'slug'       => 'kategori-lembaga',
                'url'        => 'lembaga_master',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => 6,
                'level'      => 2,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 200,
            ],
            [
                'modul'      => 'Bumindes Kegiatan Pembangunan',
                'slug'       => 'bumindes-kegiatan-pembangunan',
                'url'        => 'bumindes_kegiatan_pembangunan',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => null,
                'level'      => 2,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Laporan penduduk',
                'slug'       => 'laporan-penduduk',
                'url'        => 'laporan_penduduk',
                'aktif'      => 1,
                'ikon'       => 'fa-file-text-o',
                'urut'       => 5,
                'level'      => 2,
                'hidden'     => 1,
                'ikon_kecil' => 'fa-file-text-o',
                'parent'     => 3,
            ],
            [
                'modul'      => 'Pendaftaran Kerjasama',
                'slug'       => 'pendaftaran-kerjasama',
                'url'        => 'pendaftaran_kerjasama',
                'aktif'      => 1,
                'ikon'       => 'fa-list',
                'urut'       => 6,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-list',
                'parent'     => 200,
            ],
            [
                'modul'      => 'Kader Pemberdayaan Masyarakat',
                'slug'       => 'bumindes-kader',
                'url'        => 'bumindes_kader',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => null,
                'level'      => 2,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Buku Inventaris Hasil - Hasil Pembangunan',
                'slug'       => 'bumindes-hasil-pembangunan',
                'url'        => 'bumindes_hasil_pembangunan',
                'aktif'      => 1,
                'ikon'       => '',
                'urut'       => null,
                'level'      => 2,
                'hidden'     => 2,
                'ikon_kecil' => '',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Pengaduan',
                'slug'       => 'pengaduan',
                'url'        => 'pengaduan_admin',
                'aktif'      => 1,
                'ikon'       => 'fa-info',
                'urut'       => 124,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-info',
                'parent'     => 0,
            ],
            [
                'modul'      => 'Vaksin',
                'slug'       => 'vaksin',
                'url'        => 'vaksin_covid/clear',
                'aktif'      => 1,
                'ikon'       => 'fa fa-medkit',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => '',
                'parent'     => 206,
            ],
            [
                'modul'      => 'Arsip [Desa]',
                'slug'       => 'arsip-desa',
                'url'        => 'bumindes_arsip',
                'aktif'      => 1,
                'ikon'       => 'fa-archive',
                'urut'       => 5,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa fa-archive',
                'parent'     => 301,
            ],
            [
                'modul'      => 'Jam Kerja',
                'slug'       => 'jam-kerja',
                'url'        => 'kehadiran_jam_kerja',
                'aktif'      => 1,
                'ikon'       => 'fa-clock-o',
                'urut'       => 2,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-credit-card',
                'parent'     => 337,
            ],
            [
                'modul'      => 'Hari Libur',
                'slug'       => 'hari-libur',
                'url'        => 'kehadiran_hari_libur',
                'aktif'      => 1,
                'ikon'       => 'fa-calendar',
                'urut'       => 2,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-credit-card',
                'parent'     => 337,
            ],
            [
                'modul'      => 'Rekapitulasi',
                'slug'       => 'rekapitulasi',
                'url'        => 'kehadiran_rekapitulasi',
                'aktif'      => 1,
                'ikon'       => 'fa-list',
                'urut'       => 2,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-list',
                'parent'     => 337,
            ],
            [
                'modul'      => 'Pengaduan',
                'slug'       => 'kehadiran-pengaduan',
                'url'        => 'kehadiran_pengaduan',
                'aktif'      => 1,
                'ikon'       => 'fa-exclamation',
                'urut'       => 2,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-exclamation',
                'parent'     => 337,
            ],
            [
                'modul'      => 'Pesan',
                'slug'       => 'pesan',
                'url'        => 'opendk_pesan/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-envelope',
                'urut'       => 124,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-envelope',
                'parent'     => 343,
            ],
            [
                'modul'      => 'Grup Kontak',
                'slug'       => 'grup-kontak',
                'url'        => 'grup_kontak',
                'aktif'      => 1,
                'ikon'       => 'fa fa-list',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 2,
                'ikon_kecil' => 'fa fa-list',
                'parent'     => 10,
            ],
            [
                'modul'      => 'Stunting',
                'slug'       => 'stunting',
                'url'        => 'stunting',
                'aktif'      => 1,
                'ikon'       => 'fa-stethoscope',
                'urut'       => 4,
                'level'      => 0,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-stethoscope',
                'parent'     => 206,
            ],
            [
                'modul'      => 'Daftar Anjungan',
                'slug'       => 'daftar-anjungan',
                'url'        => 'anjungan',
                'aktif'      => 1,
                'ikon'       => 'fa-list',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-list',
                'parent'     => 312,
            ],
            [
                'modul'      => 'Menu',
                'slug'       => 'anjungan-menu',
                'url'        => 'anjungan_menu',
                'aktif'      => 1,
                'ikon'       => 'fa-bars',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-bars',
                'parent'     => 312,
            ],
            [
                'modul'      => 'Pengaturan',
                'slug'       => 'pengaturan-anjungan',
                'url'        => 'anjungan_pengaturan',
                'aktif'      => 1,
                'ikon'       => 'fa-gear',
                'urut'       => 3,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-gear',
                'parent'     => 312,
            ],
            [
                'modul'      => 'Alasan Keluar',
                'slug'       => 'alasan-keluar',
                'url'        => 'kehadiran_keluar',
                'aktif'      => 1,
                'ikon'       => 'fa-sign-out',
                'urut'       => 5,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-sign-out',
                'parent'     => 337,
            ],
            [
                'modul'      => 'Gawai Layanan',
                'slug'       => 'gawai-layanan',
                'url'        => 'gawai_layanan',
                'aktif'      => 1,
                'ikon'       => 'fa-desktop',
                'urut'       => 3,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-desktop',
                'parent'     => 14,
            ],
            [
                'modul'      => 'DTKS',
                'slug'       => 'dtks',
                'url'        => 'dtks',
                'aktif'      => 1,
                'ikon'       => 'fa-exchange',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-exchange',
                'parent'     => 352,
            ],
            [
                'modul'      => 'Data Tamu',
                'slug'       => 'data-tamu',
                'url'        => 'buku_tamu',
                'aktif'      => 1,
                'ikon'       => 'fa-bookmark-o',
                'urut'       => 1,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-bookmark-o',
                'parent'     => 354,
            ],
            [
                'modul'      => 'Data Kepuasan',
                'slug'       => 'data-kepuasan',
                'url'        => 'buku_kepuasan',
                'aktif'      => 1,
                'ikon'       => 'fa-smile-o',
                'urut'       => 2,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-smile-o',
                'parent'     => 354,
            ],
            [
                'modul'      => 'Data Pertanyaan',
                'slug'       => 'data-pertanyaan',
                'url'        => 'buku_pertanyaan',
                'aktif'      => 1,
                'ikon'       => 'fa-question',
                'urut'       => 3,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-question',
                'parent'     => 354,
            ],
            [
                'modul'      => 'Data Keperluan',
                'slug'       => 'data-keperluan',
                'url'        => 'buku_keperluan',
                'aktif'      => 1,
                'ikon'       => 'fa-send',
                'urut'       => 4,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-send',
                'parent'     => 354,
            ],
            [
                'modul'      => 'Optimasi Gambar',
                'slug'       => 'optimasi-gambar',
                'url'        => 'optimasi_gambar',
                'aktif'      => 1,
                'ikon'       => 'fa-picture-o',
                'urut'       => 7,
                'level'      => 2,
                'hidden'     => 0,
                'ikon_kecil' => 'fa-picture-o',
                'parent'     => 11,
            ],
            [
                'modul'      => 'Program Bantuan',
                'slug'       => 'program-bantuan',
                'url'        => 'program_bantuan/clear',
                'aktif'      => 1,
                'ikon'       => 'fa-heart',
                'urut'       => 101,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => 'fa-heart',
                'parent'     => 6,
            ],
            [
                'modul'      => 'Peserta Bantuan',
                'slug'       => 'peserta-bantuan',
                'url'        => 'peserta_bantuan',
                'aktif'      => 1,
                'ikon'       => 'fa-picture-o',
                'urut'       => 102,
                'level'      => 0,
                'hidden'     => 2,
                'ikon_kecil' => 'fa-picture-o',
                'parent'     => 6,
            ],
        ];
    }
}
