<?php

/*
 *
 * File ini bagian dari:
 *
 * OpenSID
 *
 * Sistem informasi desa sumber terbuka untuk memajukan desa
 *
 * Aplikasi dan source code ini dirilis berdasarkan lisensi GPL V3
 *
 * Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * Hak Cipta 2016 - 2025 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 *
 * Dengan ini diberikan izin, secara gratis, kepada siapa pun yang mendapatkan salinan
 * dari perangkat lunak ini dan file dokumentasi terkait ("Aplikasi Ini"), untuk diperlakukan
 * tanpa batasan, termasuk hak untuk menggunakan, menyalin, mengubah dan/atau mendistribusikan,
 * asal tunduk pada syarat berikut:
 *
 * Pemberitahuan hak cipta di atas dan pemberitahuan izin ini harus disertakan dalam
 * setiap salinan atau bagian penting Aplikasi Ini. Barang siapa yang menghapus atau menghilangkan
 * pemberitahuan ini melanggar ketentuan lisensi Aplikasi Ini.
 *
 * PERANGKAT LUNAK INI DISEDIAKAN "SEBAGAIMANA ADANYA", TANPA JAMINAN APA PUN, BAIK TERSURAT MAUPUN
 * TERSIRAT. PENULIS ATAU PEMEGANG HAK CIPTA SAMA SEKALI TIDAK BERTANGGUNG JAWAB ATAS KLAIM, KERUSAKAN ATAU
 * KEWAJIBAN APAPUN ATAS PENGGUNAAN ATAU LAINNYA TERKAIT APLIKASI INI.
 *
 * @package   OpenSID
 * @author    Tim Pengembang OpenDesa
 * @copyright Hak Cipta 2009 - 2015 Combine Resource Institution (http://lumbungkomunitas.net/)
 * @copyright Hak Cipta 2016 - 2025 Perkumpulan Desa Digital Terbuka (https://opendesa.id)
 * @license   http://www.gnu.org/licenses/gpl.html GPL V3
 * @link      https://github.com/OpenSID/OpenSID
 *
 */

defined('BASEPATH') || exit('No direct script access allowed');

class Twebaset extends CI_Model
{
    public function getData()
    {
        return [
            [
                'id_aset'          => 1,
                'golongan'         => '2',
                'bidang'           => '00',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH',
            ],
            [
                'id_aset'          => 2,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH DESA',
            ],
            [
                'id_aset'          => 3,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH KAS DESA',
            ],
            [
                'id_aset'          => 4,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH BENGKOK',
            ],
            [
                'id_aset'          => 5,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH BENGKOK KEPALA DESA',
            ],
            [
                'id_aset'          => 6,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH BENGKOK LAINNYA',
            ],
            [
                'id_aset'          => 7,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH BONDO',
            ],
            [
                'id_aset'          => 8,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH KALAKERAN NEGERI',
            ],
            [
                'id_aset'          => 9,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PECATU',
            ],
            [
                'id_aset'          => 10,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PENGAREM-AREM',
            ],
            [
                'id_aset'          => 11,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH TITISARA',
            ],
            [
                'id_aset'          => 12,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PERKAMPUNGAN',
            ],
            [
                'id_aset'          => 13,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PERKAMPUNGAN',
            ],
            [
                'id_aset'          => 14,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH PERKAMPUNGAN',
            ],
            [
                'id_aset'          => 15,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH PERKAMPUNGAN LAINNYA',
            ],
            [
                'id_aset'          => 16,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'EMPLASMEN',
            ],
            [
                'id_aset'          => 17,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'EMPLASMEN',
            ],
            [
                'id_aset'          => 18,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'EMPLASMEN LAINNYA',
            ],
            [
                'id_aset'          => 19,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH KUBURAN',
            ],
            [
                'id_aset'          => 20,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH KUBURAN ISLAM',
            ],
            [
                'id_aset'          => 21,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH KUBURAN KRISTEN',
            ],
            [
                'id_aset'          => 22,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH KUBURAN CINA',
            ],
            [
                'id_aset'          => 23,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH KUBURAN HINDU',
            ],
            [
                'id_aset'          => 24,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH KUBURAN BUDHA',
            ],
            [
                'id_aset'          => 25,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH MAKAM PAHLAWAN',
            ],
            [
                'id_aset'          => 26,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH KUBURAN TEMPAT BENDA BERSEJARAH',
            ],
            [
                'id_aset'          => 27,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH MAKAM UMUM/KUBURAN UMUM',
            ],
            [
                'id_aset'          => 28,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH KUBURAN LAINNYA',
            ],
            [
                'id_aset'          => 29,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PERTANIAN',
            ],
            [
                'id_aset'          => 30,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'SAWAH SATU TAHUN DITANAMI',
            ],
            [
                'id_aset'          => 31,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SAWAH DITANAMI PADI',
            ],
            [
                'id_aset'          => 32,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SAWAH DITANAMI PALAWIJA',
            ],
            [
                'id_aset'          => 33,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'SAWAH DITANAMI TEBU',
            ],
            [
                'id_aset'          => 34,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'SAWAH DITANAMI SAYURAN',
            ],
            [
                'id_aset'          => 35,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'SAWAH DITANAMI TEMBAKAU',
            ],
            [
                'id_aset'          => 36,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'SAWAH DITANAMI ROSELLA',
            ],
            [
                'id_aset'          => 37,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'SAWAH DITANAMI LAINNYA',
            ],
            [
                'id_aset'          => 38,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH KERING/TEGALAN',
            ],
            [
                'id_aset'          => 39,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH KERING DITANAMI BUAH-BUAHAN',
            ],
            [
                'id_aset'          => 40,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH KERING DITANAMI TEMBAKAU',
            ],
            [
                'id_aset'          => 41,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH KERING DITANAMI JAGUNG',
            ],
            [
                'id_aset'          => 42,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH KERING DITANAMI KETELA POHON',
            ],
            [
                'id_aset'          => 43,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH KERING DITANAMI KACANG TANAH',
            ],
            [
                'id_aset'          => 44,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH KERING DITANAMI KACANG HIJAU',
            ],
            [
                'id_aset'          => 45,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH KERING DITANAMI KEDELAI',
            ],
            [
                'id_aset'          => 46,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH KERING DITANAMI UBI JALAR',
            ],
            [
                'id_aset'          => 47,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH KERING DITANAMI KELADI',
            ],
            [
                'id_aset'          => 48,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH KERING DITANAMI LAINNYA',
            ],
            [
                'id_aset'          => 49,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'LADANG',
            ],
            [
                'id_aset'          => 50,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'LADANG PADI',
            ],
            [
                'id_aset'          => 51,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'LADANG JAGUNG',
            ],
            [
                'id_aset'          => 52,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'LADANG KETELA POHON',
            ],
            [
                'id_aset'          => 53,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'LADANG KACANG TANAH',
            ],
            [
                'id_aset'          => 54,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'LADANG KACANG HIJAU',
            ],
            [
                'id_aset'          => 55,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'LADANG KEDELAI',
            ],
            [
                'id_aset'          => 56,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '007',
                'nama'             => 'LADANG UBI JALAR',
            ],
            [
                'id_aset'          => 57,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '008',
                'nama'             => 'LADANG KELADI',
            ],
            [
                'id_aset'          => 58,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '009',
                'nama'             => 'LADANG BENGKUANG',
            ],
            [
                'id_aset'          => 59,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '010',
                'nama'             => 'LADANG APEL',
            ],
            [
                'id_aset'          => 60,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '011',
                'nama'             => 'LADANG KENTANG',
            ],
            [
                'id_aset'          => 61,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '012',
                'nama'             => 'LADANG JERUK',
            ],
            [
                'id_aset'          => 62,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'LADANG LAINNYA',
            ],
            [
                'id_aset'          => 63,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PERKEBUNAN',
            ],
            [
                'id_aset'          => 64,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PERKEBUNAN',
            ],
            [
                'id_aset'          => 65,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH PERKEBUNAN KARET',
            ],
            [
                'id_aset'          => 66,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH PERKEBUNAN KOPI',
            ],
            [
                'id_aset'          => 67,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH PERKEBUNAN KELAPA',
            ],
            [
                'id_aset'          => 68,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH PERKEBUNAN RANDU',
            ],
            [
                'id_aset'          => 69,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH PERKEBUNAN LADA',
            ],
            [
                'id_aset'          => 70,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH PERKEBUNAN TEH',
            ],
            [
                'id_aset'          => 71,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH PERKEBUNAN KINA',
            ],
            [
                'id_aset'          => 72,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH PERKEBUNAN COKLAT',
            ],
            [
                'id_aset'          => 73,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH PERKEBUNAN KELAPA SAWIT',
            ],
            [
                'id_aset'          => 74,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TANAH PERKEBUNAN SEREH',
            ],
            [
                'id_aset'          => 75,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TANAH PERKEBUNAN CENGKEH',
            ],
            [
                'id_aset'          => 76,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '012',
                'nama'             => 'TANAH PERKEBUNAN PALA',
            ],
            [
                'id_aset'          => 77,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '013',
                'nama'             => 'TANAH PERKEBUNAN SAGU',
            ],
            [
                'id_aset'          => 78,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '014',
                'nama'             => 'TANAH PERKEBUNAN JAMBU MENTE',
            ],
            [
                'id_aset'          => 79,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '015',
                'nama'             => 'TANAH PERKEBUNAN TENGKAWANG',
            ],
            [
                'id_aset'          => 80,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '016',
                'nama'             => 'TANAH PERKEBUNAN MINYAK KAYU PUTIH',
            ],
            [
                'id_aset'          => 81,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '017',
                'nama'             => 'TANAH PERKEBUNAN KAYU MANIS',
            ],
            [
                'id_aset'          => 82,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '018',
                'nama'             => 'TANAH PERKEBUNAN PETAI',
            ],
            [
                'id_aset'          => 83,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH PERKEBUNAN LAINNYA',
            ],
            [
                'id_aset'          => 84,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH HUTAN',
            ],
            [
                'id_aset'          => 85,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH HUTAN LEBAT (DITANAMI JENIS KAYU UTAMA)',
            ],
            [
                'id_aset'          => 86,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH HUTAN MERANTI',
            ],
            [
                'id_aset'          => 87,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH HUTAN RASAMALA',
            ],
            [
                'id_aset'          => 88,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH HUTAN BULIAN',
            ],
            [
                'id_aset'          => 89,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH HUTAN MEDANG',
            ],
            [
                'id_aset'          => 90,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH HUTAN JELUTUNG',
            ],
            [
                'id_aset'          => 91,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH HUTAN RAMIN',
            ],
            [
                'id_aset'          => 92,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH HUTAN PUSPA',
            ],
            [
                'id_aset'          => 93,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH HUTAN SUNINTEM',
            ],
            [
                'id_aset'          => 94,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH HUTAN ALBENIA',
            ],
            [
                'id_aset'          => 95,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TANAH HUTAN KAYU BESI/ULIN',
            ],
            [
                'id_aset'          => 96,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'HUTAN LEBAT LAINNYA',
            ],
            [
                'id_aset'          => 97,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH HUTAN BELUKAR',
            ],
            [
                'id_aset'          => 98,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH HUTAN SEMAK-SEMAK',
            ],
            [
                'id_aset'          => 99,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'HUTAN BELUKAR',
            ],
            [
                'id_aset'          => 100,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'HUTAN BELUKAR LAINNYA',
            ],
            [
                'id_aset'          => 101,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'HUTAN TANAMAN JENIS',
            ],
            [
                'id_aset'          => 102,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'HUTAN TANAMAN JATI',
            ],
            [
                'id_aset'          => 103,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'HUTAN TANAMAN PINUS',
            ],
            [
                'id_aset'          => 104,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'HUTAN TANAMAN ROTAN',
            ],
            [
                'id_aset'          => 105,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'HUTAN TANAMAN JENIS LAINNYA',
            ],
            [
                'id_aset'          => 106,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'HUTAN ALAM SEJENIS/HUTAN RAWA',
            ],
            [
                'id_aset'          => 107,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'HUTAN BAKAU',
            ],
            [
                'id_aset'          => 108,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'HUTAN CEMARA (YANG TIDAK DITANAMAN)',
            ],
            [
                'id_aset'          => 109,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'HUTAN GALAM',
            ],
            [
                'id_aset'          => 110,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'HUTAN NIPAH',
            ],
            [
                'id_aset'          => 111,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'HUTAN BAMBU',
            ],
            [
                'id_aset'          => 112,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '006',
                'nama'             => 'HUTAN ROTAN',
            ],
            [
                'id_aset'          => 113,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'HUTAN ALAM SEJENIS LAINNYA',
            ],
            [
                'id_aset'          => 114,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'HUTAN UNTUK PENGGUNAAN KHUSUS',
            ],
            [
                'id_aset'          => 115,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'HUTAN CADANGAN',
            ],
            [
                'id_aset'          => 116,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'HUTAN LINDUNG',
            ],
            [
                'id_aset'          => 117,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'HUTAN CAGAR ALAM',
            ],
            [
                'id_aset'          => 118,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'HUTAN TAMAN WISATA',
            ],
            [
                'id_aset'          => 119,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'HUTAN TAMAN BURUNG',
            ],
            [
                'id_aset'          => 120,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'HUTAN SUAKA MARGA SATWA',
            ],
            [
                'id_aset'          => 121,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'HUTAN TAMAN NASIONAL',
            ],
            [
                'id_aset'          => 122,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'HUTAN PRODUKSI',
            ],
            [
                'id_aset'          => 123,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '05',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'HUTAN UNTUK PENGGUNAAN KHUSUS LAINNYA',
            ],
            [
                'id_aset'          => 124,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '06',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH KEBUN CAMPURAN',
            ],
            [
                'id_aset'          => 125,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '06',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH YANG TIDAK ADA JARINGAN PENGAIRAN',
            ],
            [
                'id_aset'          => 126,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '06',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAMAN RUPA-RUPA',
            ],
            [
                'id_aset'          => 127,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '06',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH KEBUN CAMPURAN LAINNYA',
            ],
            [
                'id_aset'          => 128,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '06',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TUMBUH LIAR BERCAMPUR JENIS LAIN',
            ],
            [
                'id_aset'          => 129,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '06',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'JENIS TANAMAN RUPA-RUPA & TIDAK JELAS MANA YANG MENONJOL',
            ],
            [
                'id_aset'          => 130,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '06',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAMAN LUAR PERKARANGAN',
            ],
            [
                'id_aset'          => 131,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '06',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TUMBUH LIAR BERCAMPUR JENIS LAINNYA',
            ],
            [
                'id_aset'          => 132,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '07',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH KOLAM IKAN',
            ],
            [
                'id_aset'          => 133,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '07',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TAMBAK',
            ],
            [
                'id_aset'          => 134,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '07',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TAMBAK',
            ],
            [
                'id_aset'          => 135,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '07',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TAMBAK LAINNYA',
            ],
            [
                'id_aset'          => 136,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '07',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'AIR TAWAR',
            ],
            [
                'id_aset'          => 137,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '07',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'KOLAM AIR TAWAR',
            ],
            [
                'id_aset'          => 138,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '07',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'AIR TAWAR LAINNYA',
            ],
            [
                'id_aset'          => 139,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '08',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH DANAU / RAWA',
            ],
            [
                'id_aset'          => 140,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '08',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'RAWA',
            ],
            [
                'id_aset'          => 141,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '08',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'RAWA',
            ],
            [
                'id_aset'          => 142,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '08',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'RAWA LAINNYA',
            ],
            [
                'id_aset'          => 143,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '08',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'DANAU',
            ],
            [
                'id_aset'          => 144,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '08',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SANAU/SITU',
            ],
            [
                'id_aset'          => 145,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '08',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'WADUK',
            ],
            [
                'id_aset'          => 146,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '08',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'DANAU LAINNYA',
            ],
            [
                'id_aset'          => 147,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH TANDUS / RUSAK',
            ],
            [
                'id_aset'          => 148,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH TANDUS',
            ],
            [
                'id_aset'          => 149,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'BERBATU-BATU',
            ],
            [
                'id_aset'          => 150,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'LONGSOR',
            ],
            [
                'id_aset'          => 151,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH LAHAR',
            ],
            [
                'id_aset'          => 152,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH BERPASIR/PASIR',
            ],
            [
                'id_aset'          => 153,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH PENGAMBILAN/KUASI',
            ],
            [
                'id_aset'          => 154,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH TANDUS LAINNYA',
            ],
            [
                'id_aset'          => 155,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH RUSAK',
            ],
            [
                'id_aset'          => 156,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH YANG TEREROSI/LONGSOR',
            ],
            [
                'id_aset'          => 157,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'BEKAS TAMBANG/GALIAN',
            ],
            [
                'id_aset'          => 158,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'BEKAS SAWAH/RAWA',
            ],
            [
                'id_aset'          => 159,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '09',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH RUSAK LAINNYA',
            ],
            [
                'id_aset'          => 160,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '10',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH ALANG-ALANG DAN PADANG RUMPUT',
            ],
            [
                'id_aset'          => 161,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '10',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALANG-ALANG',
            ],
            [
                'id_aset'          => 162,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '10',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ALANG-ALANG',
            ],
            [
                'id_aset'          => 163,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '10',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALANG-ALANG LAINNYA',
            ],
            [
                'id_aset'          => 164,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '10',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PADANG RUMPUT',
            ],
            [
                'id_aset'          => 165,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '10',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SEMAK BELUKAR',
            ],
            [
                'id_aset'          => 166,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '10',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PADANG RUMPUT',
            ],
            [
                'id_aset'          => 167,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '10',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PADANG RUMPUT LAINNYA',
            ],
            [
                'id_aset'          => 168,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PERTAMBANGAN',
            ],
            [
                'id_aset'          => 169,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PERTAMBANGAN',
            ],
            [
                'id_aset'          => 170,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH PERTAMBANGAN INTAN',
            ],
            [
                'id_aset'          => 171,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH PERTAMBANGAN EMAS',
            ],
            [
                'id_aset'          => 172,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH PERTAMBANGAN PERAK',
            ],
            [
                'id_aset'          => 173,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH PERTAMBANGAN NEKEL',
            ],
            [
                'id_aset'          => 174,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH PERTAMBANGAN TIMAH',
            ],
            [
                'id_aset'          => 175,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH PERTAMBANGAN URANIUM',
            ],
            [
                'id_aset'          => 176,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH PERTAMBANGAN TEMBAGA',
            ],
            [
                'id_aset'          => 177,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH PERTAMBANGAN MINYAK BUMI',
            ],
            [
                'id_aset'          => 178,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH PERTAMBANGAN BATU BARA',
            ],
            [
                'id_aset'          => 179,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TANAH PERTAMBANGAN KOSLIN',
            ],
            [
                'id_aset'          => 180,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TANAH PERTAMBANGAN BATU BARA BERHARGA',
            ],
            [
                'id_aset'          => 181,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '012',
                'nama'             => 'TANAH PERTAMBANGAN PASIR BERHARGA',
            ],
            [
                'id_aset'          => 182,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '11',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH PERTAMBANGAN LAINNYA',
            ],
            [
                'id_aset'          => 183,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN GEDUNG',
            ],
            [
                'id_aset'          => 184,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH BANGUNAN PERUMAHAN/GDG. TEMPAT TINGGAL',
            ],
            [
                'id_aset'          => 185,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH BANGUNAN MESS',
            ],
            [
                'id_aset'          => 186,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH BANGUNAN WISMA',
            ],
            [
                'id_aset'          => 187,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH BANGUNAN ASRAMA',
            ],
            [
                'id_aset'          => 188,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH BANGUNAN PERISTIRAHATAN',
            ],
            [
                'id_aset'          => 189,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH BANGUNAN BUNGALAOW',
            ],
            [
                'id_aset'          => 190,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH BANGUNAN COTTAGE',
            ],
            [
                'id_aset'          => 191,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH BANGUNAN RUMAH TEMPAT TINGGAL LAINNYA',
            ],
            [
                'id_aset'          => 192,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN GEDUNG PERDAGANGAN',
            ],
            [
                'id_aset'          => 193,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH BANGUNAN PASAR',
            ],
            [
                'id_aset'          => 194,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH BANGUNAN PERTOKOAN/RUMAH TOKO',
            ],
            [
                'id_aset'          => 195,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH BANGUNAN GUDANG',
            ],
            [
                'id_aset'          => 196,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH BANGUNAN BIOSKOP',
            ],
            [
                'id_aset'          => 197,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH BANGUNAN HOTEL/PENGINAPAN',
            ],
            [
                'id_aset'          => 198,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH BANGUNAN TERMINAL DARAT',
            ],
            [
                'id_aset'          => 199,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH BANGUNAN TERMINAL LAUT',
            ],
            [
                'id_aset'          => 200,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH BANGUNAN GEDUNG KESENIAN',
            ],
            [
                'id_aset'          => 201,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH BANGUNAN GEDUNG PAMERAN',
            ],
            [
                'id_aset'          => 202,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TANAH BANGUNAN GEDUNG PUSAT PERBELANJAAN',
            ],
            [
                'id_aset'          => 203,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TANAH BANGUNAN APOTIK',
            ],
            [
                'id_aset'          => 204,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH BANGUNAN GEDUNG PERDAGANGAN LAINNYA',
            ],
            [
                'id_aset'          => 205,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN INDUSTRI',
            ],
            [
                'id_aset'          => 206,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH BANGUNAN INDUSTRI MAKANAN',
            ],
            [
                'id_aset'          => 207,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH BANGUNAN INDUSTRI MINUMAN',
            ],
            [
                'id_aset'          => 208,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH BANGUNAN INDUSTRI/ALAT RT.',
            ],
            [
                'id_aset'          => 209,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH BANGUNAN INDUSTRI PAKAIAN/GARMENT',
            ],
            [
                'id_aset'          => 210,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH BANGUNAN INDUSTRI BESI/LOGAM',
            ],
            [
                'id_aset'          => 211,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH BANGUNAN INDUSTRI BAJA',
            ],
            [
                'id_aset'          => 212,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH BANGUNAN INDUSTRI PENGALENGAN',
            ],
            [
                'id_aset'          => 213,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH BANGUNAN INDUSTRI BENGKEL',
            ],
            [
                'id_aset'          => 214,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH BANGUNAN INDUSTRI PENYULINGAN  MINYAK',
            ],
            [
                'id_aset'          => 215,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TANAH BANGUNAN INDUSTRI SEMEN',
            ],
            [
                'id_aset'          => 216,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TANAH BANGUNAN INDUSTRI BATU BATA/BATAKO',
            ],
            [
                'id_aset'          => 217,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '012',
                'nama'             => 'TANAH BANGUNAN INDUSTRI GENTENG',
            ],
            [
                'id_aset'          => 218,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '013',
                'nama'             => 'TANAH BANGUNAN INDUSTRI PERCETAKAN',
            ],
            [
                'id_aset'          => 219,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '014',
                'nama'             => 'TANAH BANGUNAN INDUSTRI TESKTIL',
            ],
            [
                'id_aset'          => 220,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '015',
                'nama'             => 'TANAH BANGUNAN INDUSTRI OBAT-OBATAN',
            ],
            [
                'id_aset'          => 221,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '016',
                'nama'             => 'TANAH BANGUNAN INDUSTRI ALAT OLAH RAGA',
            ],
            [
                'id_aset'          => 222,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '017',
                'nama'             => 'TANAH BANGUNAN INDUSTRI KENDARAAN/ OTOMOTIF',
            ],
            [
                'id_aset'          => 223,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '019',
                'nama'             => 'TANAH BANGUNAN INDUSTRI PERSENJATAAN',
            ],
            [
                'id_aset'          => 224,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '020',
                'nama'             => 'TANAH BANGUNAN INDUSTRI KAPAL UDARA',
            ],
            [
                'id_aset'          => 225,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '021',
                'nama'             => 'TANAH BANGUNAN INDUSTRI KAPAL LAUT',
            ],
            [
                'id_aset'          => 226,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '022',
                'nama'             => 'TANAH BANGUNAN INDUSTRI KAPAL API',
            ],
            [
                'id_aset'          => 227,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '023',
                'nama'             => 'TANAH BANGUNAN INDUSTRI KERAMIK/MARMER',
            ],
            [
                'id_aset'          => 228,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH BANGUNAN INDUSTRI LAINNYA',
            ],
            [
                'id_aset'          => 229,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN TEMPAT KERJA/JASA',
            ],
            [
                'id_aset'          => 230,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH BANGUNAN KANTOR PEMERINTAH',
            ],
            [
                'id_aset'          => 231,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH BANGUNAN SEKOLAH',
            ],
            [
                'id_aset'          => 232,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH BANGUNAN RUMAH SAKIT',
            ],
            [
                'id_aset'          => 233,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH BANGUNAN APOTIK',
            ],
            [
                'id_aset'          => 234,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH BANGUNAN TEMPAT IBADAH',
            ],
            [
                'id_aset'          => 235,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH BANGUNAN DERMAGA',
            ],
            [
                'id_aset'          => 236,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH BANGUNAN PELABUHAN UDARA',
            ],
            [
                'id_aset'          => 237,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH BANGUNAN OLAH RAGA',
            ],
            [
                'id_aset'          => 238,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH BANGUNAN TAMAN/WISATA/REKREASI',
            ],
            [
                'id_aset'          => 239,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TANAH BANGUNAN BALAI SIDANG/PERTEMUAN',
            ],
            [
                'id_aset'          => 240,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TANAH BANGUNAN BALAI NIKAH',
            ],
            [
                'id_aset'          => 241,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '012',
                'nama'             => 'TANAH BANGUNAN PUSKESMAS/POSYANDU',
            ],
            [
                'id_aset'          => 242,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '013',
                'nama'             => 'TANAH BANGUNAN POLIKLINIK',
            ],
            [
                'id_aset'          => 243,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '014',
                'nama'             => 'TANAH BANGUNAN LABORATURIUM',
            ],
            [
                'id_aset'          => 244,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '015',
                'nama'             => 'TANAH BANGUNAN FUMIGASI/STERLISASI',
            ],
            [
                'id_aset'          => 245,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '016',
                'nama'             => 'TANAH BANGUNAN KARANTINA',
            ],
            [
                'id_aset'          => 246,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '017',
                'nama'             => 'TANAH BANGUNAN BANGSAL PENGOLAHAN  PONDON KERJA',
            ],
            [
                'id_aset'          => 247,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '018',
                'nama'             => 'TANAH BANGUNAN KANDANG HEWAN',
            ],
            [
                'id_aset'          => 248,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '019',
                'nama'             => 'TANAH BANGUNAN-BANGUNAN PEMBIBITAN',
            ],
            [
                'id_aset'          => 249,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '020',
                'nama'             => 'TANAH BANGUNAN RUMAH PENDINGIN',
            ],
            [
                'id_aset'          => 250,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '021',
                'nama'             => 'TANAH BANGUNAN RUMAH PENGERING',
            ],
            [
                'id_aset'          => 251,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '022',
                'nama'             => 'TANAH BANGUNAN STASIUN PENELITIAN',
            ],
            [
                'id_aset'          => 252,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '023',
                'nama'             => 'TANAH BANGUNAN GEDUNG PELELANGAN IKAN',
            ],
            [
                'id_aset'          => 253,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '024',
                'nama'             => 'TANAH BANGUNAN POS JAGA/MENARA JAGA',
            ],
            [
                'id_aset'          => 254,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH BANGUNAN TEMPAT KERJA LAINNYA',
            ],
            [
                'id_aset'          => 255,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH KOSONG',
            ],
            [
                'id_aset'          => 256,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH SAWAH',
            ],
            [
                'id_aset'          => 257,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH TEGALAN',
            ],
            [
                'id_aset'          => 258,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH KEBUN',
            ],
            [
                'id_aset'          => 259,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'KEBUN PEMBIBITAN',
            ],
            [
                'id_aset'          => 260,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH KOSONG YANG TIDAK DIUSAHAKAN',
            ],
            [
                'id_aset'          => 261,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PETERNAKAN',
            ],
            [
                'id_aset'          => 262,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH PETERNAKAN',
            ],
            [
                'id_aset'          => 263,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH PETERNAKAN LAINNYA',
            ],
            [
                'id_aset'          => 264,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH BANGUNAN PENGAIRAN',
            ],
            [
                'id_aset'          => 265,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH WADUK',
            ],
            [
                'id_aset'          => 266,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH KOMPLEK BENDUNGAN',
            ],
            [
                'id_aset'          => 267,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH JARINGAN/SALURAN',
            ],
            [
                'id_aset'          => 268,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH BANGUNAN PENGAIRAN LAINNYA',
            ],
            [
                'id_aset'          => 269,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH BANGUNAN JALAN DAN JEMBATAN',
            ],
            [
                'id_aset'          => 270,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH JALAN',
            ],
            [
                'id_aset'          => 271,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH JEMBATAN',
            ],
            [
                'id_aset'          => 272,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH BANGUNAN JALAN DAN JEMBATAN LAINNYA',
            ],
            [
                'id_aset'          => 273,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH LEMBIRAN/BANTARAN/LEPE-LEPE/SETREN DST',
            ],
            [
                'id_aset'          => 274,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH LEMBIRAN PENGAIRAN',
            ],
            [
                'id_aset'          => 275,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH LEMBIRAN JALAN DAN JEMBATAN',
            ],
            [
                'id_aset'          => 276,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '12',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH LEMBIRAN LAINNYA',
            ],
            [
                'id_aset'          => 277,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN BUKAN GEDUNG',
            ],
            [
                'id_aset'          => 278,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH LAPANGAN OLAH RAGA',
            ],
            [
                'id_aset'          => 279,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH LAPANGAN TENIS',
            ],
            [
                'id_aset'          => 280,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH LAPANGAN BASKET',
            ],
            [
                'id_aset'          => 281,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH LAPANGAN BADMINTON/BULUTANGKIS',
            ],
            [
                'id_aset'          => 282,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH LAPANGAN GOLF',
            ],
            [
                'id_aset'          => 283,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH LAPANGAN SEPAK BOLA',
            ],
            [
                'id_aset'          => 284,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH LAPANGAN BOLA VOLLY',
            ],
            [
                'id_aset'          => 285,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH LAPANGAN SEPAK TAKRAW',
            ],
            [
                'id_aset'          => 286,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TAANH LAPANGAN PACUAN KUDA',
            ],
            [
                'id_aset'          => 287,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH LAPANGAN BALAP SEPEDA',
            ],
            [
                'id_aset'          => 288,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TANAH LAPANGAN ATLETIK',
            ],
            [
                'id_aset'          => 289,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TANAH LAPANGAN SOFTBALL',
            ],
            [
                'id_aset'          => 290,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH LAPANGAN OLAHRAGA LAINNYA',
            ],
            [
                'id_aset'          => 291,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH LAPANGAN PARKIR',
            ],
            [
                'id_aset'          => 292,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH LAPANGAN PARKIR KONTRUKSI BETON',
            ],
            [
                'id_aset'          => 293,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH LAPANGAN PARKIR KONTRUKSI ASPAL',
            ],
            [
                'id_aset'          => 294,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH LAPANGAN PARKIR SIRTU (PASIR BATU)',
            ],
            [
                'id_aset'          => 295,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH LAPANGAN PARKIR KONBLOK',
            ],
            [
                'id_aset'          => 296,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH LAPANGAN PARKIR TANAH KERAS',
            ],
            [
                'id_aset'          => 297,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH LAPANGAN PARKIR LAINNYA',
            ],
            [
                'id_aset'          => 298,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH LAPANGAN PENIMBUN BARANG',
            ],
            [
                'id_aset'          => 299,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH LAPANGAN PENIMBUN BARANG BELUM DIOLAH',
            ],
            [
                'id_aset'          => 300,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH LAPANGAN PENIMBUN BARANG JADI',
            ],
            [
                'id_aset'          => 301,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH LAPANGAN PENIMBUN PEMBUANGAN SAMPAH',
            ],
            [
                'id_aset'          => 302,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH LAPANGAN PENIMBUN BAHAN BANGUNAN',
            ],
            [
                'id_aset'          => 303,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH LAPANGAN PENIMBUN BARANG BUKTI',
            ],
            [
                'id_aset'          => 304,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH LAPANGAN PENIMBUN BARANG LAINNYA',
            ],
            [
                'id_aset'          => 305,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH LAPANGAN PEMANCAR DAN STUDIO ALAM',
            ],
            [
                'id_aset'          => 306,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH LAPANGAN PEMANCAR TV/RADIO/RADAR',
            ],
            [
                'id_aset'          => 307,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH LAPANGAN STUDIO ALAM',
            ],
            [
                'id_aset'          => 308,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH LAPANGAN PEMANCAR LAINNYA',
            ],
            [
                'id_aset'          => 309,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH LAPANGAN PEMANCAR DAN STUDIO ALAM LAINNYA',
            ],
            [
                'id_aset'          => 310,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH LAPANGAN PENGUJIAN/PENGOLAHAN',
            ],
            [
                'id_aset'          => 311,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH LAPANGAN PENGUJIAN KENDARAAN  BERMOTOR',
            ],
            [
                'id_aset'          => 312,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH LAPANGAN PENGELOLAAN BAHAN BANGUNAN',
            ],
            [
                'id_aset'          => 313,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH LAPANGAN PENGUJIAN/PENGOLAHAN LAINNYA',
            ],
            [
                'id_aset'          => 314,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH LAPANGAN TERBANG',
            ],
            [
                'id_aset'          => 315,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH LAPANGAN TERBANG PERINTIS',
            ],
            [
                'id_aset'          => 316,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH LAPNGAN KOMERSIAL',
            ],
            [
                'id_aset'          => 317,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH LAPANGAN TERBANG KHUSUS/MILITER',
            ],
            [
                'id_aset'          => 318,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH LAOPANGAN TERBANG OLAH RAGA',
            ],
            [
                'id_aset'          => 319,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH LAPANGAN TERBANG PENDIDIKAN',
            ],
            [
                'id_aset'          => 320,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH LAPANGAN TERBANG LAINNYA',
            ],
            [
                'id_aset'          => 321,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN JALAN',
            ],
            [
                'id_aset'          => 322,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH UNTUK JALAN NASIONAL',
            ],
            [
                'id_aset'          => 323,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH UNTUK JALAN PROPINSI',
            ],
            [
                'id_aset'          => 324,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH UNTUK JALAN KABUPATEN',
            ],
            [
                'id_aset'          => 325,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH UNTUK JALAN KOTAMADYA',
            ],
            [
                'id_aset'          => 326,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH UNTUK JALAN DESA',
            ],
            [
                'id_aset'          => 327,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH UNTUK JALAN TOL',
            ],
            [
                'id_aset'          => 328,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH UNTUK JALAN KERETA API/LORI',
            ],
            [
                'id_aset'          => 329,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TANAH UNTUK JALAN LANDASAN PACU PESAWAT TERBANG',
            ],
            [
                'id_aset'          => 330,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANAH UNTUK JALAN KHUSUS/KOMPLEK',
            ],
            [
                'id_aset'          => 331,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH UNTUK BANGUNAN JALAN LAINNYA',
            ],
            [
                'id_aset'          => 332,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN AIR',
            ],
            [
                'id_aset'          => 333,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH UNTUK BANGUNAN AIR IRIGASI',
            ],
            [
                'id_aset'          => 334,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH UNTUK BANGUNAN PENGAIRAN PASANG SURUT',
            ],
            [
                'id_aset'          => 335,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH UNTUK BANGUNAN PENGEMBANGAN RAWA DAN POLDER',
            ],
            [
                'id_aset'          => 336,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH UNTUK BANGUNAN PENGAMAN SUNGAI DAN PENANGGULANGAN BENCANA ALAM',
            ],
            [
                'id_aset'          => 337,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH UNTUK BANGUNAN PENGEMBANGAN SUMBER AIR DAN AIR TNH',
            ],
            [
                'id_aset'          => 338,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH UNTUK BANGUNAN AIR BERSIH/AIR BAKU',
            ],
            [
                'id_aset'          => 339,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH UNTUK BANGUNAN AIR KOTOR',
            ],
            [
                'id_aset'          => 340,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH UNTUK BANGUNAN AIR LAINNYA',
            ],
            [
                'id_aset'          => 341,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN INSTALASI',
            ],
            [
                'id_aset'          => 342,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH UNTUK BANGUNAN INSTALASI AIR BERSIH/AIR BAKU',
            ],
            [
                'id_aset'          => 343,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH UNTUK BANGUNAN INSTALASI AIR KOTOR/AIR LIMBAH',
            ],
            [
                'id_aset'          => 344,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH UNTUK BANGUNAN INSTALASI PENGELOHAN SAMPAH',
            ],
            [
                'id_aset'          => 345,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH UNTUK BANGUNAN INSTALASI PENGOLAHAN BAHAN BANGUNAN',
            ],
            [
                'id_aset'          => 346,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH UNTUK BANGUNAN INSTALASI LISTRIK',
            ],
            [
                'id_aset'          => 347,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH UNTUK BANGUNAN INSTALASI GARDU LISTRIK',
            ],
            [
                'id_aset'          => 348,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANAH UNTUK BANGUNAN PANGOLAHAN LIMBAH',
            ],
            [
                'id_aset'          => 349,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH UNTUK BANGUNAN INSTALASI LAINNYA',
            ],
            [
                'id_aset'          => 350,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN JARINGAN',
            ],
            [
                'id_aset'          => 351,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH UNTUK BANGUNAN JARINGAN AIR BERSIH/AIR BAKU',
            ],
            [
                'id_aset'          => 352,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH UNTUK BANGUNAN JARINGAN KOMUNIKASI',
            ],
            [
                'id_aset'          => 353,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH UNTUK BANGUNAN JARINGAN LISTRIK',
            ],
            [
                'id_aset'          => 354,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH UNTUK BANGUNAN JARINGAN GAS/BBM',
            ],
            [
                'id_aset'          => 355,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH UNTUK BANGUNAN JARINGAN LAINNYA',
            ],
            [
                'id_aset'          => 356,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN BERSEJARAH',
            ],
            [
                'id_aset'          => 357,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH UNTUK MONUMEN',
            ],
            [
                'id_aset'          => 358,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH UNTUK TUGU PERINGATAN',
            ],
            [
                'id_aset'          => 359,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH UNTUK TUGU BATAS WILAYAH',
            ],
            [
                'id_aset'          => 360,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH UNTUK CANDI',
            ],
            [
                'id_aset'          => 361,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH UNTUK BANGUNAN MOSEUM',
            ],
            [
                'id_aset'          => 362,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH UNTUK BANGUNAN BERSEJARAH',
            ],
            [
                'id_aset'          => 363,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH UNTUK BANGUNAN BERSEJARAH LAINNYA',
            ],
            [
                'id_aset'          => 364,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN GEDUNG OLAH RAGA',
            ],
            [
                'id_aset'          => 365,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH BANGUNAN SARANA OLAOH RAGA TERBATAS',
            ],
            [
                'id_aset'          => 366,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH BANGUNAN SARANA OLAH RAGA TERBUKA',
            ],
            [
                'id_aset'          => 367,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH BANGUNAN SARANA OLAH RAGA LAINNYA',
            ],
            [
                'id_aset'          => 368,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH UNTUK BANGUNAN TEMPAT IBADAH',
            ],
            [
                'id_aset'          => 369,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANAH UNTUK BANGUNAN MESJID',
            ],
            [
                'id_aset'          => 370,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANAH UNTUK BANGUNAN GEREJA',
            ],
            [
                'id_aset'          => 371,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TANAH UNTUK BANGUNAN PURA',
            ],
            [
                'id_aset'          => 372,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TANAH UNTUK BANGUNAN VIHARA',
            ],
            [
                'id_aset'          => 373,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TANAH UNTUK BANGUNAN KLENTENG/KUIL',
            ],
            [
                'id_aset'          => 374,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANAH UNTUK BANGUNAN KREMATORIUM',
            ],
            [
                'id_aset'          => 375,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '13',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH UNTUK BANGUNAN TAMPAT IBADAH LAINNYA',
            ],
            [
                'id_aset'          => 376,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '14',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TANAH PENGGUNAAN LAINNYA',
            ],
            [
                'id_aset'          => 377,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '14',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PENGGALIAN',
            ],
            [
                'id_aset'          => 378,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '14',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PENGGALIAN',
            ],
            [
                'id_aset'          => 379,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '14',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TEMPAT AIR HANGAT',
            ],
            [
                'id_aset'          => 380,
                'golongan'         => '2',
                'bidang'           => '01',
                'kelompok'         => '14',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TANAH PENGGUNAAN LAINNYA',
            ],
            [
                'id_aset'          => 381,
                'golongan'         => '3',
                'bidang'           => '00',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN DAN MESIN',
            ],
            [
                'id_aset'          => 382,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BESAR',
            ],
            [
                'id_aset'          => 383,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BESAR DARAT',
            ],
            [
                'id_aset'          => 384,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TRACTOR',
            ],
            [
                'id_aset'          => 385,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'CRAWLER TRACTOR + ATTACHMENT',
            ],
            [
                'id_aset'          => 386,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'WHEEL TRACTOR + ATTACHMENT',
            ],
            [
                'id_aset'          => 387,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'SWAMP TRACTOR + ATTACHMENT',
            ],
            [
                'id_aset'          => 388,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PRIME MOWER',
            ],
            [
                'id_aset'          => 389,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'AIRCRAFT TOWING TRACTOR',
            ],
            [
                'id_aset'          => 390,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TOWING BAR',
            ],
            [
                'id_aset'          => 391,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'BULLDOZER',
            ],
            [
                'id_aset'          => 392,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'WHEEL DOZER',
            ],
            [
                'id_aset'          => 393,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TRACTOR LAINNYA',
            ],
            [
                'id_aset'          => 394,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'GRADER',
            ],
            [
                'id_aset'          => 395,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'GRADER + ATTACHMENT',
            ],
            [
                'id_aset'          => 396,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'GRADER TOWED TYPE',
            ],
            [
                'id_aset'          => 397,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'GRADER LAINNYA',
            ],
            [
                'id_aset'          => 398,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'EXCAVATOR',
            ],
            [
                'id_aset'          => 399,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'CRAWLER EXCAVATOR + ATTACHMENT',
            ],
            [
                'id_aset'          => 400,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'WHEEL EXCAVATOR + ATTACHMENT',
            ],
            [
                'id_aset'          => 401,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'EXCAVATOR LAINNYA',
            ],
            [
                'id_aset'          => 402,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PILE DRIVER',
            ],
            [
                'id_aset'          => 403,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'DIESEL PILE DRIVER',
            ],
            [
                'id_aset'          => 404,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PNEUMATIC PILE DRIVER',
            ],
            [
                'id_aset'          => 405,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'VIBRATION PILE DRIVER',
            ],
            [
                'id_aset'          => 406,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PILE DRIVER LAINNYA',
            ],
            [
                'id_aset'          => 407,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'HAULER',
            ],
            [
                'id_aset'          => 408,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SELF PROPELLED SCRAPER',
            ],
            [
                'id_aset'          => 409,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TOWED SCRAPER',
            ],
            [
                'id_aset'          => 410,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'DUMP TRUCK',
            ],
            [
                'id_aset'          => 411,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'DUMP WAGON',
            ],
            [
                'id_aset'          => 412,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'LORI',
            ],
            [
                'id_aset'          => 413,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'HAULER LAINNYA',
            ],
            [
                'id_aset'          => 414,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ASPHALT EQUIPMENT',
            ],
            [
                'id_aset'          => 415,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ASPHALT MIXING PLANT',
            ],
            [
                'id_aset'          => 416,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ASPHALT FINISHER',
            ],
            [
                'id_aset'          => 417,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ASPHALT DISTRIBUTOR',
            ],
            [
                'id_aset'          => 418,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ASPHALT HEATER',
            ],
            [
                'id_aset'          => 419,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '005',
                'nama'             => 'ASPHALT TANKER',
            ],
            [
                'id_aset'          => 420,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '006',
                'nama'             => 'ASPHALT SPRAYER',
            ],
            [
                'id_aset'          => 421,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '007',
                'nama'             => 'ASBUTON DRYER',
            ],
            [
                'id_aset'          => 422,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '008',
                'nama'             => 'ASPHALT RECYCLE',
            ],
            [
                'id_aset'          => 423,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '009',
                'nama'             => 'COLD MILLING MACHINE',
            ],
            [
                'id_aset'          => 424,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '010',
                'nama'             => 'ASPHALT MIXER',
            ],
            [
                'id_aset'          => 425,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '011',
                'nama'             => 'BITUMEN / ASPHALT TEST',
            ],
            [
                'id_aset'          => 426,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ASPHALT EQUIPMENT LAINNYA',
            ],
            [
                'id_aset'          => 427,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'COMPACTING EQUIPMENT',
            ],
            [
                'id_aset'          => 428,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MACADAM ROLLER/THREE WHEEL ROLLER',
            ],
            [
                'id_aset'          => 429,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TANDEM ROLLER',
            ],
            [
                'id_aset'          => 430,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESH ROLLER',
            ],
            [
                'id_aset'          => 431,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '004',
                'nama'             => 'VIBRATION ROLLER',
            ],
            [
                'id_aset'          => 432,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TYRE ROLLER',
            ],
            [
                'id_aset'          => 433,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '006',
                'nama'             => 'SOIL STABILIZER',
            ],
            [
                'id_aset'          => 434,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '007',
                'nama'             => 'SHEEPFOOT/TAMPING ROLLER',
            ],
            [
                'id_aset'          => 435,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '008',
                'nama'             => 'STAMPER',
            ],
            [
                'id_aset'          => 436,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '009',
                'nama'             => 'VIBRATION PLATE',
            ],
            [
                'id_aset'          => 437,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '010',
                'nama'             => 'PEMADAT SAMPAH',
            ],
            [
                'id_aset'          => 438,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TRUCK & BUSH TYRE',
            ],
            [
                'id_aset'          => 439,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'COMPACTING EQUIPMENT LAINNYA',
            ],
            [
                'id_aset'          => 440,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'AGGREGATE & CONCRETE EQUIPMENT',
            ],
            [
                'id_aset'          => 441,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'STONE CRUSHING PLANT',
            ],
            [
                'id_aset'          => 442,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SCREENING CLASSIFER',
            ],
            [
                'id_aset'          => 443,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '003',
                'nama'             => 'STONE CHUSER',
            ],
            [
                'id_aset'          => 444,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '004',
                'nama'             => 'AGGREGATE WASHER',
            ],
            [
                'id_aset'          => 445,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '005',
                'nama'             => 'BATCHING PLANT',
            ],
            [
                'id_aset'          => 446,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '006',
                'nama'             => 'CONCRETE FINISHER',
            ],
            [
                'id_aset'          => 447,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '007',
                'nama'             => 'CONCRETE PUMP',
            ],
            [
                'id_aset'          => 448,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '008',
                'nama'             => 'CONCRETE LIFT',
            ],
            [
                'id_aset'          => 449,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '009',
                'nama'             => 'CONCRETE PRESTRES',
            ],
            [
                'id_aset'          => 450,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '010',
                'nama'             => 'CONCRETE CUTTER',
            ],
            [
                'id_aset'          => 451,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '011',
                'nama'             => 'CONCRETE MIXER',
            ],
            [
                'id_aset'          => 452,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '012',
                'nama'             => 'CONCRETE VIBRATOR',
            ],
            [
                'id_aset'          => 453,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '013',
                'nama'             => 'CONCRETE BREAKER',
            ],
            [
                'id_aset'          => 454,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '014',
                'nama'             => 'AGGREGATE/CHIP SPREADER',
            ],
            [
                'id_aset'          => 455,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '015',
                'nama'             => 'GRAUTING MACHINE',
            ],
            [
                'id_aset'          => 456,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '016',
                'nama'             => 'CONCRETE MOULD',
            ],
            [
                'id_aset'          => 457,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '017',
                'nama'             => 'PIPE PLANT EQUIPMENT',
            ],
            [
                'id_aset'          => 458,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '018',
                'nama'             => 'CONCRETE MIXER TANDEM',
            ],
            [
                'id_aset'          => 459,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '019',
                'nama'             => 'ONION HEAD MACHINE',
            ],
            [
                'id_aset'          => 460,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '020',
                'nama'             => 'PAN MIXER',
            ],
            [
                'id_aset'          => 461,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '021',
                'nama'             => 'ASBUTON MIXER',
            ],
            [
                'id_aset'          => 462,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '022',
                'nama'             => 'PADDLE MIXER',
            ],
            [
                'id_aset'          => 463,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '023',
                'nama'             => 'ASPHALT BUTON CRUSHER',
            ],
            [
                'id_aset'          => 464,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '024',
                'nama'             => 'ROCK DRILL',
            ],
            [
                'id_aset'          => 465,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'AGGREGATE & CONCRETE EQUIPMENT LAINNYA',
            ],
            [
                'id_aset'          => 466,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '000',
                'nama'             => 'LOADER',
            ],
            [
                'id_aset'          => 467,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRACK LOADER + ATTACHMENT',
            ],
            [
                'id_aset'          => 468,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '002',
                'nama'             => 'WHEEL LOADER + ATTACHMENT',
            ],
            [
                'id_aset'          => 469,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MAIN DECK LOADER',
            ],
            [
                'id_aset'          => 470,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '004',
                'nama'             => 'CONVEYOR BELT TRUCK',
            ],
            [
                'id_aset'          => 471,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '005',
                'nama'             => 'HIGH LIFT LOADER',
            ],
            [
                'id_aset'          => 472,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '006',
                'nama'             => 'BACKHOE LOADER',
            ],
            [
                'id_aset'          => 473,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '999',
                'nama'             => 'LOADER LAINNYA',
            ],
            [
                'id_aset'          => 474,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENGANGKAT',
            ],
            [
                'id_aset'          => 475,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TOWER CRANE',
            ],
            [
                'id_aset'          => 476,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TRUCK MOUNTED CRANE',
            ],
            [
                'id_aset'          => 477,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TRUCK CRANE',
            ],
            [
                'id_aset'          => 478,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '004',
                'nama'             => 'WHEEL CRANE',
            ],
            [
                'id_aset'          => 479,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '005',
                'nama'             => 'FORKLIFT',
            ],
            [
                'id_aset'          => 480,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '006',
                'nama'             => 'FORTAL CRANE',
            ],
            [
                'id_aset'          => 481,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '007',
                'nama'             => 'CRAWLER CRANE',
            ],
            [
                'id_aset'          => 482,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '008',
                'nama'             => 'CONTAINER CRANE',
            ],
            [
                'id_aset'          => 483,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TRANSTAINER',
            ],
            [
                'id_aset'          => 484,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TRAVELT CONTAINER STACKER',
            ],
            [
                'id_aset'          => 485,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TOP LOADER',
            ],
            [
                'id_aset'          => 486,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '012',
                'nama'             => 'RAIL LIFTER',
            ],
            [
                'id_aset'          => 487,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '013',
                'nama'             => 'TRACK MOTOR CAR',
            ],
            [
                'id_aset'          => 488,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '014',
                'nama'             => 'SALVAGE PESAWAT UDARA',
            ],
            [
                'id_aset'          => 489,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '015',
                'nama'             => 'HAND PALET TRUCK',
            ],
            [
                'id_aset'          => 490,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '016',
                'nama'             => 'CRANE SHOVEL 20 T',
            ],
            [
                'id_aset'          => 491,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '017',
                'nama'             => 'SHOP WOOD WORKING CRANE SHOVEL 20 T',
            ],
            [
                'id_aset'          => 492,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENGANGKAT LAINNYA',
            ],
            [
                'id_aset'          => 493,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '000',
                'nama'             => 'MESIN PROSES',
            ],
            [
                'id_aset'          => 494,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN PEMBUAT PELLET',
            ],
            [
                'id_aset'          => 495,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN PEMBUAT ES',
            ],
            [
                'id_aset'          => 496,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN PENGHANCUR ES',
            ],
            [
                'id_aset'          => 497,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '004',
                'nama'             => 'WATER TREATMENT (MESIN PROSES)',
            ],
            [
                'id_aset'          => 498,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '005',
                'nama'             => 'SEA WATER TREATMENT',
            ],
            [
                'id_aset'          => 499,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN PENGOLAH DODOL',
            ],
            [
                'id_aset'          => 500,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '999',
                'nama'             => 'MESIN PROSES LAINNYA',
            ],
            [
                'id_aset'          => 501,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BESAR DARAT LAINNYA',
            ],
            [
                'id_aset'          => 502,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT BESAR DARAT LAINNYA',
            ],
            [
                'id_aset'          => 503,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BESAR APUNG',
            ],
            [
                'id_aset'          => 504,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'DREDGER',
            ],
            [
                'id_aset'          => 505,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SUCTION DREDGER',
            ],
            [
                'id_aset'          => 506,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'BUCKET DREDGER',
            ],
            [
                'id_aset'          => 507,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'CUTTER SUCTION DREDGER',
            ],
            [
                'id_aset'          => 508,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'DREDGER LAINNYA',
            ],
            [
                'id_aset'          => 509,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'FLOATING EXCAVATOR',
            ],
            [
                'id_aset'          => 510,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'FLOATING EXCAVATOR + ATTACHMENT',
            ],
            [
                'id_aset'          => 511,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'FLOATING CRANE',
            ],
            [
                'id_aset'          => 512,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'FLOATING PUMP',
            ],
            [
                'id_aset'          => 513,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'FLOATING EXCAVATOR LAINNYA',
            ],
            [
                'id_aset'          => 514,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'AMPHIBI DREDGER',
            ],
            [
                'id_aset'          => 515,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PLAIN SUCTION',
            ],
            [
                'id_aset'          => 516,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'CUTTER (AMPHIBI DREDGER)',
            ],
            [
                'id_aset'          => 517,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'CLAMSHELL / DRAGLINE',
            ],
            [
                'id_aset'          => 518,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'AMPHIBI DREDGER LAINNYA',
            ],
            [
                'id_aset'          => 519,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'KAPAL TARIK',
            ],
            [
                'id_aset'          => 520,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'KAPAL TARIK',
            ],
            [
                'id_aset'          => 521,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'KAPAL TARIK LAINNYA',
            ],
            [
                'id_aset'          => 522,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'MESIN PROSES APUNG',
            ],
            [
                'id_aset'          => 523,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'WATER TREATMENT (MESIN PROSES APUNG)',
            ],
            [
                'id_aset'          => 524,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'MESIN PROSES APUNG LAINNYA',
            ],
            [
                'id_aset'          => 525,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BESAR APUNG LAINNYA',
            ],
            [
                'id_aset'          => 526,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT BESAR APUNG LAINNYA',
            ],
            [
                'id_aset'          => 527,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BANTU',
            ],
            [
                'id_aset'          => 528,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENARIK',
            ],
            [
                'id_aset'          => 529,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ALAT PENARIK KAPAL',
            ],
            [
                'id_aset'          => 530,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ALAT PENARIK JARING',
            ],
            [
                'id_aset'          => 531,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENARIK LAINNYA',
            ],
            [
                'id_aset'          => 532,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'FEEDER',
            ],
            [
                'id_aset'          => 533,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ELEVATOR /LIFT',
            ],
            [
                'id_aset'          => 534,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'BELT CONVEYOR (FEEDER)',
            ],
            [
                'id_aset'          => 535,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'SCREW CONVEYOR (FEEDER)',
            ],
            [
                'id_aset'          => 536,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ESCALATOR',
            ],
            [
                'id_aset'          => 537,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'GANDOLA',
            ],
            [
                'id_aset'          => 538,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'ELEVATOR (FEEDER)',
            ],
            [
                'id_aset'          => 539,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'GANGWAY',
            ],
            [
                'id_aset'          => 540,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'FEEDER LAINNYA (ALAT BESAR)',
            ],
            [
                'id_aset'          => 541,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'COMPRESSOR',
            ],
            [
                'id_aset'          => 542,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRANSPORTABLE COMPRESSOR',
            ],
            [
                'id_aset'          => 543,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PORTABLE COMPRESSOR',
            ],
            [
                'id_aset'          => 544,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'STATIONARY COMPRESSOR',
            ],
            [
                'id_aset'          => 545,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'AIR COMPRESOR',
            ],
            [
                'id_aset'          => 546,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'COMPRESSOR PNEUMATIC TOOL 25 GMP',
            ],
            [
                'id_aset'          => 547,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'COMPRESSOR LAINNYA',
            ],
            [
                'id_aset'          => 548,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ELECTRIC GENERATING SET',
            ],
            [
                'id_aset'          => 549,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRANSPORTABLE GENERATING SET',
            ],
            [
                'id_aset'          => 550,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PORTABLE GENERATING SET',
            ],
            [
                'id_aset'          => 551,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'STATIONARY GENERATING SET',
            ],
            [
                'id_aset'          => 552,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'DYNAMO ELECTRIC',
            ],
            [
                'id_aset'          => 553,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ELECTRIC GENERATING SET LAINNYA',
            ],
            [
                'id_aset'          => 554,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'POMPA',
            ],
            [
                'id_aset'          => 555,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRANSPORTABLE WATER PUMP',
            ],
            [
                'id_aset'          => 556,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PORTABLE WATER PUMP',
            ],
            [
                'id_aset'          => 557,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'STATIONARY WATER PUMP',
            ],
            [
                'id_aset'          => 558,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'POMPA LUMPUR',
            ],
            [
                'id_aset'          => 559,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'SUMERSIBLE PUMP',
            ],
            [
                'id_aset'          => 560,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'POMPA TANGAN',
            ],
            [
                'id_aset'          => 561,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'POMPA ANGIN',
            ],
            [
                'id_aset'          => 562,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'POMPA BENSIN/MINYAK STATIONERY',
            ],
            [
                'id_aset'          => 563,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '009',
                'nama'             => 'POMPA BENSIN/MINYAK TRANSPORTABLE',
            ],
            [
                'id_aset'          => 564,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '010',
                'nama'             => 'POMPA AIR',
            ],
            [
                'id_aset'          => 565,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '011',
                'nama'             => 'WATER DISTRIBUTOR',
            ],
            [
                'id_aset'          => 566,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '012',
                'nama'             => 'WATER PURIFICATION',
            ],
            [
                'id_aset'          => 567,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'POMPA LAINNYA',
            ],
            [
                'id_aset'          => 568,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'MESIN BOR',
            ],
            [
                'id_aset'          => 569,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN BOR BATU',
            ],
            [
                'id_aset'          => 570,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN BOR TANAH',
            ],
            [
                'id_aset'          => 571,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN BOR BETON',
            ],
            [
                'id_aset'          => 572,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'MESIN BOR LAINNYA',
            ],
            [
                'id_aset'          => 573,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'UNIT PEMELIHARAAN LAPANGAN',
            ],
            [
                'id_aset'          => 574,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MOBIL WORKSHOP',
            ],
            [
                'id_aset'          => 575,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SERVICE CAR',
            ],
            [
                'id_aset'          => 576,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'FLOATING WORKSHOP',
            ],
            [
                'id_aset'          => 577,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ROAD MAINTENANCE TRUCK',
            ],
            [
                'id_aset'          => 578,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '005',
                'nama'             => 'SWEEPER TRUCK',
            ],
            [
                'id_aset'          => 579,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '006',
                'nama'             => 'WRECK CAR',
            ],
            [
                'id_aset'          => 580,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '007',
                'nama'             => 'LEAK DETECTOR (UNIT PEMELIHARAAN LAPANGAN)',
            ],
            [
                'id_aset'          => 581,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PIPE LOCATOR',
            ],
            [
                'id_aset'          => 582,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '009',
                'nama'             => 'METAL LOCATOR',
            ],
            [
                'id_aset'          => 583,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MESIN DIESEL',
            ],
            [
                'id_aset'          => 584,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '011',
                'nama'             => 'KETLE HEATING',
            ],
            [
                'id_aset'          => 585,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '012',
                'nama'             => 'SWEEPER PENGHISAP OLI',
            ],
            [
                'id_aset'          => 586,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '013',
                'nama'             => 'FUEL TANK',
            ],
            [
                'id_aset'          => 587,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '014',
                'nama'             => 'GRASS COLECTOR',
            ],
            [
                'id_aset'          => 588,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '015',
                'nama'             => 'MESIN PEMOTONG ASPAL (DRAGING)',
            ],
            [
                'id_aset'          => 589,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '016',
                'nama'             => 'SWEEPER ROTARY',
            ],
            [
                'id_aset'          => 590,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '017',
                'nama'             => 'EARTH VAGER TRUCK',
            ],
            [
                'id_aset'          => 591,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '018',
                'nama'             => 'SCRAPPER',
            ],
            [
                'id_aset'          => 592,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '019',
                'nama'             => 'ROSTER',
            ],
            [
                'id_aset'          => 593,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '020',
                'nama'             => 'SHOP TRUCK EQUIPMENT',
            ],
            [
                'id_aset'          => 594,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'UNIT PEMELIHARAAN LAPANGAN LAINNYA',
            ],
            [
                'id_aset'          => 595,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENGOLAHAN AIR KOTOR',
            ],
            [
                'id_aset'          => 596,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PENGOLAHAN AIR KOTOR',
            ],
            [
                'id_aset'          => 597,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENGOLAHAN AIR KOTOR LAINNYA',
            ],
            [
                'id_aset'          => 598,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PEMBANGKIT UAP AIR PANAS/STEAM GENERATOR',
            ],
            [
                'id_aset'          => 599,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PEMBANGKIT UAP AIR PANAS',
            ],
            [
                'id_aset'          => 600,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PEMBANGKIT UAP AIR PANAS/STEAM GENERATOR LAINNYA',
            ],
            [
                'id_aset'          => 601,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN KEBAKARAN HUTAN',
            ],
            [
                'id_aset'          => 602,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '001',
                'nama'             => 'BACKPACK PUMP (POMPA PUNGGUNG BESAR)',
            ],
            [
                'id_aset'          => 603,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '002',
                'nama'             => 'FLOATING FIRE PUMP (POMPA PUNGGUNG KECIL)',
            ],
            [
                'id_aset'          => 604,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '003',
                'nama'             => 'POMPA PORTABLE',
            ],
            [
                'id_aset'          => 605,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '004',
                'nama'             => 'JET SHOOTER',
            ],
            [
                'id_aset'          => 606,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '005',
                'nama'             => 'GOLOK PEMADAM',
            ],
            [
                'id_aset'          => 607,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '006',
                'nama'             => 'BLADE SHOVEL (SEKOP PEMADAM)',
            ],
            [
                'id_aset'          => 608,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '007',
                'nama'             => 'SUMBUT',
            ],
            [
                'id_aset'          => 609,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '008',
                'nama'             => 'VELD BED',
            ],
            [
                'id_aset'          => 610,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '009',
                'nama'             => 'RANSEL PEMADAM',
            ],
            [
                'id_aset'          => 611,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '010',
                'nama'             => 'FULL BODY HARNESS',
            ],
            [
                'id_aset'          => 612,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '011',
                'nama'             => 'SIT HARNESS',
            ],
            [
                'id_aset'          => 613,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '012',
                'nama'             => 'FIGURE',
            ],
            [
                'id_aset'          => 614,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '013',
                'nama'             => 'ASCENDER',
            ],
            [
                'id_aset'          => 615,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '014',
                'nama'             => 'SCROLL LOCK',
            ],
            [
                'id_aset'          => 616,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '015',
                'nama'             => 'PERLENGKAPAN RESCUE',
            ],
            [
                'id_aset'          => 617,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '016',
                'nama'             => 'AUTOMATIC SNAP HOOK',
            ],
            [
                'id_aset'          => 618,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '017',
                'nama'             => 'TANGGA TALI',
            ],
            [
                'id_aset'          => 619,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '018',
                'nama'             => 'NOZEL TABIR ALUMUNIUM',
            ],
            [
                'id_aset'          => 620,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '019',
                'nama'             => 'NOZEL KUNINGAN PERNEKEL',
            ],
            [
                'id_aset'          => 621,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '020',
                'nama'             => 'SELANG AIR',
            ],
            [
                'id_aset'          => 622,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '021',
                'nama'             => 'BREATHING APARATUS (TABUNG 10 KG)',
            ],
            [
                'id_aset'          => 623,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '022',
                'nama'             => 'GEPYOK PEMADAM',
            ],
            [
                'id_aset'          => 624,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '023',
                'nama'             => 'FIRE RAKE (GARU TAJAM)',
            ],
            [
                'id_aset'          => 625,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '024',
                'nama'             => 'PULASKI AXE (KAPAK DUA FUNGSI)',
            ],
            [
                'id_aset'          => 626,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '025',
                'nama'             => 'FIRE TOOL (GARU PACUL/ CANGKUL)',
            ],
            [
                'id_aset'          => 627,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '026',
                'nama'             => 'SABIT SEMAK',
            ],
            [
                'id_aset'          => 628,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '027',
                'nama'             => 'FLAPPER (PEMUKUL API)',
            ],
            [
                'id_aset'          => 629,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '028',
                'nama'             => 'DRIP TORCH (OBOR SULUT TETES)',
            ],
            [
                'id_aset'          => 630,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '029',
                'nama'             => 'FILES (KIKIR BAJA)',
            ],
            [
                'id_aset'          => 631,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '030',
                'nama'             => 'KACA MATA (LENSA TAHAN PANAS)',
            ],
            [
                'id_aset'          => 632,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '031',
                'nama'             => 'KOPEL REM',
            ],
            [
                'id_aset'          => 633,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '032',
                'nama'             => 'FELPES',
            ],
            [
                'id_aset'          => 634,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '033',
                'nama'             => 'KANTONG AIR',
            ],
            [
                'id_aset'          => 635,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '034',
                'nama'             => 'BATANG POMPA',
            ],
            [
                'id_aset'          => 636,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN KEBAKARAN HUTAN LAINNYA',
            ],
            [
                'id_aset'          => 637,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN SELAM',
            ],
            [
                'id_aset'          => 638,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANKS (TABUNG SELAM)',
            ],
            [
                'id_aset'          => 639,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SEPATU KARANG',
            ],
            [
                'id_aset'          => 640,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KNIVES (PISAU SELAM)',
            ],
            [
                'id_aset'          => 641,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '004',
                'nama'             => 'DIVE LIGHTS (SENTER SELAM)',
            ],
            [
                'id_aset'          => 642,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '005',
                'nama'             => 'REGULATOR INSTRUMENTS',
            ],
            [
                'id_aset'          => 643,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '006',
                'nama'             => 'BOUYANCY COMPENSATOR DEVICE (BCD)',
            ],
            [
                'id_aset'          => 644,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '007',
                'nama'             => 'BELT (SABUK PEMBERAT)',
            ],
            [
                'id_aset'          => 645,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '008',
                'nama'             => 'WEIGHT (PEMBERAT)',
            ],
            [
                'id_aset'          => 646,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '009',
                'nama'             => 'DIVING GLOVES (SARUNG TANGAN SELAM)',
            ],
            [
                'id_aset'          => 647,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '010',
                'nama'             => 'KOMPRESOR SELAM',
            ],
            [
                'id_aset'          => 648,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '011',
                'nama'             => 'PELAMPUNG LIFE JACKET',
            ],
            [
                'id_aset'          => 649,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN SELAM LAINNYA',
            ],
            [
                'id_aset'          => 650,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN SAR MOUNTENERING',
            ],
            [
                'id_aset'          => 651,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TALI KAMANTEL STATIC',
            ],
            [
                'id_aset'          => 652,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TALI KAMANTEL DINAMIC',
            ],
            [
                'id_aset'          => 653,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '003',
                'nama'             => 'RAINCOAT (PONCO)',
            ],
            [
                'id_aset'          => 654,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '004',
                'nama'             => 'SEAT HARNESS',
            ],
            [
                'id_aset'          => 655,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PRUSIK',
            ],
            [
                'id_aset'          => 656,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '006',
                'nama'             => 'JUMMAR',
            ],
            [
                'id_aset'          => 657,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PULLEY',
            ],
            [
                'id_aset'          => 658,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '008',
                'nama'             => 'DESCENDER FIGURE OG EIGHT',
            ],
            [
                'id_aset'          => 659,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '009',
                'nama'             => 'CARABINER NON SCREW',
            ],
            [
                'id_aset'          => 660,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '010',
                'nama'             => 'WEBBING',
            ],
            [
                'id_aset'          => 661,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TANDU LIPAT',
            ],
            [
                'id_aset'          => 662,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN SAR MOUNTENERING LAINNYA',
            ],
            [
                'id_aset'          => 663,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BANTU LAINNYA',
            ],
            [
                'id_aset'          => 664,
                'golongan'         => '3',
                'bidang'           => '01',
                'kelompok'         => '03',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT BANTU LAINNYA',
            ],
            [
                'id_aset'          => 665,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN',
            ],
            [
                'id_aset'          => 666,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN DARAT BERMOTOR',
            ],
            [
                'id_aset'          => 667,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'KENDARAAN DINAS BERMOTOR PERORANGAN',
            ],
            [
                'id_aset'          => 668,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SEDAN',
            ],
            [
                'id_aset'          => 669,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'JEEP',
            ],
            [
                'id_aset'          => 670,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'STATION WAGON',
            ],
            [
                'id_aset'          => 671,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'KENDARAAN DINAS BERMOTOR PERORANGAN LAINNYA',
            ],
            [
                'id_aset'          => 672,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'KENDARAAN BERMOTOR PENUMPANG',
            ],
            [
                'id_aset'          => 673,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'BUS ( PENUMPANG 30 ORANG KEATAS )',
            ],
            [
                'id_aset'          => 674,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MICRO BUS ( PENUMPANG 15 S/D 29 ORANG )',
            ],
            [
                'id_aset'          => 675,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MINI BUS ( PENUMPANG 14 ORANG KEBAWAH )',
            ],
            [
                'id_aset'          => 676,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'KENDARAAN LAPIS BAJA',
            ],
            [
                'id_aset'          => 677,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'KENDARAAN BERMOTOR PENUMPANG LAINNYA',
            ],
            [
                'id_aset'          => 678,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'KENDARAAN BERMOTOR ANGKUTAN BARANG',
            ],
            [
                'id_aset'          => 679,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRUCK + ATTACHMENT',
            ],
            [
                'id_aset'          => 680,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PICK UP',
            ],
            [
                'id_aset'          => 681,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'YEENGLER/TRAILER',
            ],
            [
                'id_aset'          => 682,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'SEMI TRAILER',
            ],
            [
                'id_aset'          => 683,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TRUCK PONTON DENGAN TRAILLER',
            ],
            [
                'id_aset'          => 684,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'DALHURA',
            ],
            [
                'id_aset'          => 685,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'KENDARAAN BERMOTOR ANGKUTAN BARANG LAINNYA',
            ],
            [
                'id_aset'          => 686,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'KENDARAAN BERMOTOR BERODA DUA',
            ],
            [
                'id_aset'          => 687,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SEPEDA MOTOR',
            ],
            [
                'id_aset'          => 688,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SCOOTER',
            ],
            [
                'id_aset'          => 689,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'SEPEDA MOTOR PERPUSTAKAAN KELILING',
            ],
            [
                'id_aset'          => 690,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'SEPEDA MOTOR PATROLI',
            ],
            [
                'id_aset'          => 691,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'SEPEDA MOTOR PENGAWALAN',
            ],
            [
                'id_aset'          => 692,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'KENDARAAN BERMOTOR BERODA DUA LAINNYA',
            ],
            [
                'id_aset'          => 693,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'KENDARAAN BERMOTOR KHUSUS',
            ],
            [
                'id_aset'          => 694,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MOBIL AMBULANCE',
            ],
            [
                'id_aset'          => 695,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MOBIL JENAZAH',
            ],
            [
                'id_aset'          => 696,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MOBIL UNIT PENERANGAN DARAT',
            ],
            [
                'id_aset'          => 697,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MOBIL PEMADAM KEBAKARAN',
            ],
            [
                'id_aset'          => 698,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MOBIL TINJA',
            ],
            [
                'id_aset'          => 699,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MOBIL TANGKI AIR',
            ],
            [
                'id_aset'          => 700,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MOBIL UNIT MONITORING FREKWENSI',
            ],
            [
                'id_aset'          => 701,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MOBIL UNIT PERPUSTAKAAN KELILING',
            ],
            [
                'id_aset'          => 702,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MOBIL UNIT VISUAL MINI (MUVIANI)',
            ],
            [
                'id_aset'          => 703,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MOBIL UNIT SATELITE LINK VAN',
            ],
            [
                'id_aset'          => 704,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '011',
                'nama'             => 'MOBIL UNIT PANGGUNG',
            ],
            [
                'id_aset'          => 705,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '012',
                'nama'             => 'MOBIL UNIT PAMERAN',
            ],
            [
                'id_aset'          => 706,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '013',
                'nama'             => 'OUT SIDE BROAD CAST VAN RADIO',
            ],
            [
                'id_aset'          => 707,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '014',
                'nama'             => 'OUT SIDE BROAD CAST VAN TELEVISI',
            ],
            [
                'id_aset'          => 708,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '015',
                'nama'             => 'MOBIL UNIT PRODUKSI FILM',
            ],
            [
                'id_aset'          => 709,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '016',
                'nama'             => 'MOBIL UNIT PRODUKSI TELEVISI',
            ],
            [
                'id_aset'          => 710,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '017',
                'nama'             => 'MOBIL UNIT PRODUKSI CINERAMA',
            ],
            [
                'id_aset'          => 711,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '018',
                'nama'             => 'MOBIL UNIT KESEHATAN MASYARAKAT',
            ],
            [
                'id_aset'          => 712,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '019',
                'nama'             => 'MOBIL UNIT KESEHATAN HEWAN',
            ],
            [
                'id_aset'          => 713,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '020',
                'nama'             => 'MOBIL UNIT TAHANAN',
            ],
            [
                'id_aset'          => 714,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '021',
                'nama'             => 'MOBIL UNIT PENGANGKUT UANG',
            ],
            [
                'id_aset'          => 715,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '022',
                'nama'             => 'TRUCK SAMPAH',
            ],
            [
                'id_aset'          => 716,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '023',
                'nama'             => 'MOBIL TANGKI BAHAN BAKAR',
            ],
            [
                'id_aset'          => 717,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '024',
                'nama'             => 'MOBIL UNIT RONTGEN',
            ],
            [
                'id_aset'          => 718,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '025',
                'nama'             => 'MOBIL UNIT REHABILITASI SOSIAL KELILING',
            ],
            [
                'id_aset'          => 719,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '026',
                'nama'             => 'BOMP TRAILER',
            ],
            [
                'id_aset'          => 720,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '027',
                'nama'             => 'KENDARAAN KLINIK',
            ],
            [
                'id_aset'          => 721,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '028',
                'nama'             => 'MOBIL UNIT PENGANGKUT LIMBAH RADIO AKTIF',
            ],
            [
                'id_aset'          => 722,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '029',
                'nama'             => 'MOBIL TRANFUSI DARAH',
            ],
            [
                'id_aset'          => 723,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '030',
                'nama'             => 'KENDARAAN TIM PEMELIHARAAN',
            ],
            [
                'id_aset'          => 724,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '031',
                'nama'             => 'MOBIL PENARIK (UNIMOG)',
            ],
            [
                'id_aset'          => 725,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '032',
                'nama'             => 'KENDARAAN SATMOBEK/SATMOBENG/SATMOMAS',
            ],
            [
                'id_aset'          => 726,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '033',
                'nama'             => 'MOBIL WORK SHOP/SERVICES',
            ],
            [
                'id_aset'          => 727,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '034',
                'nama'             => 'KENDARAAN DEREK',
            ],
            [
                'id_aset'          => 728,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '035',
                'nama'             => 'MOBIL UNIT KHUSUS ALJIHANDAK',
            ],
            [
                'id_aset'          => 729,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '036',
                'nama'             => 'AIRCRAFT AIR CONDITIONING',
            ],
            [
                'id_aset'          => 730,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '037',
                'nama'             => 'KENDARAAN GIRAFLE RADAR',
            ],
            [
                'id_aset'          => 731,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '038',
                'nama'             => 'MOBIL PERS VAN',
            ],
            [
                'id_aset'          => 732,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '039',
                'nama'             => 'KENDARAAN UNIT BEDAH',
            ],
            [
                'id_aset'          => 733,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '040',
                'nama'             => 'MOBILE FLOODLIGHT',
            ],
            [
                'id_aset'          => 734,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '041',
                'nama'             => 'KENDARAAN PENGANGKUT TANK',
            ],
            [
                'id_aset'          => 735,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '042',
                'nama'             => 'CRASH CAR',
            ],
            [
                'id_aset'          => 736,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '043',
                'nama'             => 'KENDARAAN WATER CANON',
            ],
            [
                'id_aset'          => 737,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '044',
                'nama'             => 'FOAM VEHICLE',
            ],
            [
                'id_aset'          => 738,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '045',
                'nama'             => 'KENDARAAN TOILET',
            ],
            [
                'id_aset'          => 739,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '046',
                'nama'             => 'RAPID INVENTION VEHICLE',
            ],
            [
                'id_aset'          => 740,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '047',
                'nama'             => 'KENDARAAN GAS AIRMATA',
            ],
            [
                'id_aset'          => 741,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '048',
                'nama'             => 'KENDARAAN TAKTIS',
            ],
            [
                'id_aset'          => 742,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '049',
                'nama'             => 'KENDARAAN VIP (ANTI PELURU)',
            ],
            [
                'id_aset'          => 743,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '050',
                'nama'             => 'KENDARAAN TANGGA PESAWAT',
            ],
            [
                'id_aset'          => 744,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '051',
                'nama'             => 'KENDARAAN METEO',
            ],
            [
                'id_aset'          => 745,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '052',
                'nama'             => 'KENDARAAN SWEEPER',
            ],
            [
                'id_aset'          => 746,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '053',
                'nama'             => 'KENDARAAN KAMAR SANDI',
            ],
            [
                'id_aset'          => 747,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '054',
                'nama'             => 'KENDARAAN JAMMING FREKUENSI',
            ],
            [
                'id_aset'          => 748,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '055',
                'nama'             => 'KENDARAAN MONITORING SINYAL',
            ],
            [
                'id_aset'          => 749,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '056',
                'nama'             => 'MOBIL DAPUR LAPANGAN',
            ],
            [
                'id_aset'          => 750,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '057',
                'nama'             => 'MOBIL PENARIK BARRIER',
            ],
            [
                'id_aset'          => 751,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '058',
                'nama'             => 'MOBIL OPERASIONAL PJR',
            ],
            [
                'id_aset'          => 752,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '059',
                'nama'             => 'AUTOMATIC UNGUIDED VEHICLE (AUGV)',
            ],
            [
                'id_aset'          => 753,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '060',
                'nama'             => 'RESCUE CAR',
            ],
            [
                'id_aset'          => 754,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '061',
                'nama'             => 'RAPID DEPLOYMENT LAND SAR',
            ],
            [
                'id_aset'          => 755,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '062',
                'nama'             => 'RESCUE TRUCK',
            ],
            [
                'id_aset'          => 756,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '063',
                'nama'             => 'MONILOG (MOBIL LOGISTIK/ PERSONIL)',
            ],
            [
                'id_aset'          => 757,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '064',
                'nama'             => 'MOBIL LATIH',
            ],
            [
                'id_aset'          => 758,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '065',
                'nama'             => 'RAN SWITCH WAGON',
            ],
            [
                'id_aset'          => 759,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '066',
                'nama'             => 'RAN CACDRI WAGON',
            ],
            [
                'id_aset'          => 760,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '067',
                'nama'             => 'RAN TRAKTOR',
            ],
            [
                'id_aset'          => 761,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '068',
                'nama'             => 'RAN TANGKI',
            ],
            [
                'id_aset'          => 762,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '069',
                'nama'             => 'RAN ZAT ASAM',
            ],
            [
                'id_aset'          => 763,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '070',
                'nama'             => 'RAN PENYAPU LANDASAN',
            ],
            [
                'id_aset'          => 764,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '071',
                'nama'             => 'RAN PANDU PESAWAT',
            ],
            [
                'id_aset'          => 765,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '072',
                'nama'             => 'RAN PENARIK PESAWAT',
            ],
            [
                'id_aset'          => 766,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '073',
                'nama'             => 'RAN PENYAPU HANGGAR',
            ],
            [
                'id_aset'          => 767,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '074',
                'nama'             => 'RAN DRUG CHUTE',
            ],
            [
                'id_aset'          => 768,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '075',
                'nama'             => 'RAN PEMBANGKIT TENAGA',
            ],
            [
                'id_aset'          => 769,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '076',
                'nama'             => 'RAN CRIME SQUID',
            ],
            [
                'id_aset'          => 770,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '077',
                'nama'             => 'RAN WEAPON CARRIER',
            ],
            [
                'id_aset'          => 771,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '078',
                'nama'             => 'RAN LABORATORIUM / UJI COBA',
            ],
            [
                'id_aset'          => 772,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '079',
                'nama'             => 'RAN KANTIN',
            ],
            [
                'id_aset'          => 773,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '080',
                'nama'             => 'RAN PATROLI',
            ],
            [
                'id_aset'          => 774,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '081',
                'nama'             => 'RAN JEEP KOMMAB',
            ],
            [
                'id_aset'          => 775,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '082',
                'nama'             => 'RAN RECOVERY',
            ],
            [
                'id_aset'          => 776,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '083',
                'nama'             => 'RAN PENGISI BB PESAWAT',
            ],
            [
                'id_aset'          => 777,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '084',
                'nama'             => 'RAN WRECKER',
            ],
            [
                'id_aset'          => 778,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '085',
                'nama'             => 'RAN FORKLIP',
            ],
            [
                'id_aset'          => 779,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '086',
                'nama'             => 'MOBIL PATROLI',
            ],
            [
                'id_aset'          => 780,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '087',
                'nama'             => 'KENDARAAN APC',
            ],
            [
                'id_aset'          => 781,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '088',
                'nama'             => 'KENDARAAN DARE V',
            ],
            [
                'id_aset'          => 782,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '089',
                'nama'             => 'KENDARAAN/MOBIL PENGAWALAN',
            ],
            [
                'id_aset'          => 783,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '090',
                'nama'             => 'MOBIL IRUP',
            ],
            [
                'id_aset'          => 784,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '091',
                'nama'             => 'MOBIL KOMLEK POLRI',
            ],
            [
                'id_aset'          => 785,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '092',
                'nama'             => 'MOBIL UNIT TKP',
            ],
            [
                'id_aset'          => 786,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '093',
                'nama'             => 'MOBIL UNIT LAKA LANTAS',
            ],
            [
                'id_aset'          => 787,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '094',
                'nama'             => 'MOBIL UNIT IDENTIFIKASI',
            ],
            [
                'id_aset'          => 788,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '095',
                'nama'             => 'MOBIL UNIT LABFOR',
            ],
            [
                'id_aset'          => 789,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '096',
                'nama'             => 'MOBIL UNIT PENERANGAN POLRI',
            ],
            [
                'id_aset'          => 790,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '097',
                'nama'             => 'MOBIL UNIT DEREK',
            ],
            [
                'id_aset'          => 791,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '098',
                'nama'             => 'MOBIL UNIT SATWA',
            ],
            [
                'id_aset'          => 792,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '099',
                'nama'             => 'RANTIS PHH',
            ],
            [
                'id_aset'          => 793,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '100',
                'nama'             => 'KENDARAAN POS POLISI MOBILE',
            ],
            [
                'id_aset'          => 794,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '101',
                'nama'             => 'MOBIL UNIT ALSUS JIHANDAK',
            ],
            [
                'id_aset'          => 795,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '102',
                'nama'             => 'MOBIL GOLFCAR',
            ],
            [
                'id_aset'          => 796,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '103',
                'nama'             => 'RANTIS RESCUE SAMAPTA',
            ],
            [
                'id_aset'          => 797,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '104',
                'nama'             => 'RANSUS SATWA ANJING TYPE KECIL',
            ],
            [
                'id_aset'          => 798,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '105',
                'nama'             => 'RANSUS SATWA ANJING TYPE SEDANG',
            ],
            [
                'id_aset'          => 799,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '106',
                'nama'             => 'RANSUS SATWA ANJING TYPE BESAR',
            ],
            [
                'id_aset'          => 800,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '107',
                'nama'             => 'RANSUS SATWA KUDA TYPE SEDANG',
            ],
            [
                'id_aset'          => 801,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '108',
                'nama'             => 'RANSUS SATWA KUDA TYPE BESAR',
            ],
            [
                'id_aset'          => 802,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '109',
                'nama'             => 'TRAILER KUDA',
            ],
            [
                'id_aset'          => 803,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'KENDARAAN BERMOTOR KHUSUS LAINNYA',
            ],
            [
                'id_aset'          => 804,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN DARAT BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 805,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN DARAT BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 806,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN DARAT TAK BERMOTOR',
            ],
            [
                'id_aset'          => 807,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'KENDARAAN TAK BERMOTOR ANGKUTAN BARANG',
            ],
            [
                'id_aset'          => 808,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'GEROBAK TARIK',
            ],
            [
                'id_aset'          => 809,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'GEROBAK DORONG',
            ],
            [
                'id_aset'          => 810,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'CARAVAN',
            ],
            [
                'id_aset'          => 811,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'LORI DORONG',
            ],
            [
                'id_aset'          => 812,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TRAILER',
            ],
            [
                'id_aset'          => 813,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'CONTAINER DOLLY',
            ],
            [
                'id_aset'          => 814,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PALLET DOLLY',
            ],
            [
                'id_aset'          => 815,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'BAGGAGE AND MAIL CART',
            ],
            [
                'id_aset'          => 816,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'BAGGAGE TROLLY',
            ],
            [
                'id_aset'          => 817,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MEJA DORONG SAJI/TROLLEY SAJI',
            ],
            [
                'id_aset'          => 818,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'RODA DUA BERINSULASI',
            ],
            [
                'id_aset'          => 819,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '012',
                'nama'             => 'RODA TIGA/ GEROBAK KAYUH BERINSULASI',
            ],
            [
                'id_aset'          => 820,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'KENDARAAN TAK BERMOTOR ANGKUTAN BARANG LAINNYA',
            ],
            [
                'id_aset'          => 821,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'KENDARAAN TAK BERMOTOR PENUMPANG',
            ],
            [
                'id_aset'          => 822,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SEPEDA',
            ],
            [
                'id_aset'          => 823,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'KUDA (KENDARAAN TAK BERMOTOR PENUMPANG)',
            ],
            [
                'id_aset'          => 824,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'KENDARAAN TAK BERMOTOR PENUMPANG LAINNYA',
            ],
            [
                'id_aset'          => 825,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN KERETA REL TAK BERMOTOR',
            ],
            [
                'id_aset'          => 826,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'KERETA PENUMPANG',
            ],
            [
                'id_aset'          => 827,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'KERETA MAKAN',
            ],
            [
                'id_aset'          => 828,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'POWER CAR',
            ],
            [
                'id_aset'          => 829,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'GERBONG BARANG TERTUTUP',
            ],
            [
                'id_aset'          => 830,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'GERBONG BARANG TERBUKA',
            ],
            [
                'id_aset'          => 831,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN KERETA REL TAK BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 832,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN DARAT TAK BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 833,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN DARAT TAK BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 834,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR',
            ],
            [
                'id_aset'          => 835,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR UNTUK BARANG',
            ],
            [
                'id_aset'          => 836,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'KAPAL MINYAK (TANKER)',
            ],
            [
                'id_aset'          => 837,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TONGKANG BERMOTOR',
            ],
            [
                'id_aset'          => 838,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TUG BOAT + ATTACHMENT',
            ],
            [
                'id_aset'          => 839,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'LANDING SHIP TRANSPORTATION( L.S.T )',
            ],
            [
                'id_aset'          => 840,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'KAPAL CARGO (KAPAL BARANG)',
            ],
            [
                'id_aset'          => 841,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TRUCK AIR',
            ],
            [
                'id_aset'          => 842,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR UNTUK BARANG LAINNYA',
            ],
            [
                'id_aset'          => 843,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR UNTUK PENUMPANG',
            ],
            [
                'id_aset'          => 844,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SPEED BOAT / MOTOR TEMPEL',
            ],
            [
                'id_aset'          => 845,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MOTOR BOAT',
            ],
            [
                'id_aset'          => 846,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KLOTOK',
            ],
            [
                'id_aset'          => 847,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'FERRY',
            ],
            [
                'id_aset'          => 848,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'HIDROFOIL',
            ],
            [
                'id_aset'          => 849,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'JETFOIL',
            ],
            [
                'id_aset'          => 850,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'LONG BOAT',
            ],
            [
                'id_aset'          => 851,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '008',
                'nama'             => 'KAPAL PASSANGER (KAPAL PENUMPANG)',
            ],
            [
                'id_aset'          => 852,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '009',
                'nama'             => 'PERAHU KAYU',
            ],
            [
                'id_aset'          => 853,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR UNTUK PENUMPANG LAINNYA',
            ],
            [
                'id_aset'          => 854,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR KHUSUS',
            ],
            [
                'id_aset'          => 855,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SURVEY BOAT',
            ],
            [
                'id_aset'          => 856,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'KAPAL ANTI POLUSI',
            ],
            [
                'id_aset'          => 857,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KAPAL PERAMBUAN',
            ],
            [
                'id_aset'          => 858,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'OUT BOAT MOTOR',
            ],
            [
                'id_aset'          => 859,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'KAPAL HYDROGRAFI',
            ],
            [
                'id_aset'          => 860,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'KAPAL UNIT PENERANGAN AIR',
            ],
            [
                'id_aset'          => 861,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '007',
                'nama'             => 'KAPAL VISUAL MINI',
            ],
            [
                'id_aset'          => 862,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '008',
                'nama'             => 'KAPAL PENANGKAP IKAN',
            ],
            [
                'id_aset'          => 863,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '009',
                'nama'             => 'KAPAL PENGANGKUT HEWAN',
            ],
            [
                'id_aset'          => 864,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '010',
                'nama'             => 'KAPAL PATROLI PANTAI',
            ],
            [
                'id_aset'          => 865,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '011',
                'nama'             => 'KAPAL MOTOR PERPUSTAKAAN KELILING',
            ],
            [
                'id_aset'          => 866,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '012',
                'nama'             => 'FLOATING WORK SHOP/DOCK',
            ],
            [
                'id_aset'          => 867,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '013',
                'nama'             => 'MORING BOAT/KEPIL',
            ],
            [
                'id_aset'          => 868,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '014',
                'nama'             => 'SUCTION DREDGER/KERUK HISAP',
            ],
            [
                'id_aset'          => 869,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '015',
                'nama'             => 'QUTTER DREDGER/KERUK BOR',
            ],
            [
                'id_aset'          => 870,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '016',
                'nama'             => 'BUCKET DREDGER/KERUK TIMBA',
            ],
            [
                'id_aset'          => 871,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '017',
                'nama'             => 'CLAMPSHEL DREDGER/KERUK CAKRAM',
            ],
            [
                'id_aset'          => 872,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '018',
                'nama'             => 'ALAT ANGKUTAN APUNG UNTUK MANCING',
            ],
            [
                'id_aset'          => 873,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '019',
                'nama'             => 'FLOATING PILE + ATTACHMENT (ALAT ANGKUTAN APUNG BERMOTOR KHUSUS)',
            ],
            [
                'id_aset'          => 874,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '020',
                'nama'             => 'SEKOCI MOTOR TEMPEL',
            ],
            [
                'id_aset'          => 875,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '021',
                'nama'             => 'PERAHU MOTOR TEMPEL',
            ],
            [
                'id_aset'          => 876,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '022',
                'nama'             => 'KAPAL OSEANOGRAFI',
            ],
            [
                'id_aset'          => 877,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '023',
                'nama'             => 'PERAHU TRADISIONAL',
            ],
            [
                'id_aset'          => 878,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '024',
                'nama'             => 'SEA RIDER',
            ],
            [
                'id_aset'          => 879,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '025',
                'nama'             => 'HOVER CRAFT',
            ],
            [
                'id_aset'          => 880,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '026',
                'nama'             => 'KAPAL PENGANGKUT IKAN',
            ],
            [
                'id_aset'          => 881,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '027',
                'nama'             => 'KAPAL PENGOLAH IKAN',
            ],
            [
                'id_aset'          => 882,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '028',
                'nama'             => 'KAPAL PENELITIAN/ EKSPLORASI PERIKANAN',
            ],
            [
                'id_aset'          => 883,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '029',
                'nama'             => 'KAPAL PENDUKUNG OPERASI PENANGKAPAN IKAN',
            ],
            [
                'id_aset'          => 884,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '030',
                'nama'             => 'KAPAL PENDUKUNG OPERASI PEMBUDIDAYAAN IKAN',
            ],
            [
                'id_aset'          => 885,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '031',
                'nama'             => 'KAPAL PENGAWAS PERIKANAN',
            ],
            [
                'id_aset'          => 886,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '032',
                'nama'             => 'PERAHU INTAI 3 ORANG',
            ],
            [
                'id_aset'          => 887,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '033',
                'nama'             => 'PERAHU SERBU 15 ORANG',
            ],
            [
                'id_aset'          => 888,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '034',
                'nama'             => 'KAPAL PATROLI POLISI',
            ],
            [
                'id_aset'          => 889,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '035',
                'nama'             => 'JET SKY',
            ],
            [
                'id_aset'          => 890,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR KHUSUS LAINNYA',
            ],
            [
                'id_aset'          => 891,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 892,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '03',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN APUNG BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 893,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR',
            ],
            [
                'id_aset'          => 894,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR UNTUK BARANG',
            ],
            [
                'id_aset'          => 895,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TONGKANG',
            ],
            [
                'id_aset'          => 896,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERAHU BARANG',
            ],
            [
                'id_aset'          => 897,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR UNTUK BARANG LAINNYA',
            ],
            [
                'id_aset'          => 898,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR UNTUK PENUMPANG',
            ],
            [
                'id_aset'          => 899,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PERAHU PENUMPANG',
            ],
            [
                'id_aset'          => 900,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERAHU PENYEBERANGAN',
            ],
            [
                'id_aset'          => 901,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR UNTUK PENUMPANG LAINNYA',
            ],
            [
                'id_aset'          => 902,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR KHUSUS',
            ],
            [
                'id_aset'          => 903,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PONTON',
            ],
            [
                'id_aset'          => 904,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERAHU KARET (ALAT ANGKUTAN APUNG TAK BERMOTOR KHUSUS)',
            ],
            [
                'id_aset'          => 905,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PONTON RUMAH',
            ],
            [
                'id_aset'          => 906,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'FLOATING PLATFORM/RAKIT',
            ],
            [
                'id_aset'          => 907,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR KHUSUS LAINNYA',
            ],
            [
                'id_aset'          => 908,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 909,
                'golongan'         => '3',
                'bidang'           => '02',
                'kelompok'         => '04',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT ANGKUTAN APUNG TAK BERMOTOR LAINNYA',
            ],
            [
                'id_aset'          => 910,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BENGKEL DAN ALAT UKUR',
            ],
            [
                'id_aset'          => 911,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BENGKEL BERMESIN',
            ],
            [
                'id_aset'          => 912,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS KONSTRUKSI LOGAM TERPASANG PADA PONDASI',
            ],
            [
                'id_aset'          => 913,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN BUBUT',
            ],
            [
                'id_aset'          => 914,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN FRAIS',
            ],
            [
                'id_aset'          => 915,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN KETAM (PERKAKAS KONSTRUKSI LOGAM TERPASANG PADA PONDASI)',
            ],
            [
                'id_aset'          => 916,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN PRESS HIDROLIK & PUNCH',
            ],
            [
                'id_aset'          => 917,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN BOR',
            ],
            [
                'id_aset'          => 918,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN GERGAJI LOGAM',
            ],
            [
                'id_aset'          => 919,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN GERINDA',
            ],
            [
                'id_aset'          => 920,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MESIN ROL',
            ],
            [
                'id_aset'          => 921,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MESIN BOR CYLINDER',
            ],
            [
                'id_aset'          => 922,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MESIN SKRUP',
            ],
            [
                'id_aset'          => 923,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'MESIN MEILING',
            ],
            [
                'id_aset'          => 924,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '012',
                'nama'             => 'MESIN PUREL',
            ],
            [
                'id_aset'          => 925,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '013',
                'nama'             => 'MESIN PERAPEN',
            ],
            [
                'id_aset'          => 926,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '014',
                'nama'             => 'MESIN SIKAT KULIT',
            ],
            [
                'id_aset'          => 927,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '015',
                'nama'             => 'MESIN PEMOTONG KULIT',
            ],
            [
                'id_aset'          => 928,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '016',
                'nama'             => 'MESIN JAHIT KULIT',
            ],
            [
                'id_aset'          => 929,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '017',
                'nama'             => 'MESIN PENGEPRES KULIT',
            ],
            [
                'id_aset'          => 930,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '018',
                'nama'             => 'MESIN KOMPRESOR',
            ],
            [
                'id_aset'          => 931,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '019',
                'nama'             => 'MESIN LAS LISTRIK',
            ],
            [
                'id_aset'          => 932,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '020',
                'nama'             => 'MESIN DYNAMO KRON',
            ],
            [
                'id_aset'          => 933,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '021',
                'nama'             => 'MESIN SIKAT BESI KRON',
            ],
            [
                'id_aset'          => 934,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '022',
                'nama'             => 'MESIN PEMOTONG FIBERGLAS/POLIYSTER',
            ],
            [
                'id_aset'          => 935,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '023',
                'nama'             => 'MESIN GULUNG LISTRIK',
            ],
            [
                'id_aset'          => 936,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '024',
                'nama'             => 'MESIN PELUBANG (PERKAKAS KONSTRUKSI LOGAM TERPASANG PADA PONDASI)',
            ],
            [
                'id_aset'          => 937,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '025',
                'nama'             => 'MESIN PENEKUK/LIPAT PLAT',
            ],
            [
                'id_aset'          => 938,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '026',
                'nama'             => 'MESIN GUNTING PLAT',
            ],
            [
                'id_aset'          => 939,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '027',
                'nama'             => 'MESIN PEMBENGKOK UNI',
            ],
            [
                'id_aset'          => 940,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '028',
                'nama'             => 'MESIN AMPLAS PLAT',
            ],
            [
                'id_aset'          => 941,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '029',
                'nama'             => 'MESIN PEMOTONG PLAT',
            ],
            [
                'id_aset'          => 942,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '030',
                'nama'             => 'MESIN TRANSMISSION AUTOMOTIVE',
            ],
            [
                'id_aset'          => 943,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '031',
                'nama'             => 'MESIN PEMBENGKOK LOGAM',
            ],
            [
                'id_aset'          => 944,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '032',
                'nama'             => 'MESIN CRYSTAL GROWING',
            ],
            [
                'id_aset'          => 945,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '033',
                'nama'             => 'MESIN LASER CUTTING',
            ],
            [
                'id_aset'          => 946,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '034',
                'nama'             => 'MESIN LASER WELDING',
            ],
            [
                'id_aset'          => 947,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '035',
                'nama'             => 'MESIN LIPAT PLAT',
            ],
            [
                'id_aset'          => 948,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '036',
                'nama'             => 'MESIN BRIKET',
            ],
            [
                'id_aset'          => 949,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '037',
                'nama'             => 'UNIV. GRINDER SETING VALVE',
            ],
            [
                'id_aset'          => 950,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '038',
                'nama'             => 'UNIV. GRINDER VALVE REPAIR',
            ],
            [
                'id_aset'          => 951,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '039',
                'nama'             => 'MESIN SERUT',
            ],
            [
                'id_aset'          => 952,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '040',
                'nama'             => 'MESIN PROFILE KAYU',
            ],
            [
                'id_aset'          => 953,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS KONSTRUKSI LOGAM TERPASANG PADA PONDASI LAINNYA',
            ],
            [
                'id_aset'          => 954,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS KONSTRUKSI LOGAM YANG TRANSPORTABLE (BERPINDAH)',
            ],
            [
                'id_aset'          => 955,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN GERINDA TANGAN',
            ],
            [
                'id_aset'          => 956,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN BOR TANGAN',
            ],
            [
                'id_aset'          => 957,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN CYLINDER',
            ],
            [
                'id_aset'          => 958,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'RIVETING MACHINE',
            ],
            [
                'id_aset'          => 959,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN GULUNG MANUAL',
            ],
            [
                'id_aset'          => 960,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN AMPELAS TANGAN',
            ],
            [
                'id_aset'          => 961,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN AMPELAS ROL KECIL',
            ],
            [
                'id_aset'          => 962,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MESIN GERGAJI BESI',
            ],
            [
                'id_aset'          => 963,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS KONSTRUKSI LOGAM YANG TRANSPORTABLE (BERPINDAH) LAINNYA',
            ],
            [
                'id_aset'          => 964,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS BENGKEL LISTRIK',
            ],
            [
                'id_aset'          => 965,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'BATTERY CHARGE',
            ],
            [
                'id_aset'          => 966,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'WINDER',
            ],
            [
                'id_aset'          => 967,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TRANSFORMATOR',
            ],
            [
                'id_aset'          => 968,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'SOLDER LISTRIK',
            ],
            [
                'id_aset'          => 969,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'SEDOTAN TIMAH LISTRIK',
            ],
            [
                'id_aset'          => 970,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'ELECTRICAL DISCHARGE',
            ],
            [
                'id_aset'          => 971,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '007',
                'nama'             => 'VERTICAL MACHINING CENTRE',
            ],
            [
                'id_aset'          => 972,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '008',
                'nama'             => 'COPY MILLING',
            ],
            [
                'id_aset'          => 973,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '009',
                'nama'             => 'SURFACE GRINDING PROTH',
            ],
            [
                'id_aset'          => 974,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '010',
                'nama'             => 'CYDRICAL GRINDER YAM',
            ],
            [
                'id_aset'          => 975,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '011',
                'nama'             => 'CAPACITY DIE CASTING',
            ],
            [
                'id_aset'          => 976,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '012',
                'nama'             => 'HMC CINTINATI MILACRON',
            ],
            [
                'id_aset'          => 977,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '013',
                'nama'             => 'ENGINE CYLINDER RESEARCH ENGINE',
            ],
            [
                'id_aset'          => 978,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '014',
                'nama'             => 'VALVE SENSOR',
            ],
            [
                'id_aset'          => 979,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '015',
                'nama'             => 'COORDINATE MEASURING MACHINES',
            ],
            [
                'id_aset'          => 980,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '016',
                'nama'             => 'ENGINE COOLING SYSTEM',
            ],
            [
                'id_aset'          => 981,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '017',
                'nama'             => 'OUTLET MANIFODLD PRESSURE',
            ],
            [
                'id_aset'          => 982,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '018',
                'nama'             => 'IMPULSE ORBITAL WELDER',
            ],
            [
                'id_aset'          => 983,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '019',
                'nama'             => 'AVL DIGAS',
            ],
            [
                'id_aset'          => 984,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '020',
                'nama'             => 'ELECTRIC WIRE ROPE',
            ],
            [
                'id_aset'          => 985,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '021',
                'nama'             => 'STEAM PRESSURE GAUGE',
            ],
            [
                'id_aset'          => 986,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '022',
                'nama'             => 'SAVETUY VALVE',
            ],
            [
                'id_aset'          => 987,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '023',
                'nama'             => 'TRESHER STATIS',
            ],
            [
                'id_aset'          => 988,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '024',
                'nama'             => 'VARIAC',
            ],
            [
                'id_aset'          => 989,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '025',
                'nama'             => 'MIXER (PERKAKAS BENGKEL LISTRIK)',
            ],
            [
                'id_aset'          => 990,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '026',
                'nama'             => 'STEPPING MOTOR',
            ],
            [
                'id_aset'          => 991,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '027',
                'nama'             => 'CYLINDER PRESSURE TRANDUCER',
            ],
            [
                'id_aset'          => 992,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '028',
                'nama'             => 'ENGINE SIMULATION SOFTWARE PACKAGE',
            ],
            [
                'id_aset'          => 993,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '029',
                'nama'             => 'AXHAUST GAS ANALIZER',
            ],
            [
                'id_aset'          => 994,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '030',
                'nama'             => 'CIRCULAR SAW',
            ],
            [
                'id_aset'          => 995,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '031',
                'nama'             => 'TESTER LISTRIK/TELEPON/INTERNET',
            ],
            [
                'id_aset'          => 996,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS BENGKEL LISTRIK LAINNYA (ALAT BENGKEL BERMESIN)',
            ],
            [
                'id_aset'          => 997,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS BENGKEL SERVICE',
            ],
            [
                'id_aset'          => 998,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'AUTO LIFT',
            ],
            [
                'id_aset'          => 999,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'CAR WASHER',
            ],
            [
                'id_aset'          => 1000,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'STEAM CLEANER',
            ],
            [
                'id_aset'          => 1001,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'LUBRIACATING EQUIPMENT',
            ],
            [
                'id_aset'          => 1002,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN SPOORING',
            ],
            [
                'id_aset'          => 1003,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN BALANCER',
            ],
            [
                'id_aset'          => 1004,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '007',
                'nama'             => 'BRAKE DRUM LATHE/MESIN PERATA TROMOL',
            ],
            [
                'id_aset'          => 1005,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PENGASAH LUBANG STANG PISTON',
            ],
            [
                'id_aset'          => 1006,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '009',
                'nama'             => 'LUBRICATING SET (PERKAKAS BENGKEL SERVICE)',
            ],
            [
                'id_aset'          => 1007,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '010',
                'nama'             => 'AIR FILTER REGULATOR',
            ],
            [
                'id_aset'          => 1008,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '011',
                'nama'             => 'DIAMOND CARE DRILL CARE',
            ],
            [
                'id_aset'          => 1009,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '012',
                'nama'             => 'AC MOTOR CONTROL',
            ],
            [
                'id_aset'          => 1010,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS BENGKEL SERVICE LAINNYA (ALAT BENGKEL BERMESIN)',
            ],
            [
                'id_aset'          => 1011,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS PENGANGKAT BERMESIN',
            ],
            [
                'id_aset'          => 1012,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'OVERHEAD CRANE',
            ],
            [
                'id_aset'          => 1013,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'HOIST',
            ],
            [
                'id_aset'          => 1014,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'WINCH/LIR',
            ],
            [
                'id_aset'          => 1015,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS PENGANGKAT BERMESIN LAINNYA',
            ],
            [
                'id_aset'          => 1016,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS BENGKEL KAYU',
            ],
            [
                'id_aset'          => 1017,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN GERGAJI',
            ],
            [
                'id_aset'          => 1018,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN KETAM (PERKAKAS BENGKEL KAYU)',
            ],
            [
                'id_aset'          => 1019,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN BOR KAYU',
            ],
            [
                'id_aset'          => 1020,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN PENGHALUS',
            ],
            [
                'id_aset'          => 1021,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TATAH LISTRIK OSCAR MK 361',
            ],
            [
                'id_aset'          => 1022,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PASAH LISTRIK MKC',
            ],
            [
                'id_aset'          => 1023,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PROFILE LISTRIK MKC',
            ],
            [
                'id_aset'          => 1024,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '008',
                'nama'             => 'GRENDO DUDUK',
            ],
            [
                'id_aset'          => 1025,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '009',
                'nama'             => 'GERGAJI BENGKOK ATS',
            ],
            [
                'id_aset'          => 1026,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '010',
                'nama'             => 'AMPLAS LISTRIK GMT',
            ],
            [
                'id_aset'          => 1027,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '011',
                'nama'             => 'GERGAJI CHAIN SAW',
            ],
            [
                'id_aset'          => 1028,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '012',
                'nama'             => 'TABLE SAW 10 EASTCO',
            ],
            [
                'id_aset'          => 1029,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS BENGKEL KAYU LAINNYA',
            ],
            [
                'id_aset'          => 1030,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS BENGKEL KHUSUS',
            ],
            [
                'id_aset'          => 1031,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN JAHIT TERPAL',
            ],
            [
                'id_aset'          => 1032,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERKAKAS VULKANISIR BAN',
            ],
            [
                'id_aset'          => 1033,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERKAKAS BONGKAR/PASANG BAN',
            ],
            [
                'id_aset'          => 1034,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN TENUN TEKSTIL',
            ],
            [
                'id_aset'          => 1035,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN CELUP (PERKAKAS BENGKEL KHUSUS)',
            ],
            [
                'id_aset'          => 1036,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PEMASANG BARU',
            ],
            [
                'id_aset'          => 1037,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN TENUN JAHIT',
            ],
            [
                'id_aset'          => 1038,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS BENGKEL KHUSUS LAINNYA',
            ],
            [
                'id_aset'          => 1039,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN LAS',
            ],
            [
                'id_aset'          => 1040,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PERALATAN LAS LISTRIK',
            ],
            [
                'id_aset'          => 1041,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERALATAN LAS KARBIT',
            ],
            [
                'id_aset'          => 1042,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERALATAN LAS GAS',
            ],
            [
                'id_aset'          => 1043,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN LAS LAINNYA',
            ],
            [
                'id_aset'          => 1044,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BENGKEL BERMESIN LAINNYA',
            ],
            [
                'id_aset'          => 1045,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT BENGKEL BERMESIN LAINNYA',
            ],
            [
                'id_aset'          => 1046,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BENGKEL TAK BERMESIN',
            ],
            [
                'id_aset'          => 1047,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS BENGKEL KONSTRUKSI LOGAM',
            ],
            [
                'id_aset'          => 1048,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PERKAKAS DAPUR TEMPA',
            ],
            [
                'id_aset'          => 1049,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERKAKAS BANGKU KERJA',
            ],
            [
                'id_aset'          => 1050,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERKAKAS PENGUKUR',
            ],
            [
                'id_aset'          => 1051,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PERKAKAS PENGECORAN LOGAM',
            ],
            [
                'id_aset'          => 1052,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'R O L',
            ],
            [
                'id_aset'          => 1053,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PERKAKAS PEMOTONG PLAT',
            ],
            [
                'id_aset'          => 1054,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PERKAKAS PRESS HIDROLIK',
            ],
            [
                'id_aset'          => 1055,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PERKAKAS PEMOTONG KABEL SLING',
            ],
            [
                'id_aset'          => 1056,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'PERKAKAS PENGECATAN KENDARAAN',
            ],
            [
                'id_aset'          => 1057,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS BENGKEL KONSTRUKSI LOGAM LAINNYA',
            ],
            [
                'id_aset'          => 1058,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS BENGKEL LISTRIK',
            ],
            [
                'id_aset'          => 1059,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ARMATURE DRYING OVEN',
            ],
            [
                'id_aset'          => 1060,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MICA UNDERCUTTER',
            ],
            [
                'id_aset'          => 1061,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'COMMUTATOR TURNING TOOL',
            ],
            [
                'id_aset'          => 1062,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ARMATURE CROWLER',
            ],
            [
                'id_aset'          => 1063,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'SOLID STATE SOLDERING GUN',
            ],
            [
                'id_aset'          => 1064,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS BENGKEL LISTRIK LAINNYA (ALAT BENGKEL TAK BERMESIN)',
            ],
            [
                'id_aset'          => 1065,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS BENGKEL SERVICE',
            ],
            [
                'id_aset'          => 1066,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PERKAKAS BENGKEL SERVICE',
            ],
            [
                'id_aset'          => 1067,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'LUBRICATING SET (PERKAKAS BENGKEL SERVICE)',
            ],
            [
                'id_aset'          => 1068,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERLENGKAPAN BENGKEL MEKANIK',
            ],
            [
                'id_aset'          => 1069,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'JEMBATAN SERVICE HIDROLIK',
            ],
            [
                'id_aset'          => 1070,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS BENGKEL SERVICE LAINNYA (ALAT BENGKEL TAK BERMESIN)',
            ],
            [
                'id_aset'          => 1071,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS PENGANGKAT',
            ],
            [
                'id_aset'          => 1072,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'DONGKRAK MEKANIK',
            ],
            [
                'id_aset'          => 1073,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'DONGKRAK HIDROLIK',
            ],
            [
                'id_aset'          => 1074,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'T A K E L',
            ],
            [
                'id_aset'          => 1075,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'G A N T R Y',
            ],
            [
                'id_aset'          => 1076,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'T R I P O D',
            ],
            [
                'id_aset'          => 1077,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '006',
                'nama'             => 'FLOOR CRANE',
            ],
            [
                'id_aset'          => 1078,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS PENGANGKAT LAINNYA',
            ],
            [
                'id_aset'          => 1079,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS STANDARD (STANDARD TOOLS)',
            ],
            [
                'id_aset'          => 1080,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TOOL KIT SET',
            ],
            [
                'id_aset'          => 1081,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TOOL KIT BOX',
            ],
            [
                'id_aset'          => 1082,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TOOL CABINET SET',
            ],
            [
                'id_aset'          => 1083,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'KUNCI PIPA',
            ],
            [
                'id_aset'          => 1084,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PULLER SET',
            ],
            [
                'id_aset'          => 1085,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TAP DIES',
            ],
            [
                'id_aset'          => 1086,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'GREEPER',
            ],
            [
                'id_aset'          => 1087,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'ENGINE STAND',
            ],
            [
                'id_aset'          => 1088,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '009',
                'nama'             => 'KUNCI MOMENT',
            ],
            [
                'id_aset'          => 1089,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '010',
                'nama'             => 'PEMBUAT FISIK (DIESS)',
            ],
            [
                'id_aset'          => 1090,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TUNGKU NON FERROUS',
            ],
            [
                'id_aset'          => 1091,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '012',
                'nama'             => 'WHEEL CHOCK (PERKAKAS STANDARD (STANDARD TOOLS))',
            ],
            [
                'id_aset'          => 1092,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '013',
                'nama'             => 'MAINTENANCE STEP',
            ],
            [
                'id_aset'          => 1093,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '014',
                'nama'             => 'CRIMPING TOLLS',
            ],
            [
                'id_aset'          => 1094,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '015',
                'nama'             => 'TOOLKIT TUKANG KAYU TON',
            ],
            [
                'id_aset'          => 1095,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '016',
                'nama'             => 'TOOLKIT TUKANG BATU TON',
            ],
            [
                'id_aset'          => 1096,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '017',
                'nama'             => 'TOOLKIT TUKANG LISTRIK',
            ],
            [
                'id_aset'          => 1097,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '018',
                'nama'             => 'TOOLKIT PEMELIHARAAN',
            ],
            [
                'id_aset'          => 1098,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '019',
                'nama'             => 'TOOLKIT PERBENGKELAN',
            ],
            [
                'id_aset'          => 1099,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '020',
                'nama'             => 'TOOLKIT PERPIPAAN',
            ],
            [
                'id_aset'          => 1100,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '021',
                'nama'             => 'TOOL OUTFIT PIONER ELECTRIC',
            ],
            [
                'id_aset'          => 1101,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '022',
                'nama'             => 'TOOL GENERAL MECHANIC SET',
            ],
            [
                'id_aset'          => 1102,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '023',
                'nama'             => 'TOOLKIT TUKANG BESI',
            ],
            [
                'id_aset'          => 1103,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '024',
                'nama'             => 'TOOL ELECTRICAL SET',
            ],
            [
                'id_aset'          => 1104,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '025',
                'nama'             => 'SAWMIL',
            ],
            [
                'id_aset'          => 1105,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '026',
                'nama'             => 'UNIT PELUMAS PORTABLE',
            ],
            [
                'id_aset'          => 1106,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '027',
                'nama'             => 'SCAFOLDING SET & TOOL',
            ],
            [
                'id_aset'          => 1107,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '028',
                'nama'             => 'HAND FALLET',
            ],
            [
                'id_aset'          => 1108,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '029',
                'nama'             => 'PARON',
            ],
            [
                'id_aset'          => 1109,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '030',
                'nama'             => 'CYLINDER BEARING',
            ],
            [
                'id_aset'          => 1110,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '031',
                'nama'             => 'PERLENGKAPAN BENGKEL PENGECATAN',
            ],
            [
                'id_aset'          => 1111,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS STANDARD (STANDARD TOOLS) LAINNYA',
            ],
            [
                'id_aset'          => 1112,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS KHUSUS (SPECIAL TOOLS)',
            ],
            [
                'id_aset'          => 1113,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'KUNCI KHUSUS UNTUK ENGINE',
            ],
            [
                'id_aset'          => 1114,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'KUNCI KHUSUS ALAT BESAR DARAT',
            ],
            [
                'id_aset'          => 1115,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KUNCI KHUSUS ALAT BESAR APUNG',
            ],
            [
                'id_aset'          => 1116,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '004',
                'nama'             => 'KUNCI KHUSUS CASIS ALAT ANGKUT DARAT',
            ],
            [
                'id_aset'          => 1117,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '005',
                'nama'             => 'KUNCI KHUSUS CASIS',
            ],
            [
                'id_aset'          => 1118,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '006',
                'nama'             => 'KUNCI KHUSUS ALAT ANGKUT APUNG',
            ],
            [
                'id_aset'          => 1119,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '007',
                'nama'             => 'KUNCI KHUSUS PEMBUKA MUR/BAUT',
            ],
            [
                'id_aset'          => 1120,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '008',
                'nama'             => 'KUNCI KHUSUS MOMENT',
            ],
            [
                'id_aset'          => 1121,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '009',
                'nama'             => 'KUNCI KHUSUS ALAT BESAR UDARA',
            ],
            [
                'id_aset'          => 1122,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '010',
                'nama'             => 'KUNCI KHUSUS CASIS ALAT BESAR UDARA',
            ],
            [
                'id_aset'          => 1123,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '011',
                'nama'             => 'DIGITAL TANG AMPERE',
            ],
            [
                'id_aset'          => 1124,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '012',
                'nama'             => 'DIGITAL TACHOMETER',
            ],
            [
                'id_aset'          => 1125,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '013',
                'nama'             => 'FOOT KLEP',
            ],
            [
                'id_aset'          => 1126,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '014',
                'nama'             => 'CINCIN/KOPLING SLANG HYDRANT',
            ],
            [
                'id_aset'          => 1127,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '015',
                'nama'             => 'KUNCI L',
            ],
            [
                'id_aset'          => 1128,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '016',
                'nama'             => 'TBA',
            ],
            [
                'id_aset'          => 1129,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS KHUSUS (SPECIAL TOOLS) LAINNYA',
            ],
            [
                'id_aset'          => 1130,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERKAKAS BENGKEL KERJA',
            ],
            [
                'id_aset'          => 1131,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'GERGAJI',
            ],
            [
                'id_aset'          => 1132,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'KETAM',
            ],
            [
                'id_aset'          => 1133,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'BOR',
            ],
            [
                'id_aset'          => 1134,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PAHAT',
            ],
            [
                'id_aset'          => 1135,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '005',
                'nama'             => 'KAKAK TUA',
            ],
            [
                'id_aset'          => 1136,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '006',
                'nama'             => 'WATER PAS',
            ],
            [
                'id_aset'          => 1137,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '007',
                'nama'             => 'SIKU',
            ],
            [
                'id_aset'          => 1138,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PALU',
            ],
            [
                'id_aset'          => 1139,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS BENGKEL KERJA LAINNYA',
            ],
            [
                'id_aset'          => 1140,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN TUKANG BESI',
            ],
            [
                'id_aset'          => 1141,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TANGGEM',
            ],
            [
                'id_aset'          => 1142,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '002',
                'nama'             => 'GUNTING PLAT',
            ],
            [
                'id_aset'          => 1143,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '003',
                'nama'             => 'LANDASAN KENTENG',
            ],
            [
                'id_aset'          => 1144,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '004',
                'nama'             => 'KUNCI KAUL',
            ],
            [
                'id_aset'          => 1145,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '005',
                'nama'             => 'GUNTING PLAT TANGAN',
            ],
            [
                'id_aset'          => 1146,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TANG KOMBINASI',
            ],
            [
                'id_aset'          => 1147,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TANG POTONG',
            ],
            [
                'id_aset'          => 1148,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '008',
                'nama'             => 'BETEL',
            ],
            [
                'id_aset'          => 1149,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '009',
                'nama'             => 'PUKUL KONDE',
            ],
            [
                'id_aset'          => 1150,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '010',
                'nama'             => 'PUKUL LENGKUNG',
            ],
            [
                'id_aset'          => 1151,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '011',
                'nama'             => 'PUKUL SABIT',
            ],
            [
                'id_aset'          => 1152,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '012',
                'nama'             => 'KIKIR',
            ],
            [
                'id_aset'          => 1153,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '013',
                'nama'             => 'KUNCI PAS',
            ],
            [
                'id_aset'          => 1154,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '014',
                'nama'             => 'TANG SENAI & TAP',
            ],
            [
                'id_aset'          => 1155,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '015',
                'nama'             => 'DREI BIASA (OBENG)',
            ],
            [
                'id_aset'          => 1156,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '016',
                'nama'             => 'DREI KEMBANG (OBENG)',
            ],
            [
                'id_aset'          => 1157,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '017',
                'nama'             => 'DREI KETOK (OBENG)',
            ],
            [
                'id_aset'          => 1158,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '018',
                'nama'             => 'SEKET MAT',
            ],
            [
                'id_aset'          => 1159,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '019',
                'nama'             => 'JANGKA BESI',
            ],
            [
                'id_aset'          => 1160,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '020',
                'nama'             => 'KUNCI STANG',
            ],
            [
                'id_aset'          => 1161,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN TUKANG BESI LAINNYA',
            ],
            [
                'id_aset'          => 1162,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN TUKANG KAYU',
            ],
            [
                'id_aset'          => 1163,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TATAH BIASA',
            ],
            [
                'id_aset'          => 1164,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TATAH LENGKUNG',
            ],
            [
                'id_aset'          => 1165,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KAOTA',
            ],
            [
                'id_aset'          => 1166,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PETEL',
            ],
            [
                'id_aset'          => 1167,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PATAR',
            ],
            [
                'id_aset'          => 1168,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '006',
                'nama'             => 'BOR ENGKOL',
            ],
            [
                'id_aset'          => 1169,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PERLENGKAPAN BENGKEL KAYU',
            ],
            [
                'id_aset'          => 1170,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN TUKANG KAYU LAINNYA',
            ],
            [
                'id_aset'          => 1171,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN TUKANG KULIT',
            ],
            [
                'id_aset'          => 1172,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PISAU KULIT',
            ],
            [
                'id_aset'          => 1173,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PANDOKAN SEPATU',
            ],
            [
                'id_aset'          => 1174,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '003',
                'nama'             => 'LIS SEPATU',
            ],
            [
                'id_aset'          => 1175,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '004',
                'nama'             => 'COKRO',
            ],
            [
                'id_aset'          => 1176,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PLONG KULIT',
            ],
            [
                'id_aset'          => 1177,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '006',
                'nama'             => 'CATUT',
            ],
            [
                'id_aset'          => 1178,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PUKUL SEPATU',
            ],
            [
                'id_aset'          => 1179,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '008',
                'nama'             => 'GUNTING KULIT',
            ],
            [
                'id_aset'          => 1180,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '009',
                'nama'             => 'GUNTING KAIN',
            ],
            [
                'id_aset'          => 1181,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '010',
                'nama'             => 'DREK MATA AYAM',
            ],
            [
                'id_aset'          => 1182,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '012',
                'nama'             => 'UNCEK',
            ],
            [
                'id_aset'          => 1183,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN TUKANG KULIT LAINNYA',
            ],
            [
                'id_aset'          => 1184,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN UKUR',
            ],
            [
                'id_aset'          => 1185,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '001',
                'nama'             => 'DIPAN UKUR',
            ],
            [
                'id_aset'          => 1186,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '002',
                'nama'             => 'METERAN KAIN',
            ],
            [
                'id_aset'          => 1187,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ROL METER',
            ],
            [
                'id_aset'          => 1188,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '004',
                'nama'             => 'JANGKA BERKAKI',
            ],
            [
                'id_aset'          => 1189,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PATAR GIP',
            ],
            [
                'id_aset'          => 1190,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PISAU GIP',
            ],
            [
                'id_aset'          => 1191,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PARAREL BAR',
            ],
            [
                'id_aset'          => 1192,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '008',
                'nama'             => 'CERMIN BESAR',
            ],
            [
                'id_aset'          => 1193,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TANGGA LATIHAN',
            ],
            [
                'id_aset'          => 1194,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TRAP LATIHAN',
            ],
            [
                'id_aset'          => 1195,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN UKUR',
            ],
            [
                'id_aset'          => 1196,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN BENGKEL KHUSUS PELADAM',
            ],
            [
                'id_aset'          => 1197,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN CNC',
            ],
            [
                'id_aset'          => 1198,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '002',
                'nama'             => 'DYNAMO TUNGKU',
            ],
            [
                'id_aset'          => 1199,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN FRAIS',
            ],
            [
                'id_aset'          => 1200,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN SKRAF',
            ],
            [
                'id_aset'          => 1201,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN BOR MEJA / KAKI LISTRIK',
            ],
            [
                'id_aset'          => 1202,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PALU BESAR',
            ],
            [
                'id_aset'          => 1203,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN KORTER',
            ],
            [
                'id_aset'          => 1204,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PALU KECIL',
            ],
            [
                'id_aset'          => 1205,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MESIN GERINDA DUDUK (BENCH GERINDA)',
            ],
            [
                'id_aset'          => 1206,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '010',
                'nama'             => 'GEGEP PEMOTONG KUKU',
            ],
            [
                'id_aset'          => 1207,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '011',
                'nama'             => 'GEGEP PEMOTONG PAKU',
            ],
            [
                'id_aset'          => 1208,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '012',
                'nama'             => 'PISAU RENET',
            ],
            [
                'id_aset'          => 1209,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '013',
                'nama'             => 'MESIN JAHIT TERPAL',
            ],
            [
                'id_aset'          => 1210,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '014',
                'nama'             => 'PELOBANG TAPEL',
            ],
            [
                'id_aset'          => 1211,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '015',
                'nama'             => 'TANG BUAYA',
            ],
            [
                'id_aset'          => 1212,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '016',
                'nama'             => 'MESIN BATTERY SET / PENGISI ACCU',
            ],
            [
                'id_aset'          => 1213,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '017',
                'nama'             => 'PERALATAN BENGKEL LAINNYA',
            ],
            [
                'id_aset'          => 1214,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '018',
                'nama'             => 'MESIN BLOWER LISTRIK / MEKANIK',
            ],
            [
                'id_aset'          => 1215,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '019',
                'nama'             => 'MESIN SIKAT / BRUSH MACHINE',
            ],
            [
                'id_aset'          => 1216,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '020',
                'nama'             => 'MESIN PEMBUKA BAN',
            ],
            [
                'id_aset'          => 1217,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '021',
                'nama'             => 'MESIN SLEP KRUK AS',
            ],
            [
                'id_aset'          => 1218,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '022',
                'nama'             => 'MESIN ASAH SILIDER COP',
            ],
            [
                'id_aset'          => 1219,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '023',
                'nama'             => 'MESIN GULUNG SPOOL',
            ],
            [
                'id_aset'          => 1220,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '024',
                'nama'             => 'MESIN GULUNG PLAT',
            ],
            [
                'id_aset'          => 1221,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '025',
                'nama'             => 'MESIN POMPA AIR PMK',
            ],
            [
                'id_aset'          => 1222,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '026',
                'nama'             => 'MESIN ASAH KLEP',
            ],
            [
                'id_aset'          => 1223,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '027',
                'nama'             => 'MESIN TUSUK / STIK',
            ],
            [
                'id_aset'          => 1224,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '028',
                'nama'             => 'MESIN BOR LISTRIK TANGAN',
            ],
            [
                'id_aset'          => 1225,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '029',
                'nama'             => 'MESIN NIMBLING',
            ],
            [
                'id_aset'          => 1226,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '030',
                'nama'             => 'MESIN GERINDA TANGAN LISTRIK',
            ],
            [
                'id_aset'          => 1227,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '031',
                'nama'             => 'MESIN POTONG PLAT BENTUK / HAND NIMBLER',
            ],
            [
                'id_aset'          => 1228,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '032',
                'nama'             => 'UNIT CAT',
            ],
            [
                'id_aset'          => 1229,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '033',
                'nama'             => 'CUT OFF SAW',
            ],
            [
                'id_aset'          => 1230,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '034',
                'nama'             => 'MESIN ANALISA SYSTEM',
            ],
            [
                'id_aset'          => 1231,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '035',
                'nama'             => 'BLENDER LAS POTONG',
            ],
            [
                'id_aset'          => 1232,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '036',
                'nama'             => 'MESIN CUCI KENDARAAN/ CAR WASHER',
            ],
            [
                'id_aset'          => 1233,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '037',
                'nama'             => 'PERKAKAS AC',
            ],
            [
                'id_aset'          => 1234,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN BENGKEL KHUSUS PELADAM LAINNYA',
            ],
            [
                'id_aset'          => 1235,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT BENGKEL TAK BERMESIN LAINNYA',
            ],
            [
                'id_aset'          => 1236,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT BENGKEL TAK BERMESIN LAINNYA',
            ],
            [
                'id_aset'          => 1237,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT UKUR',
            ],
            [
                'id_aset'          => 1238,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT UKUR UNIVERSAL',
            ],
            [
                'id_aset'          => 1239,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'AF GENERATOR TONE GENERATOR',
            ],
            [
                'id_aset'          => 1240,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'AUDIO SIGNAL SOURCE',
            ],
            [
                'id_aset'          => 1241,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'AUDIO TEST SET',
            ],
            [
                'id_aset'          => 1242,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'AUDIO MORSE & DISTRIBUTOR METER',
            ],
            [
                'id_aset'          => 1243,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'AUDIO SWEEP OSILATOR',
            ],
            [
                'id_aset'          => 1244,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'VTVM VOLT',
            ],
            [
                'id_aset'          => 1245,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'INDEPENDENCE METER',
            ],
            [
                'id_aset'          => 1246,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'DECIBLE METER',
            ],
            [
                'id_aset'          => 1247,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'CRT TESTER',
            ],
            [
                'id_aset'          => 1248,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'CIRCUIT TESTER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1249,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'ELECTRONIC CAPASITOR TESTER',
            ],
            [
                'id_aset'          => 1250,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '012',
                'nama'             => 'ILLUMINO METER',
            ],
            [
                'id_aset'          => 1251,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '013',
                'nama'             => 'IC TESTER SEMI TEST IV',
            ],
            [
                'id_aset'          => 1252,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '014',
                'nama'             => 'IC METER',
            ],
            [
                'id_aset'          => 1253,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '015',
                'nama'             => 'MIHVOLT METER',
            ],
            [
                'id_aset'          => 1254,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '016',
                'nama'             => 'MULTITESTER & ACCESSORIE',
            ],
            [
                'id_aset'          => 1255,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '017',
                'nama'             => 'MULTISESTER DIGITAL',
            ],
            [
                'id_aset'          => 1256,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '018',
                'nama'             => 'PHOTO ILLUMINATION METER',
            ],
            [
                'id_aset'          => 1257,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '019',
                'nama'             => 'TRANSISTOR TESTER SEMITEST I',
            ],
            [
                'id_aset'          => 1258,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '020',
                'nama'             => 'TRANSISTOR TESTER SEMITEST II',
            ],
            [
                'id_aset'          => 1259,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '021',
                'nama'             => 'TRANSISTOR TESTER SEMITEST V',
            ],
            [
                'id_aset'          => 1260,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '022',
                'nama'             => 'TRANSISTOR TESTER AVO',
            ],
            [
                'id_aset'          => 1261,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '023',
                'nama'             => 'VOLT METER ELEKTRONIK',
            ],
            [
                'id_aset'          => 1262,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '024',
                'nama'             => 'VOLT METER DIGITAL',
            ],
            [
                'id_aset'          => 1263,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '025',
                'nama'             => 'VOLT METER HIGT TENSION',
            ],
            [
                'id_aset'          => 1264,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '026',
                'nama'             => 'WIDW BAND LEVEL METER',
            ],
            [
                'id_aset'          => 1265,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '027',
                'nama'             => 'AUTOMATIC DISTROTION METER',
            ],
            [
                'id_aset'          => 1266,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '028',
                'nama'             => 'POWER METER AND ACCESSORIES',
            ],
            [
                'id_aset'          => 1267,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '029',
                'nama'             => 'PH METER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1268,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '030',
                'nama'             => 'QUASI PEAK METER',
            ],
            [
                'id_aset'          => 1269,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '031',
                'nama'             => 'THRULINE WATT METER',
            ],
            [
                'id_aset'          => 1270,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '032',
                'nama'             => 'DIGITAL MULTIMETER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1271,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '033',
                'nama'             => 'MULTI METER',
            ],
            [
                'id_aset'          => 1272,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '034',
                'nama'             => 'METER CALIBRATOR',
            ],
            [
                'id_aset'          => 1273,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '035',
                'nama'             => 'MOISE FIGURE METER',
            ],
            [
                'id_aset'          => 1274,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '036',
                'nama'             => 'DISTORTION ANALYZER',
            ],
            [
                'id_aset'          => 1275,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '037',
                'nama'             => 'VECTOR VOLT METER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1276,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '038',
                'nama'             => 'PULSE GENERATOR (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1277,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '039',
                'nama'             => 'DME GROUND STATION TEST SET (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1278,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '040',
                'nama'             => 'UHF SIGNAL GENERATOR',
            ],
            [
                'id_aset'          => 1279,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '041',
                'nama'             => 'SWEEP OSCILLATOR (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1280,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '042',
                'nama'             => 'VHF SIGNAL GENERATOR',
            ],
            [
                'id_aset'          => 1281,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '043',
                'nama'             => 'SPEKTRUM ANALYZER',
            ],
            [
                'id_aset'          => 1282,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '044',
                'nama'             => 'TUBE TESTER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1283,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '045',
                'nama'             => 'DOSIMETER & ACCESORIES',
            ],
            [
                'id_aset'          => 1284,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '046',
                'nama'             => 'SURVEY METER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1285,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '047',
                'nama'             => 'SOUND DETECTOR',
            ],
            [
                'id_aset'          => 1286,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '048',
                'nama'             => 'VIDICON QUICK TESTER',
            ],
            [
                'id_aset'          => 1287,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '049',
                'nama'             => 'PATTERN FOR TV ADJUSTMENT',
            ],
            [
                'id_aset'          => 1288,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '050',
                'nama'             => 'POWER METER CILLIBRATOR',
            ],
            [
                'id_aset'          => 1289,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '051',
                'nama'             => 'THERMISTOR',
            ],
            [
                'id_aset'          => 1290,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '052',
                'nama'             => 'SIGNAL GENERATOR AUDIO VHF',
            ],
            [
                'id_aset'          => 1291,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '053',
                'nama'             => 'X - TAL DETECTOR',
            ],
            [
                'id_aset'          => 1292,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '054',
                'nama'             => 'CO - AXIAL SLOT LINE',
            ],
            [
                'id_aset'          => 1293,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '055',
                'nama'             => 'RF VOLT METER',
            ],
            [
                'id_aset'          => 1294,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '056',
                'nama'             => 'FREKQUENCY WAVE METER',
            ],
            [
                'id_aset'          => 1295,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '057',
                'nama'             => 'MEGGER',
            ],
            [
                'id_aset'          => 1296,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '058',
                'nama'             => 'CO AXIAL ATTENUATOR',
            ],
            [
                'id_aset'          => 1297,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '059',
                'nama'             => 'VARIABEL CO AXIAL ATTENUATOR',
            ],
            [
                'id_aset'          => 1298,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '060',
                'nama'             => 'DIRECTIONAL COUPLER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1299,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '061',
                'nama'             => 'PIN MODULATOR',
            ],
            [
                'id_aset'          => 1300,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '062',
                'nama'             => 'LOGIG TROUBLE SHOTING KIT',
            ],
            [
                'id_aset'          => 1301,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '063',
                'nama'             => 'SWR METER',
            ],
            [
                'id_aset'          => 1302,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '064',
                'nama'             => 'MEMORI PROGRAMMER',
            ],
            [
                'id_aset'          => 1303,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '065',
                'nama'             => 'LOGIG STATC ANALYZER',
            ],
            [
                'id_aset'          => 1304,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '066',
                'nama'             => 'FREQUENCY CUONTER',
            ],
            [
                'id_aset'          => 1305,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '067',
                'nama'             => 'UNIVERSAL BRIDGE',
            ],
            [
                'id_aset'          => 1306,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '068',
                'nama'             => 'FB METER',
            ],
            [
                'id_aset'          => 1307,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '069',
                'nama'             => 'NOISE',
            ],
            [
                'id_aset'          => 1308,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '070',
                'nama'             => 'RADIATION MONITOR ISOTROPIC',
            ],
            [
                'id_aset'          => 1309,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '071',
                'nama'             => 'PHASE METER',
            ],
            [
                'id_aset'          => 1310,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '072',
                'nama'             => 'GLOBAL POSITIONING SYSTEM',
            ],
            [
                'id_aset'          => 1311,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '073',
                'nama'             => 'ILS. CALIBRATION RX.',
            ],
            [
                'id_aset'          => 1312,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '074',
                'nama'             => 'DCP ( ALAT CONTROL ) SENSOR',
            ],
            [
                'id_aset'          => 1313,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '075',
                'nama'             => 'MOISTEUR METER',
            ],
            [
                'id_aset'          => 1314,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '076',
                'nama'             => 'ROTA METER',
            ],
            [
                'id_aset'          => 1315,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '077',
                'nama'             => 'MINI PHASEC VIEW',
            ],
            [
                'id_aset'          => 1316,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '078',
                'nama'             => 'FREQUENCY INVERTER',
            ],
            [
                'id_aset'          => 1317,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '079',
                'nama'             => 'ACCUMETER',
            ],
            [
                'id_aset'          => 1318,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '080',
                'nama'             => 'TEMPERATUR DIGITAL',
            ],
            [
                'id_aset'          => 1319,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '081',
                'nama'             => 'ARGOMETER',
            ],
            [
                'id_aset'          => 1320,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '082',
                'nama'             => 'DIAL TEST INDICATOR',
            ],
            [
                'id_aset'          => 1321,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '083',
                'nama'             => 'SPEED METER',
            ],
            [
                'id_aset'          => 1322,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '084',
                'nama'             => 'OIL BATH',
            ],
            [
                'id_aset'          => 1323,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '085',
                'nama'             => 'SPEED DETECTOR',
            ],
            [
                'id_aset'          => 1324,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '086',
                'nama'             => 'THERMOHYGROMETER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1325,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '087',
                'nama'             => 'TRAFFIC COUNTER',
            ],
            [
                'id_aset'          => 1326,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '088',
                'nama'             => 'STANDAR TEST GAUGE',
            ],
            [
                'id_aset'          => 1327,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '090',
                'nama'             => 'SIGMA METER',
            ],
            [
                'id_aset'          => 1328,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '091',
                'nama'             => 'IONISASI METER',
            ],
            [
                'id_aset'          => 1329,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '092',
                'nama'             => 'ROTAN SAMPLER SPLITER',
            ],
            [
                'id_aset'          => 1330,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '093',
                'nama'             => 'HENRY METER',
            ],
            [
                'id_aset'          => 1331,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '094',
                'nama'             => 'MESIN KOCOK HORISONTAL',
            ],
            [
                'id_aset'          => 1332,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '095',
                'nama'             => 'CAPASITOR METER',
            ],
            [
                'id_aset'          => 1333,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '096',
                'nama'             => 'MICROPROCESSOR CONDUCTIVITY',
            ],
            [
                'id_aset'          => 1334,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '097',
                'nama'             => 'UHF OUT PUSTTESSTING EQUIPMENT',
            ],
            [
                'id_aset'          => 1335,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '098',
                'nama'             => 'SHRANGKAGE LIMIT APPARATUS',
            ],
            [
                'id_aset'          => 1336,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '099',
                'nama'             => 'R.F. SIGNAL GENERATOR',
            ],
            [
                'id_aset'          => 1337,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '100',
                'nama'             => 'DEWMETER PRINT',
            ],
            [
                'id_aset'          => 1338,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '102',
                'nama'             => 'ORBITAL SHAKER',
            ],
            [
                'id_aset'          => 1339,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '103',
                'nama'             => 'VHF/UHF DUMMY LOAD',
            ],
            [
                'id_aset'          => 1340,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '104',
                'nama'             => 'OZONIZER',
            ],
            [
                'id_aset'          => 1341,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '105',
                'nama'             => 'PSOPHOMETRIC WEIGHTING NETWORK',
            ],
            [
                'id_aset'          => 1342,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '106',
                'nama'             => 'PERSONAL CDT',
            ],
            [
                'id_aset'          => 1343,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '107',
                'nama'             => 'PORTABLE TEST RECK',
            ],
            [
                'id_aset'          => 1344,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '108',
                'nama'             => 'RADIO METER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1345,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '109',
                'nama'             => 'NMOTOR DRIVE WIRE WROPPER',
            ],
            [
                'id_aset'          => 1346,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '110',
                'nama'             => 'SALINITY TEMP DEPTH ANALIZER',
            ],
            [
                'id_aset'          => 1347,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '111',
                'nama'             => 'DIGITAL CIRCUIT TESTER',
            ],
            [
                'id_aset'          => 1348,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '112',
                'nama'             => 'SALINOMETER',
            ],
            [
                'id_aset'          => 1349,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '113',
                'nama'             => 'FIELD STRENGTH METER',
            ],
            [
                'id_aset'          => 1350,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '114',
                'nama'             => 'ACIENTIFIC SOUNDEER SYSTEM',
            ],
            [
                'id_aset'          => 1351,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '115',
                'nama'             => 'ALTERNEATUR',
            ],
            [
                'id_aset'          => 1352,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '116',
                'nama'             => 'SENTER BAWAH AIR',
            ],
            [
                'id_aset'          => 1353,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '117',
                'nama'             => 'MEGA OHM TESTER',
            ],
            [
                'id_aset'          => 1354,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '118',
                'nama'             => 'SIX PLACE HIDROMANIFOLD',
            ],
            [
                'id_aset'          => 1355,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '119',
                'nama'             => 'INSULATION TESTER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1356,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '120',
                'nama'             => 'SONICATOR VIRSOIC CALL DISLUPTOR',
            ],
            [
                'id_aset'          => 1357,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '121',
                'nama'             => 'ELECTRIC BENCH',
            ],
            [
                'id_aset'          => 1358,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '122',
                'nama'             => 'SWEEP FUNCTION GENERATOR',
            ],
            [
                'id_aset'          => 1359,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '123',
                'nama'             => 'LOADMETER',
            ],
            [
                'id_aset'          => 1360,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '124',
                'nama'             => 'SYSTEM UV STERELISASI DAN SIRKULASI AI',
            ],
            [
                'id_aset'          => 1361,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '125',
                'nama'             => 'COUNTER TESTER',
            ],
            [
                'id_aset'          => 1362,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '126',
                'nama'             => 'SYSTEM FOR CHEMICAL OXYGEN DEMOND',
            ],
            [
                'id_aset'          => 1363,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '127',
                'nama'             => 'THE DACOR SEASPRINT UNDER WATER VEHICLE',
            ],
            [
                'id_aset'          => 1364,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '128',
                'nama'             => 'TITRATION UNIT',
            ],
            [
                'id_aset'          => 1365,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '129',
                'nama'             => 'ULTRASONIC CLEANER (ALAT UKUR UNIVERSAL)',
            ],
            [
                'id_aset'          => 1366,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '130',
                'nama'             => 'WATER ANALYSIS KIT',
            ],
            [
                'id_aset'          => 1367,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '131',
                'nama'             => 'WHEEL METER',
            ],
            [
                'id_aset'          => 1368,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '132',
                'nama'             => 'PROYECTION POLARISCOPE',
            ],
            [
                'id_aset'          => 1369,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '133',
                'nama'             => 'CDMA/GSM TEST',
            ],
            [
                'id_aset'          => 1370,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '134',
                'nama'             => 'ANTENNA SELECTOR',
            ],
            [
                'id_aset'          => 1371,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '135',
                'nama'             => 'LOG PERIODIC ANTENNA',
            ],
            [
                'id_aset'          => 1372,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '136',
                'nama'             => 'ALAT UKUR SIGMAT',
            ],
            [
                'id_aset'          => 1373,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT UKUR UNIVERSAL LAINNYA',
            ],
            [
                'id_aset'          => 1374,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'UNIVERSAL TESTER',
            ],
            [
                'id_aset'          => 1375,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'FREQUENCY COUNTER (UNIVERSAL TESTER)',
            ],
            [
                'id_aset'          => 1376,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'INSULATION RES METER MOD',
            ],
            [
                'id_aset'          => 1377,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'NOISE & DISTORTION METER',
            ],
            [
                'id_aset'          => 1378,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'OSCILATOR DISTORTION METER',
            ],
            [
                'id_aset'          => 1379,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'OSCILATOR TEST SIGNAL',
            ],
            [
                'id_aset'          => 1380,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'OSCILATOR WIDW BAND',
            ],
            [
                'id_aset'          => 1381,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'OSCILATOR SWEEP',
            ],
            [
                'id_aset'          => 1382,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PRECISION ENCODER MONITOR',
            ],
            [
                'id_aset'          => 1383,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '009',
                'nama'             => 'PLAMBICON TEST UNIT',
            ],
            [
                'id_aset'          => 1384,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '010',
                'nama'             => 'SCANNER (UNIVERSAL TESTER)',
            ],
            [
                'id_aset'          => 1385,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TIME INTERVAL UNIT',
            ],
            [
                'id_aset'          => 1386,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '012',
                'nama'             => 'UNIVERSAL COUNTER (UNIVERSAL TESTER)',
            ],
            [
                'id_aset'          => 1387,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '013',
                'nama'             => 'VIDEO NOISE METER',
            ],
            [
                'id_aset'          => 1388,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '014',
                'nama'             => 'ADMINTANCE METER',
            ],
            [
                'id_aset'          => 1389,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '015',
                'nama'             => 'ADMINTANCE BRIDE',
            ],
            [
                'id_aset'          => 1390,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '016',
                'nama'             => 'FIELDSTRENGTH METER',
            ],
            [
                'id_aset'          => 1391,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '017',
                'nama'             => 'RF BRIDGE',
            ],
            [
                'id_aset'          => 1392,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '018',
                'nama'             => 'RF PUSH BUTTON ATTENUATOR',
            ],
            [
                'id_aset'          => 1393,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '019',
                'nama'             => 'VISION AND SOUND NYQUIST DEMODULATOR AMF',
            ],
            [
                'id_aset'          => 1394,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '020',
                'nama'             => 'V.S.W.R STANDING REVIEW',
            ],
            [
                'id_aset'          => 1395,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '022',
                'nama'             => 'DIGITAL FREQUENCE METER',
            ],
            [
                'id_aset'          => 1396,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '023',
                'nama'             => 'VINDICAM QUICK TESTER',
            ],
            [
                'id_aset'          => 1397,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '024',
                'nama'             => 'COAXIAL ATT',
            ],
            [
                'id_aset'          => 1398,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '025',
                'nama'             => 'VARIABLE COAXIAL ATT',
            ],
            [
                'id_aset'          => 1399,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '026',
                'nama'             => 'LOGIC PROBE (UNIVERSAL TESTER)',
            ],
            [
                'id_aset'          => 1400,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '027',
                'nama'             => 'SURVEY METER (UNIVERSAL TESTER)',
            ],
            [
                'id_aset'          => 1401,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '028',
                'nama'             => 'LOGIC COMPARATOR',
            ],
            [
                'id_aset'          => 1402,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'UNIVERSAL TESTER LAINNYA',
            ],
            [
                'id_aset'          => 1403,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT UKUR/PEMBANDING',
            ],
            [
                'id_aset'          => 1404,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UKURAN JOHANSON (ALAT PEMBANDING STANDAR UKURAN PANJANG)',
            ],
            [
                'id_aset'          => 1405,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MICRO INDICATOR (DENGAN PERLENGKAPAN SUPARTO POINTERS DAN REVOLV',
            ],
            [
                'id_aset'          => 1406,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERLENGKAPAN MICRO INDICATOR',
            ],
            [
                'id_aset'          => 1407,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PSYCOMETER VANLAMBRECHT',
            ],
            [
                'id_aset'          => 1408,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PSYCOMETER',
            ],
            [
                'id_aset'          => 1409,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'BAROMETER LOGAM',
            ],
            [
                'id_aset'          => 1410,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '007',
                'nama'             => 'BAROMETER MERCURY',
            ],
            [
                'id_aset'          => 1411,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MANOMETER UNTUK MESIN',
            ],
            [
                'id_aset'          => 1412,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MONOTOR PRECISI',
            ],
            [
                'id_aset'          => 1413,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '010',
                'nama'             => 'ALAT PEMERIKSA MANOMETER ( DENGAN PERLENGKAPAN )',
            ],
            [
                'id_aset'          => 1414,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '011',
                'nama'             => 'ALAT PEMERIKSAAN ZAT CAIR',
            ],
            [
                'id_aset'          => 1415,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '012',
                'nama'             => 'TERMOMETER STANDAR',
            ],
            [
                'id_aset'          => 1416,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '013',
                'nama'             => 'TERMOMETER GOVERMEN TESTER 0 DERAJAT SAMPAI DENGAN 100 DERAJAT C',
            ],
            [
                'id_aset'          => 1417,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '014',
                'nama'             => 'THERMOSTAT ( PENGUJI PEMERIKSAAN TERMOMETER )',
            ],
            [
                'id_aset'          => 1418,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '015',
                'nama'             => 'JAM UKUR ( MEET LOCK )',
            ],
            [
                'id_aset'          => 1419,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '016',
                'nama'             => 'HARDNES TESTER',
            ],
            [
                'id_aset'          => 1420,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '017',
                'nama'             => 'STOPWATCH',
            ],
            [
                'id_aset'          => 1421,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '018',
                'nama'             => 'LOUP',
            ],
            [
                'id_aset'          => 1422,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '019',
                'nama'             => 'PLANIMETER (ALAT UKUR/PEMBANDING)',
            ],
            [
                'id_aset'          => 1423,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '020',
                'nama'             => 'METRA BLOCK',
            ],
            [
                'id_aset'          => 1424,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '021',
                'nama'             => 'LEMARI BAJA PENGERING',
            ],
            [
                'id_aset'          => 1425,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '022',
                'nama'             => 'SANBLAS UNIT',
            ],
            [
                'id_aset'          => 1426,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '023',
                'nama'             => 'ALAT PEMERIKSAAN TIMBANGAN TEKANAN BERODA',
            ],
            [
                'id_aset'          => 1427,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '024',
                'nama'             => 'STELAN INSTRUMEN BOURJE',
            ],
            [
                'id_aset'          => 1428,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '025',
                'nama'             => 'LAMPU UNTUK MENERANGI SKALA NERACA PAKAI STANDAR',
            ],
            [
                'id_aset'          => 1429,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '026',
                'nama'             => 'AVOMETER SU 20 - 20 K',
            ],
            [
                'id_aset'          => 1430,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '027',
                'nama'             => 'TRAPPO 1.000 WATT',
            ],
            [
                'id_aset'          => 1431,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '028',
                'nama'             => 'TOOL SET',
            ],
            [
                'id_aset'          => 1432,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '029',
                'nama'             => 'LANDASAN CAP LENGKAP',
            ],
            [
                'id_aset'          => 1433,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '030',
                'nama'             => 'KAKI TIGA GANTUNGAN DACIN',
            ],
            [
                'id_aset'          => 1434,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '031',
                'nama'             => 'ALAT PENDATAR TAKARAN BENSIN',
            ],
            [
                'id_aset'          => 1435,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '032',
                'nama'             => 'TANG PLOMBIR / SEGEL',
            ],
            [
                'id_aset'          => 1436,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '033',
                'nama'             => 'EXICATOR BESAR',
            ],
            [
                'id_aset'          => 1437,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '034',
                'nama'             => 'EXICATOR KECIL',
            ],
            [
                'id_aset'          => 1438,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '035',
                'nama'             => 'DESICATOR ( SIZE ) 3',
            ],
            [
                'id_aset'          => 1439,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '036',
                'nama'             => 'DESICATOR ( SIZE ) 4',
            ],
            [
                'id_aset'          => 1440,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '037',
                'nama'             => 'BOTOL AIR SALING DARI 25 LITER',
            ],
            [
                'id_aset'          => 1441,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '038',
                'nama'             => 'PICNOMETER',
            ],
            [
                'id_aset'          => 1442,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '039',
                'nama'             => 'DESIMETER ( HIDROMETER )',
            ],
            [
                'id_aset'          => 1443,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '040',
                'nama'             => 'TELESCOPE TILE VARIEBLE',
            ],
            [
                'id_aset'          => 1444,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '041',
                'nama'             => 'OPTICAL STREAN ( UNTUK PEMERIKSAAN KACA )',
            ],
            [
                'id_aset'          => 1445,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '042',
                'nama'             => 'OPTOCAL TEKNIS GANGE ( PENGUKUR TEBAL DINDING )',
            ],
            [
                'id_aset'          => 1446,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '043',
                'nama'             => 'LIFTER CAPASITAS 500 KG',
            ],
            [
                'id_aset'          => 1447,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '044',
                'nama'             => 'TAXIMETER TESTER',
            ],
            [
                'id_aset'          => 1448,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '045',
                'nama'             => 'SPEDOMETER TESTER',
            ],
            [
                'id_aset'          => 1449,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '046',
                'nama'             => 'STANDARD GUAGE BLOCKS',
            ],
            [
                'id_aset'          => 1450,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '047',
                'nama'             => 'FINEST DIRECT READING INTERN MICROMETER OF VARIOS RANGE UP TO 10',
            ],
            [
                'id_aset'          => 1451,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '048',
                'nama'             => 'CONSTANT TEMPERATURE COMBINED BRIDGE THERMOSTAT',
            ],
            [
                'id_aset'          => 1452,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '049',
                'nama'             => 'TRANSPARAN PLASTIC RACK INSERT FOR 20 TEST TEST TUBES 75 X 17',
            ],
            [
                'id_aset'          => 1453,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '050',
                'nama'             => 'WATER BATH PLEXIGLASS CAPASITY 71',
            ],
            [
                'id_aset'          => 1454,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '051',
                'nama'             => 'TEST TUBE RACK STAINLESSTEL WITH 10 HOLES 18 MM DIA',
            ],
            [
                'id_aset'          => 1455,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '052',
                'nama'             => 'CALORIMETER THERMOMETER ACETO BESTMEN CERTIFICATE',
            ],
            [
                'id_aset'          => 1456,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '053',
                'nama'             => 'SIT OF GAUGE PRETITION LANDS BERGER THERMOMETER',
            ],
            [
                'id_aset'          => 1457,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '054',
                'nama'             => 'SET OF 14 HIGHT PRECISION AMERAL THERMOMETER',
            ],
            [
                'id_aset'          => 1458,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '055',
                'nama'             => 'ADDITION TUNER STOP WATCH',
            ],
            [
                'id_aset'          => 1459,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '056',
                'nama'             => 'UNIVERSAL CLAMP',
            ],
            [
                'id_aset'          => 1460,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '057',
                'nama'             => 'UNIVERSAL CLAMP',
            ],
            [
                'id_aset'          => 1461,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '058',
                'nama'             => 'VENIER CALIVER',
            ],
            [
                'id_aset'          => 1462,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '059',
                'nama'             => 'PROPILE PROYEKTOR TOYO SERIE',
            ],
            [
                'id_aset'          => 1463,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '060',
                'nama'             => 'TOOL MAKER MICROSCOPE MAGNIFICATION 30 X',
            ],
            [
                'id_aset'          => 1464,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '061',
                'nama'             => 'MICROSCOPE MULTIVIEW',
            ],
            [
                'id_aset'          => 1465,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT UKUR/PEMBANDING LAINNYA',
            ],
            [
                'id_aset'          => 1466,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT UKUR LAINNYA',
            ],
            [
                'id_aset'          => 1467,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'METER X - 27 DARI PLATINA TRIDIUM',
            ],
            [
                'id_aset'          => 1468,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'H - METER DARI BAJA NIKEL',
            ],
            [
                'id_aset'          => 1469,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KOMPARATOR',
            ],
            [
                'id_aset'          => 1470,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ALAT PENGUKUR GARIS TENGAH',
            ],
            [
                'id_aset'          => 1471,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'BAN UKUR',
            ],
            [
                'id_aset'          => 1472,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '006',
                'nama'             => 'DIAMETER TAPE',
            ],
            [
                'id_aset'          => 1473,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '007',
                'nama'             => 'UKURAN TINGGI ORANG',
            ],
            [
                'id_aset'          => 1474,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '008',
                'nama'             => 'SCHUIFMAAT ( UKURAN INGSUT )',
            ],
            [
                'id_aset'          => 1475,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '009',
                'nama'             => 'LIFTER STANDARD ( 1 LITER )',
            ],
            [
                'id_aset'          => 1476,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '010',
                'nama'             => 'BEJANA UKUR',
            ],
            [
                'id_aset'          => 1477,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '011',
                'nama'             => 'ALAT UKUR KADAR AIR (ALAT UKUR LAINNYA)',
            ],
            [
                'id_aset'          => 1478,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '012',
                'nama'             => 'ALAT UKUR PEMECAH KULIT GABAH',
            ],
            [
                'id_aset'          => 1479,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '013',
                'nama'             => 'RAIN GAUGE',
            ],
            [
                'id_aset'          => 1480,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '014',
                'nama'             => 'NEEDLE LIFT SENSOR',
            ],
            [
                'id_aset'          => 1481,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT UKUR LAINNYA',
            ],
            [
                'id_aset'          => 1482,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT TIMBANGAN/BIARA',
            ],
            [
                'id_aset'          => 1483,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TIMBANGAN JEMBATAN CAPASITAS 10 TON',
            ],
            [
                'id_aset'          => 1484,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TIMBANGAN MEJA CAPASITAS 10 KG',
            ],
            [
                'id_aset'          => 1485,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TIMBANGAN MEJA CAPASITAS 5 KG',
            ],
            [
                'id_aset'          => 1486,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TIMBANGAN BBI CAPASITAS 100 KG',
            ],
            [
                'id_aset'          => 1487,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TIMBANGAN BBI CAPASITAS 25 KG',
            ],
            [
                'id_aset'          => 1488,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'TIMBANGAN BBI CAPASITAS 15 KG ( TIMBANGAN BAYI )',
            ],
            [
                'id_aset'          => 1489,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TIMBANGAN BBI CAPASITAS 10 KG',
            ],
            [
                'id_aset'          => 1490,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TIMBANGAN CEPAT CAPASITAS 10 KG',
            ],
            [
                'id_aset'          => 1491,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TIMBANGAN CEPAT CAPASITAS 25 KG',
            ],
            [
                'id_aset'          => 1492,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TIMBANGAN CEPAT CAPASITAS 200 KG',
            ],
            [
                'id_aset'          => 1493,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TIMBANGAN PEGAS CAPASITAS 10 KG',
            ],
            [
                'id_aset'          => 1494,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '012',
                'nama'             => 'TIMBANGAN PEGAS CAPASITAS 50 KG (ALAT TIMBANGAN/BIARA)',
            ],
            [
                'id_aset'          => 1495,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '014',
                'nama'             => 'TIMBANGAN SURAT CAPASITAS 100 KG',
            ],
            [
                'id_aset'          => 1496,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '015',
                'nama'             => 'TIMBANGAN KWADRAN CAPASITAS 100 KG',
            ],
            [
                'id_aset'          => 1497,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '016',
                'nama'             => 'TIMBANGAN SENTISIMAL DACIN KUNINGAN',
            ],
            [
                'id_aset'          => 1498,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '017',
                'nama'             => 'TIMBANGAN GULA GAVEKA',
            ],
            [
                'id_aset'          => 1499,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '018',
                'nama'             => 'TIMBANGAN GANTUNG CAPASITAS 50 GRAM',
            ],
            [
                'id_aset'          => 1500,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '019',
                'nama'             => 'NERACA HALUS + LEMARI CAPASITAS 500 GRAM',
            ],
            [
                'id_aset'          => 1501,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '020',
                'nama'             => 'NERACA PARAMA E',
            ],
            [
                'id_aset'          => 1502,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '021',
                'nama'             => 'NERACA PARAMA D CAPASITAS 5 GRAM',
            ],
            [
                'id_aset'          => 1503,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '022',
                'nama'             => 'NERACA PERCISI ELEKTRONIK CAPASITAS 1 KG.',
            ],
            [
                'id_aset'          => 1504,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '023',
                'nama'             => 'NERACA PERCISI ( SINGLE PAN ) CAPASITAS 20 KG.',
            ],
            [
                'id_aset'          => 1505,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '024',
                'nama'             => 'NERACA PERCISI ( ELEKTRONIK VACUM ME )',
            ],
            [
                'id_aset'          => 1506,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '025',
                'nama'             => 'NERACA PERCISI 30 KG ( MICRO BALANCE )',
            ],
            [
                'id_aset'          => 1507,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '026',
                'nama'             => 'NERACA PERCISI CAPASITAS 50 GRAM',
            ],
            [
                'id_aset'          => 1508,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '027',
                'nama'             => 'NERACA PERCISI CAPASITAS 1 KG.',
            ],
            [
                'id_aset'          => 1509,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '028',
                'nama'             => 'NERACA TERA E',
            ],
            [
                'id_aset'          => 1510,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '029',
                'nama'             => 'NERACA TERA A CAPASITAS 75 KG.',
            ],
            [
                'id_aset'          => 1511,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '030',
                'nama'             => 'NERACA TERA B CAPASITAS 10 KG.',
            ],
            [
                'id_aset'          => 1512,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '031',
                'nama'             => 'NERACA TORSION BALANCE CAPASITAS 500 GRAM',
            ],
            [
                'id_aset'          => 1513,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '032',
                'nama'             => 'NERACA ANALISA CAPASITAS 1000 GRAM',
            ],
            [
                'id_aset'          => 1514,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '033',
                'nama'             => 'NERACA ANALISA CAPASITAS 20 KG',
            ],
            [
                'id_aset'          => 1515,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '034',
                'nama'             => 'NERACA CAPASITAS 1 KG.',
            ],
            [
                'id_aset'          => 1516,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '035',
                'nama'             => 'NERACA CAPASITAS 20 KG.',
            ],
            [
                'id_aset'          => 1517,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '036',
                'nama'             => 'MOISTER METER',
            ],
            [
                'id_aset'          => 1518,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '037',
                'nama'             => 'NERACA DENGAN DIGITAL DISPLAY',
            ],
            [
                'id_aset'          => 1519,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT TIMBANGAN/BIARA LAINNYA',
            ],
            [
                'id_aset'          => 1520,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ANAK TIMBANGAN / BIARA',
            ],
            [
                'id_aset'          => 1521,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'KILOGRAM TEMBAGA NASIONAL PLATINA',
            ],
            [
                'id_aset'          => 1522,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'KILOGRAM TEMBAGA BENTUK TONG BERSADUR MAS MURNI 1 KG.',
            ],
            [
                'id_aset'          => 1523,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KILOGRAM SEPUH MAS 1 KG. PAKAI TOMBOL',
            ],
            [
                'id_aset'          => 1524,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '004',
                'nama'             => 'KILOGRAM BAJA BERBENTUK TONG BERSADUR CROOM',
            ],
            [
                'id_aset'          => 1525,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '005',
                'nama'             => 'KILOGRAM DARI BAJA BERBENTUK SLINDER',
            ],
            [
                'id_aset'          => 1526,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '006',
                'nama'             => 'KILOGRAM KERJA STANDAR TK.II',
            ],
            [
                'id_aset'          => 1527,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '007',
                'nama'             => 'KILOGRAM STANDAR',
            ],
            [
                'id_aset'          => 1528,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '008',
                'nama'             => 'ANAK TIMBANGAN TEMBAGA KANTOR TK.III',
            ],
            [
                'id_aset'          => 1529,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '009',
                'nama'             => 'ANAK TIMBANGAN MILIGRAM',
            ],
            [
                'id_aset'          => 1530,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '010',
                'nama'             => 'ANAK TIMBANGAN MILIGRAM PLATINA',
            ],
            [
                'id_aset'          => 1531,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '011',
                'nama'             => 'ANAK TIMBANGAN MILIGRAM ALUMINIUM',
            ],
            [
                'id_aset'          => 1532,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '012',
                'nama'             => 'ANAK TIMBANGAN GRAM STANDAR 1 GRAM',
            ],
            [
                'id_aset'          => 1533,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '013',
                'nama'             => 'ANAK TIMBANGAN HALUS DARI 1.000 - 1 GRAM',
            ],
            [
                'id_aset'          => 1534,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '014',
                'nama'             => 'ANAK TIMBANGAN BIASA DARI 1.000 - 1 GRAM',
            ],
            [
                'id_aset'          => 1535,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '015',
                'nama'             => 'ANAK TIMBANGAN BIDUR',
            ],
            [
                'id_aset'          => 1536,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '016',
                'nama'             => 'ANAK TIMBANGAN DARI BESI',
            ],
            [
                'id_aset'          => 1537,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '017',
                'nama'             => 'ANAK TIMBANGAN KEPING ( MULUT KECIL )',
            ],
            [
                'id_aset'          => 1538,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '018',
                'nama'             => 'ANAK TIMBANGAN KEPING ( MULUT BESAR )',
            ],
            [
                'id_aset'          => 1539,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ANAK TIMBANGAN / BIARA LAINNYA',
            ],
            [
                'id_aset'          => 1540,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TAKARAN KERING',
            ],
            [
                'id_aset'          => 1541,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TAKARAN KERING DARI 100 - 50 - 20 LITER',
            ],
            [
                'id_aset'          => 1542,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TAKARAN KERING DARI 10 S/D 0',
            ],
            [
                'id_aset'          => 1543,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TAKARAN KERING LAINNYA',
            ],
            [
                'id_aset'          => 1544,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TAKARAN BAHAN BANGUNAN',
            ],
            [
                'id_aset'          => 1545,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TAKARAN BAHAN BANGUNAN 2 HL BERBENTUK TONG',
            ],
            [
                'id_aset'          => 1546,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TAKARAN BAHAN BANGUNAN LAINNYA',
            ],
            [
                'id_aset'          => 1547,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '000',
                'nama'             => 'TAKARAN LAINNYA',
            ],
            [
                'id_aset'          => 1548,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TAKARAN LATEX/GETAH SUSU',
            ],
            [
                'id_aset'          => 1549,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TAKARAN BUAH KOPI DARI 0',
            ],
            [
                'id_aset'          => 1550,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TAKARAN KAPUK DARI KAYU 2 DAN 1 HL',
            ],
            [
                'id_aset'          => 1551,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TAKARAN MINYAK DARI BESI 0',
            ],
            [
                'id_aset'          => 1552,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TAKARAN GANDUM 0',
            ],
            [
                'id_aset'          => 1553,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '999',
                'nama'             => 'TAKARAN LAINNYA',
            ],
            [
                'id_aset'          => 1554,
                'golongan'         => '3',
                'bidang'           => '03',
                'kelompok'         => '03',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT UKUR LAINNYA',
            ],
            [
                'id_aset'          => 1555,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PERTANIAN',
            ],
            [
                'id_aset'          => 1556,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENGOLAHAN',
            ],
            [
                'id_aset'          => 1557,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENGOLAHAN TANAH DAN TANAMAN',
            ],
            [
                'id_aset'          => 1558,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'BAJAK KAYU',
            ],
            [
                'id_aset'          => 1559,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'BAJAK MUARA',
            ],
            [
                'id_aset'          => 1560,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PACUL',
            ],
            [
                'id_aset'          => 1561,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'LINGGIS',
            ],
            [
                'id_aset'          => 1562,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'GARPU PACUL',
            ],
            [
                'id_aset'          => 1563,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'GARPU KAYU',
            ],
            [
                'id_aset'          => 1564,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'GARPU BESI',
            ],
            [
                'id_aset'          => 1565,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TRACTOR FOUR WHEEL (DENGAN KELENGKAPANNYA)',
            ],
            [
                'id_aset'          => 1566,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TRACTOR TANGAN DENGAN PERLENGKAPANNYA',
            ],
            [
                'id_aset'          => 1567,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENGOLAHAN TANAH DAN TANAMAN LAINNYA',
            ],
            [
                'id_aset'          => 1568,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PEMELIHARAAN TANAMAN/IKAN/TERNAK',
            ],
            [
                'id_aset'          => 1569,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'KORED',
            ],
            [
                'id_aset'          => 1570,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ARIT',
            ],
            [
                'id_aset'          => 1571,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'BABATAN',
            ],
            [
                'id_aset'          => 1572,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PACUL DANGIR',
            ],
            [
                'id_aset'          => 1573,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PENYEMPROT OTOMATIS (AUTOMATIC SPRAYER)',
            ],
            [
                'id_aset'          => 1574,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PENYEMPROT MESIN (POWER SPRAYER)',
            ],
            [
                'id_aset'          => 1575,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PENYEMPROT TANGAN (HAND SPRAYER)',
            ],
            [
                'id_aset'          => 1576,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '008',
                'nama'             => 'ALAT PENYIANG TANAMAN',
            ],
            [
                'id_aset'          => 1577,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PEMELIHARAAN TANAMAN/IKAN/TERNAK LAINNYA',
            ],
            [
                'id_aset'          => 1578,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PANEN',
            ],
            [
                'id_aset'          => 1579,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ANI-ANI',
            ],
            [
                'id_aset'          => 1580,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ALAT PERONTOKAN (THRESSER PEDAL)',
            ],
            [
                'id_aset'          => 1581,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ALAT PERONTOKAN MESIN (POWER THRESSER)',
            ],
            [
                'id_aset'          => 1582,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ALAT PEMIPIL JAGUNG',
            ],
            [
                'id_aset'          => 1583,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'ALAT PENGERING (DRYER)',
            ],
            [
                'id_aset'          => 1584,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'ALAT PENGUKUR KADAR AIR (MOISTURE TESTER)',
            ],
            [
                'id_aset'          => 1585,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '007',
                'nama'             => 'ALAT PENGGILING KOPI',
            ],
            [
                'id_aset'          => 1586,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '008',
                'nama'             => 'ALAT PENGOLAH TEPUNG',
            ],
            [
                'id_aset'          => 1587,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '009',
                'nama'             => 'ALAT BANTU UJI TUMBUH',
            ],
            [
                'id_aset'          => 1588,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '010',
                'nama'             => 'ALAT PENAMPI',
            ],
            [
                'id_aset'          => 1589,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PANEN LAINNYA',
            ],
            [
                'id_aset'          => 1590,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENYIMPAN HASIL PERCOBAAN PERTANIAN',
            ],
            [
                'id_aset'          => 1591,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'COLD STORAGE (KAMAR PENDINGIN)',
            ],
            [
                'id_aset'          => 1592,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SELO (KOTAK PENYIMPANAN) DENGAN PENGATUR TEMPERATUR',
            ],
            [
                'id_aset'          => 1593,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'RAK-RAK PENYIMPAN',
            ],
            [
                'id_aset'          => 1594,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'LEMARI PENYIMPAN',
            ],
            [
                'id_aset'          => 1595,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENYIMPAN HASIL PERCOBAAN PERTANIAN LAINNYA',
            ],
            [
                'id_aset'          => 1596,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT LABORATORIUM PERTANIAN',
            ],
            [
                'id_aset'          => 1597,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ALAT PENGUKUR CURAH HUJAN',
            ],
            [
                'id_aset'          => 1598,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ALAT PENGUKUR CAHAYA',
            ],
            [
                'id_aset'          => 1599,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ALAT PENGUKUR INTENSITAS CAHAYA',
            ],
            [
                'id_aset'          => 1600,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ALAT PENGUKUR TEMPERATUR',
            ],
            [
                'id_aset'          => 1601,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'ALAT PENGUKUR P.H. TANAH (SOIL TESTER)',
            ],
            [
                'id_aset'          => 1602,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'ALAT PENGAMBIL SAMPLE TANAH',
            ],
            [
                'id_aset'          => 1603,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'RICE',
            ],
            [
                'id_aset'          => 1604,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'GRINDDING MILL',
            ],
            [
                'id_aset'          => 1605,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '009',
                'nama'             => 'VOLUME TEST',
            ],
            [
                'id_aset'          => 1606,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '010',
                'nama'             => 'WEIGHT',
            ],
            [
                'id_aset'          => 1607,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '011',
                'nama'             => 'STRAW FACTURE',
            ],
            [
                'id_aset'          => 1608,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '012',
                'nama'             => 'FALLING NUMBER',
            ],
            [
                'id_aset'          => 1609,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '013',
                'nama'             => 'ELECTRODE PH METER',
            ],
            [
                'id_aset'          => 1610,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '014',
                'nama'             => 'ALAT PENURUN KADAR AIR MADU',
            ],
            [
                'id_aset'          => 1611,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT LABORATORIUM PERTANIAN LAINNYA (ALAT PENGOLAHAN PERTANIAN)',
            ],
            [
                'id_aset'          => 1612,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PROSESING',
            ],
            [
                'id_aset'          => 1613,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PENGADUK',
            ],
            [
                'id_aset'          => 1614,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ALAT PENCABUT BULU AYAM',
            ],
            [
                'id_aset'          => 1615,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ALAT PEMBUAT PELET/MAKANAN TERNAK',
            ],
            [
                'id_aset'          => 1616,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ALAT PEMBUAT MOLASE BLOK',
            ],
            [
                'id_aset'          => 1617,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN TETAS',
            ],
            [
                'id_aset'          => 1618,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN PERAH SUSU',
            ],
            [
                'id_aset'          => 1619,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MILK CAN',
            ],
            [
                'id_aset'          => 1620,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PENGUPAS KULIT ARI KEDELAI',
            ],
            [
                'id_aset'          => 1621,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '009',
                'nama'             => 'PEMARUT SERAT SERBA GUNA',
            ],
            [
                'id_aset'          => 1622,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '010',
                'nama'             => 'PENYAWUT SINGKONG',
            ],
            [
                'id_aset'          => 1623,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '011',
                'nama'             => 'GILINGAN BERAS',
            ],
            [
                'id_aset'          => 1624,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '012',
                'nama'             => 'SALINA INJECTOR',
            ],
            [
                'id_aset'          => 1625,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '013',
                'nama'             => 'SCALLER MOTOR',
            ],
            [
                'id_aset'          => 1626,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '014',
                'nama'             => 'ULV CABINET',
            ],
            [
                'id_aset'          => 1627,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '015',
                'nama'             => 'TLC DRAYER',
            ],
            [
                'id_aset'          => 1628,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '016',
                'nama'             => 'MESIN PENCUCI ALAT (MIELE)',
            ],
            [
                'id_aset'          => 1629,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '017',
                'nama'             => 'HYDROLIC PIECES',
            ],
            [
                'id_aset'          => 1630,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '018',
                'nama'             => 'REAPER',
            ],
            [
                'id_aset'          => 1631,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '019',
                'nama'             => 'ELECTRIC DISK CUTTER',
            ],
            [
                'id_aset'          => 1632,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '020',
                'nama'             => 'RAGUM /CATOK',
            ],
            [
                'id_aset'          => 1633,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '021',
                'nama'             => 'DIESEL EGGANE',
            ],
            [
                'id_aset'          => 1634,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '022',
                'nama'             => 'ALAT PROSESING DAGING',
            ],
            [
                'id_aset'          => 1635,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '023',
                'nama'             => 'ALAT PROSESING TELUR',
            ],
            [
                'id_aset'          => 1636,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '024',
                'nama'             => 'ICE CREAM MAKER',
            ],
            [
                'id_aset'          => 1637,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '025',
                'nama'             => 'HAND SEPARATOR',
            ],
            [
                'id_aset'          => 1638,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '026',
                'nama'             => 'MESIN PENEPUNG BERAS',
            ],
            [
                'id_aset'          => 1639,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '027',
                'nama'             => 'ALAT PENGGILING JAGUNG',
            ],
            [
                'id_aset'          => 1640,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '028',
                'nama'             => 'MESIN PENGAYAK TEPUNG',
            ],
            [
                'id_aset'          => 1641,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '029',
                'nama'             => 'PENGOLAHAN PRODUK KERING',
            ],
            [
                'id_aset'          => 1642,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '030',
                'nama'             => 'PENYAWUT BESAR DAN KECIL',
            ],
            [
                'id_aset'          => 1643,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '031',
                'nama'             => 'PROCESSING MULTIGUNA',
            ],
            [
                'id_aset'          => 1644,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '032',
                'nama'             => 'PUMP FOR HPLC AND ACCESSORIES',
            ],
            [
                'id_aset'          => 1645,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '033',
                'nama'             => 'SAUSAGE FEELER MACHINE',
            ],
            [
                'id_aset'          => 1646,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '034',
                'nama'             => 'TWIN PAPER ROLLER BEARING',
            ],
            [
                'id_aset'          => 1647,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '035',
                'nama'             => 'SKINNING CRADLE',
            ],
            [
                'id_aset'          => 1648,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '036',
                'nama'             => 'HEAD RESTRAINER',
            ],
            [
                'id_aset'          => 1649,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '037',
                'nama'             => 'STUNING DEVICE',
            ],
            [
                'id_aset'          => 1650,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '038',
                'nama'             => 'PENYODOK KOTORAN',
            ],
            [
                'id_aset'          => 1651,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '039',
                'nama'             => 'PENGARAH KEPALA',
            ],
            [
                'id_aset'          => 1652,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '040',
                'nama'             => 'OFFAL WASH',
            ],
            [
                'id_aset'          => 1653,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '041',
                'nama'             => 'BEEF SPLITTER',
            ],
            [
                'id_aset'          => 1654,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PROSESING LAINNYA',
            ],
            [
                'id_aset'          => 1655,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PASCA PANEN',
            ],
            [
                'id_aset'          => 1656,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ALAT PENGASAPAN',
            ],
            [
                'id_aset'          => 1657,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ALAT PEMBEKUAN',
            ],
            [
                'id_aset'          => 1658,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ALAT PENGGILING PADI',
            ],
            [
                'id_aset'          => 1659,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ALAT PENCACAH HIJAUAN',
            ],
            [
                'id_aset'          => 1660,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '005',
                'nama'             => 'ALAT PEMECAH TAPIOKA',
            ],
            [
                'id_aset'          => 1661,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PASCA PANEN LAINNYA',
            ],
            [
                'id_aset'          => 1662,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PRODUKSI PERIKANAN',
            ],
            [
                'id_aset'          => 1663,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PUKAT',
            ],
            [
                'id_aset'          => 1664,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '002',
                'nama'             => 'DOUBLE RIG SHRIMP TRAWL/PUKAT UDANG GANDA',
            ],
            [
                'id_aset'          => 1665,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PAYANG ( TERMASUK LAMPARA )',
            ],
            [
                'id_aset'          => 1666,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '004',
                'nama'             => 'DANISH SEINE ( DOGOL )',
            ],
            [
                'id_aset'          => 1667,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '005',
                'nama'             => 'BEACH SEINE ( PUKAT PANTAI )',
            ],
            [
                'id_aset'          => 1668,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '006',
                'nama'             => 'DRIFT GILL NET ( JARING INSANG HANYUT )',
            ],
            [
                'id_aset'          => 1669,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '007',
                'nama'             => 'ENCIRCLING GILL NET ( JARING INSANG LINGKAR )',
            ],
            [
                'id_aset'          => 1670,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '008',
                'nama'             => 'SHRIMP GILL NET ( JARING KLITIK )',
            ],
            [
                'id_aset'          => 1671,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '009',
                'nama'             => 'SET GILL NET ( JARING INSANG TETAP )',
            ],
            [
                'id_aset'          => 1672,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '010',
                'nama'             => 'BOAT RAFT LIFT NET ( BAGAN PERAHU/RAKIT )',
            ],
            [
                'id_aset'          => 1673,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '011',
                'nama'             => 'BAGAN TANCAP BERIKUT KELONG',
            ],
            [
                'id_aset'          => 1674,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '012',
                'nama'             => 'SCOOP NET ( SEROK )',
            ],
            [
                'id_aset'          => 1675,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '013',
                'nama'             => 'JARING ANGKAT LAINNYA',
            ],
            [
                'id_aset'          => 1676,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '014',
                'nama'             => 'GUIDING BARRIER ( SEROK )',
            ],
            [
                'id_aset'          => 1677,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '015',
                'nama'             => 'STOW NET ( JERMAL TERMASUK TOGO )',
            ],
            [
                'id_aset'          => 1678,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '016',
                'nama'             => 'PORTABLE TRAPS ( BUBU )',
            ],
            [
                'id_aset'          => 1679,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '017',
                'nama'             => 'PERANGKAP LAINNYA',
            ],
            [
                'id_aset'          => 1680,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '018',
                'nama'             => 'TUNA LONG LINE ( RAWAI TUNA )',
            ],
            [
                'id_aset'          => 1681,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '019',
                'nama'             => 'SET LONG LINE ( RAWAI TETAP )',
            ],
            [
                'id_aset'          => 1682,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '020',
                'nama'             => 'SKIPJACK POLE AND LINES ( HUHATE )',
            ],
            [
                'id_aset'          => 1683,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '021',
                'nama'             => 'TROOL LINE ( PANCING TONDA )',
            ],
            [
                'id_aset'          => 1684,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '022',
                'nama'             => 'PANCING LAINNYA',
            ],
            [
                'id_aset'          => 1685,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '023',
                'nama'             => 'MUROAMI INC. MALLALUGIS',
            ],
            [
                'id_aset'          => 1686,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '024',
                'nama'             => 'JALA',
            ],
            [
                'id_aset'          => 1687,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '025',
                'nama'             => 'GARPU',
            ],
            [
                'id_aset'          => 1688,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '026',
                'nama'             => 'TOMBAK',
            ],
            [
                'id_aset'          => 1689,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '027',
                'nama'             => 'SEA WATER RESERVOIR',
            ],
            [
                'id_aset'          => 1690,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '028',
                'nama'             => 'BAK PEMELIHARAAN SEMENTARA',
            ],
            [
                'id_aset'          => 1691,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '029',
                'nama'             => 'BAK PENGENDAPAN',
            ],
            [
                'id_aset'          => 1692,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '030',
                'nama'             => 'KERAMBA ( JARING APUNG )',
            ],
            [
                'id_aset'          => 1693,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '031',
                'nama'             => 'JARING LINGKAR',
            ],
            [
                'id_aset'          => 1694,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '032',
                'nama'             => 'PUKAT TARIK BERKAPAL',
            ],
            [
                'id_aset'          => 1695,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '033',
                'nama'             => 'PUKAT HELA',
            ],
            [
                'id_aset'          => 1696,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '034',
                'nama'             => 'PUKAT DORONG',
            ],
            [
                'id_aset'          => 1697,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '035',
                'nama'             => 'PENGGARUK',
            ],
            [
                'id_aset'          => 1698,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '036',
                'nama'             => 'JARING ANGKAT MENETAP',
            ],
            [
                'id_aset'          => 1699,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '037',
                'nama'             => 'JARING ANGKAT TIDAK MENETAP',
            ],
            [
                'id_aset'          => 1700,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '038',
                'nama'             => 'ALAT YANG DIJATUHKAN',
            ],
            [
                'id_aset'          => 1701,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '039',
                'nama'             => 'ALAT PENJEPIT DAN MELUKAI',
            ],
            [
                'id_aset'          => 1702,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PRODUKSI PERIKANAN LAINNYA',
            ],
            [
                'id_aset'          => 1703,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENGOLAHAN LAINNYA',
            ],
            [
                'id_aset'          => 1704,
                'golongan'         => '3',
                'bidang'           => '04',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENGOLAHAN LAINNYA',
            ],
            [
                'id_aset'          => 1705,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KANTOR & RUMAH TANGGA',
            ],
            [
                'id_aset'          => 1706,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KANTOR',
            ],
            [
                'id_aset'          => 1707,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'MESIN KETIK',
            ],
            [
                'id_aset'          => 1708,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN KETIK MANUAL PORTABLE (11-13 INCI)',
            ],
            [
                'id_aset'          => 1709,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN KETIK MANUAL STANDARD (14-16 INCI)',
            ],
            [
                'id_aset'          => 1710,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN KETIK MANUAL LANGEWAGON (18-27 INCI)',
            ],
            [
                'id_aset'          => 1711,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN KETIK LISTRIK',
            ],
            [
                'id_aset'          => 1712,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN KETIK LISTRIK POTABLE (11-13 INCI)',
            ],
            [
                'id_aset'          => 1713,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN KETIK LISTRIK STANDARD (14-16 INCI)',
            ],
            [
                'id_aset'          => 1714,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN KETIK LISTRIK LANGEWAGON (18-27 INCI)',
            ],
            [
                'id_aset'          => 1715,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MESIN KETIK ELEKTRONIK/SELEKTRIK',
            ],
            [
                'id_aset'          => 1716,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MESIN KETIK BRAILLE',
            ],
            [
                'id_aset'          => 1717,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MESIN PHROMOSONS',
            ],
            [
                'id_aset'          => 1718,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'MESIN CETAK STEREO PIPER (BRAILLE)',
            ],
            [
                'id_aset'          => 1719,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'MESIN KETIK LAINNYA',
            ],
            [
                'id_aset'          => 1720,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'MESIN HITUNG/MESIN JUMLAH',
            ],
            [
                'id_aset'          => 1721,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN HITUNG MANUAL',
            ],
            [
                'id_aset'          => 1722,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN HITUNG LISTRIK',
            ],
            [
                'id_aset'          => 1723,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN HITUNG ELEKTRONIK/CALCULATOR',
            ],
            [
                'id_aset'          => 1724,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN KAS REGISTER',
            ],
            [
                'id_aset'          => 1725,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'ABAKUS (ALAT HITUNG)',
            ],
            [
                'id_aset'          => 1726,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'BLOKYCS (MESIN HITUNG BRAILLE)',
            ],
            [
                'id_aset'          => 1727,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN PENGHITUNG UANG',
            ],
            [
                'id_aset'          => 1728,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MESIN PEMBUKUAN',
            ],
            [
                'id_aset'          => 1729,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MESIN PENGHITUNG KERTAS/PITA CUKAI',
            ],
            [
                'id_aset'          => 1730,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'MESIN HITUNG/MESIN JUMLAH LAINNYA',
            ],
            [
                'id_aset'          => 1731,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT REPRODUKSI (PENGGANDAAN)',
            ],
            [
                'id_aset'          => 1732,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN STENSIL MANUAL FOLIO',
            ],
            [
                'id_aset'          => 1733,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN STENSIL MANUAL DOUBLE FOLIO',
            ],
            [
                'id_aset'          => 1734,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN STENSIL LISTRIK FOLIO',
            ],
            [
                'id_aset'          => 1735,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN STENSIL LISTRIK DOUBLE FOLIO',
            ],
            [
                'id_aset'          => 1736,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN STENSIL SPIRITUS MANUAL',
            ],
            [
                'id_aset'          => 1737,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN STENSIL SPIRITUS LISTRIK',
            ],
            [
                'id_aset'          => 1738,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN FOTOCOPY FOLIO',
            ],
            [
                'id_aset'          => 1739,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MESIN FOTOCOPY DOUBLE FOLIO',
            ],
            [
                'id_aset'          => 1740,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MESIN FOTOCOPY ELECTRONIC',
            ],
            [
                'id_aset'          => 1741,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MESIN THERMOFORN',
            ],
            [
                'id_aset'          => 1742,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '011',
                'nama'             => 'MESIN FOTOCOPY LAINNYA',
            ],
            [
                'id_aset'          => 1743,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '012',
                'nama'             => 'RISOGRAF',
            ],
            [
                'id_aset'          => 1744,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT REPRODUKSI (PENGGANDAAN) LAINNYA',
            ],
            [
                'id_aset'          => 1745,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENYIMPAN PERLENGKAPAN KANTOR',
            ],
            [
                'id_aset'          => 1746,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'LEMARI BESI/METAL',
            ],
            [
                'id_aset'          => 1747,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'LEMARI KAYU',
            ],
            [
                'id_aset'          => 1748,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'RAK BESI',
            ],
            [
                'id_aset'          => 1749,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'RAK KAYU',
            ],
            [
                'id_aset'          => 1750,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'FILING CABINET BESI',
            ],
            [
                'id_aset'          => 1751,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '006',
                'nama'             => 'FILING CABINET KAYU',
            ],
            [
                'id_aset'          => 1752,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '007',
                'nama'             => 'BRANDKAS',
            ],
            [
                'id_aset'          => 1753,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PETI UANG/CASH BOX/COIN BOX',
            ],
            [
                'id_aset'          => 1754,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '009',
                'nama'             => 'KARDEX BESI',
            ],
            [
                'id_aset'          => 1755,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '010',
                'nama'             => 'KARDEX KAYU',
            ],
            [
                'id_aset'          => 1756,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '011',
                'nama'             => 'ROTARY FILLING',
            ],
            [
                'id_aset'          => 1757,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '012',
                'nama'             => 'COMPACT ROLLING',
            ],
            [
                'id_aset'          => 1758,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '013',
                'nama'             => 'BUFFET',
            ],
            [
                'id_aset'          => 1759,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '014',
                'nama'             => 'MOBILE FILE',
            ],
            [
                'id_aset'          => 1760,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '015',
                'nama'             => 'LOCKER',
            ],
            [
                'id_aset'          => 1761,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '016',
                'nama'             => 'ROLL OPEK',
            ],
            [
                'id_aset'          => 1762,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '017',
                'nama'             => 'TEMPAT MENYIMPAN GAMBAR',
            ],
            [
                'id_aset'          => 1763,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '018',
                'nama'             => 'KONTAINER',
            ],
            [
                'id_aset'          => 1764,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '019',
                'nama'             => 'COIN BOX',
            ],
            [
                'id_aset'          => 1765,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '020',
                'nama'             => 'LEMARI DISPLAY',
            ],
            [
                'id_aset'          => 1766,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '021',
                'nama'             => 'WATER PROOF BOX',
            ],
            [
                'id_aset'          => 1767,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '022',
                'nama'             => 'FOLDING CONTAINER BOX',
            ],
            [
                'id_aset'          => 1768,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '023',
                'nama'             => 'BOX TRUCK',
            ],
            [
                'id_aset'          => 1769,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '024',
                'nama'             => 'LACI BOX',
            ],
            [
                'id_aset'          => 1770,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '025',
                'nama'             => 'LEMARI KATALOG',
            ],
            [
                'id_aset'          => 1771,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENYIMPAN PERLENGKAPAN KANTOR LAINNYA',
            ],
            [
                'id_aset'          => 1772,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KANTOR LAINNYA',
            ],
            [
                'id_aset'          => 1773,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TABUNG PEMADAM API',
            ],
            [
                'id_aset'          => 1774,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'HYDRANT',
            ],
            [
                'id_aset'          => 1775,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'SPRINKLER',
            ],
            [
                'id_aset'          => 1776,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'FIRE ALARM',
            ],
            [
                'id_aset'          => 1777,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'RAMBU-RAMBU',
            ],
            [
                'id_aset'          => 1778,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'NARKOTIK TEST',
            ],
            [
                'id_aset'          => 1779,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'CCTV - CAMERA CONTROL TELEVISION SYSTEM',
            ],
            [
                'id_aset'          => 1780,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PAPAN VISUAL/PAPAN NAMA',
            ],
            [
                'id_aset'          => 1781,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MOVITEX BOARD',
            ],
            [
                'id_aset'          => 1782,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '010',
                'nama'             => 'WHITE BOARD',
            ],
            [
                'id_aset'          => 1783,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '011',
                'nama'             => 'ALAT DETEKTOR UANG PALSU',
            ],
            [
                'id_aset'          => 1784,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '012',
                'nama'             => 'ALAT DETEKTOR BARANG TERLARANG/X RAY',
            ],
            [
                'id_aset'          => 1785,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '013',
                'nama'             => 'COPY BOARD/ELEKTRIC WHITE BOARD',
            ],
            [
                'id_aset'          => 1786,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '014',
                'nama'             => 'PETA',
            ],
            [
                'id_aset'          => 1787,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '015',
                'nama'             => 'ALAT PENGHANCUR KERTAS',
            ],
            [
                'id_aset'          => 1788,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '016',
                'nama'             => 'GLOBE',
            ],
            [
                'id_aset'          => 1789,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '017',
                'nama'             => 'MESIN ABSENSI',
            ],
            [
                'id_aset'          => 1790,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '018',
                'nama'             => 'DRY SEAL',
            ],
            [
                'id_aset'          => 1791,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '019',
                'nama'             => 'FERGULATOR',
            ],
            [
                'id_aset'          => 1792,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '020',
                'nama'             => 'CREAM POLISHER',
            ],
            [
                'id_aset'          => 1793,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '021',
                'nama'             => 'MESIN PERANGKO',
            ],
            [
                'id_aset'          => 1794,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '022',
                'nama'             => 'CHECK WRITER',
            ],
            [
                'id_aset'          => 1795,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '023',
                'nama'             => 'NUMERATOR',
            ],
            [
                'id_aset'          => 1796,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '024',
                'nama'             => 'ALAT PEMOTONG KERTAS',
            ],
            [
                'id_aset'          => 1797,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '025',
                'nama'             => 'HEADMACHINE BESAR',
            ],
            [
                'id_aset'          => 1798,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '026',
                'nama'             => 'PERFORATOR BESAR',
            ],
            [
                'id_aset'          => 1799,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '027',
                'nama'             => 'ALAT PENCETAK LABEL',
            ],
            [
                'id_aset'          => 1800,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '028',
                'nama'             => 'OVERHEAD PROJECTOR',
            ],
            [
                'id_aset'          => 1801,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '029',
                'nama'             => 'HAND METAL DETECTOR',
            ],
            [
                'id_aset'          => 1802,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '030',
                'nama'             => 'WALKMAN DETECTOR',
            ],
            [
                'id_aset'          => 1803,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '031',
                'nama'             => 'PANEL PAMERAN',
            ],
            [
                'id_aset'          => 1804,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '032',
                'nama'             => 'ALAT PENGAMAN / SINYAL',
            ],
            [
                'id_aset'          => 1805,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '033',
                'nama'             => 'BOARD MODULUX',
            ],
            [
                'id_aset'          => 1806,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '034',
                'nama'             => 'PORTO SAFE TRAVEL COSE',
            ],
            [
                'id_aset'          => 1807,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '035',
                'nama'             => 'DISK PRIME',
            ],
            [
                'id_aset'          => 1808,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '036',
                'nama'             => 'MEGASHOW',
            ],
            [
                'id_aset'          => 1809,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '037',
                'nama'             => 'WHITE BOARD ELECTRONIC',
            ],
            [
                'id_aset'          => 1810,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '038',
                'nama'             => 'LASER POINTER',
            ],
            [
                'id_aset'          => 1811,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '039',
                'nama'             => 'DISPLAY',
            ],
            [
                'id_aset'          => 1812,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '040',
                'nama'             => 'EXHAUSTER FORM',
            ],
            [
                'id_aset'          => 1813,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '041',
                'nama'             => 'RUBU MUJAYYAB',
            ],
            [
                'id_aset'          => 1814,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '042',
                'nama'             => 'ELECTRIC DUMPER',
            ],
            [
                'id_aset'          => 1815,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '043',
                'nama'             => 'MESIN TERAAN',
            ],
            [
                'id_aset'          => 1816,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '044',
                'nama'             => 'MESIN LAMINATING',
            ],
            [
                'id_aset'          => 1817,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '045',
                'nama'             => 'PENANGKAL PETIR',
            ],
            [
                'id_aset'          => 1818,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '046',
                'nama'             => 'STEMPEL TIMBUL/BULAT',
            ],
            [
                'id_aset'          => 1819,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '047',
                'nama'             => 'LAMPU-LAMPU KRISTAL',
            ],
            [
                'id_aset'          => 1820,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '048',
                'nama'             => 'LCD PROJECTOR/INFOCUS',
            ],
            [
                'id_aset'          => 1821,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '049',
                'nama'             => 'FLIP CHART',
            ],
            [
                'id_aset'          => 1822,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '050',
                'nama'             => 'BINDING MACHINE',
            ],
            [
                'id_aset'          => 1823,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '051',
                'nama'             => 'SOFTBOARD',
            ],
            [
                'id_aset'          => 1824,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '052',
                'nama'             => 'ALAT PEREKAM SUARA (VOICE PEN)',
            ],
            [
                'id_aset'          => 1825,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '053',
                'nama'             => 'ACCES CONTROL SYSTEM',
            ],
            [
                'id_aset'          => 1826,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '054',
                'nama'             => 'INTRUCTION DETECTOR',
            ],
            [
                'id_aset'          => 1827,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '055',
                'nama'             => 'MONITOR PANEL WITH MIMIC BOARD',
            ],
            [
                'id_aset'          => 1828,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '056',
                'nama'             => 'PANIC BUTTON SYSTEM',
            ],
            [
                'id_aset'          => 1829,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '057',
                'nama'             => 'PINTU ELEKTRIK (YANG MEMAKAI AKSES)',
            ],
            [
                'id_aset'          => 1830,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '058',
                'nama'             => 'FOCUSING SCREEN/LAYAR LCD PROJECTOR',
            ],
            [
                'id_aset'          => 1831,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '059',
                'nama'             => 'ALAT DETEKTOR BARANG TERLARANG',
            ],
            [
                'id_aset'          => 1832,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '060',
                'nama'             => 'PROYECTOR SPIDER BRACKET',
            ],
            [
                'id_aset'          => 1833,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '061',
                'nama'             => 'PAPAN GAMBAR',
            ],
            [
                'id_aset'          => 1834,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '062',
                'nama'             => 'BEL',
            ],
            [
                'id_aset'          => 1835,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '063',
                'nama'             => 'ELECTRIC PRESSING MACHINE',
            ],
            [
                'id_aset'          => 1836,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '064',
                'nama'             => 'ENCAPSULATOR (JARASONIC WELDER)',
            ],
            [
                'id_aset'          => 1837,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '065',
                'nama'             => 'DEACIDIFICATOR UNIT (NON AQUAS)',
            ],
            [
                'id_aset'          => 1838,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '066',
                'nama'             => 'FULL AUTOMATIC LEAF CASTER',
            ],
            [
                'id_aset'          => 1839,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '067',
                'nama'             => 'CONSERVATION TOOLS',
            ],
            [
                'id_aset'          => 1840,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '068',
                'nama'             => 'BOARD STAN',
            ],
            [
                'id_aset'          => 1841,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '069',
                'nama'             => 'VACUM FREEZE DRY CHAMBER',
            ],
            [
                'id_aset'          => 1842,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '070',
                'nama'             => 'KOTAK SURAT',
            ],
            [
                'id_aset'          => 1843,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '071',
                'nama'             => 'GEMBOK',
            ],
            [
                'id_aset'          => 1844,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '072',
                'nama'             => 'COMPACT HAND PROJECTOR',
            ],
            [
                'id_aset'          => 1845,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '073',
                'nama'             => 'ALAT SIDIK JARI',
            ],
            [
                'id_aset'          => 1846,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '074',
                'nama'             => 'ALAT PENGHANCUR JARUM',
            ],
            [
                'id_aset'          => 1847,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '075',
                'nama'             => 'WALKTHROUGH/ PORTAL METAL DETECTOR',
            ],
            [
                'id_aset'          => 1848,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '076',
                'nama'             => 'HANDHELD TRACE DETECTOR',
            ],
            [
                'id_aset'          => 1849,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '077',
                'nama'             => 'ALAT DETEKSI PITA CUKAI PALSU/ VIDEO SPECTRAL COMPARATOR',
            ],
            [
                'id_aset'          => 1850,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '078',
                'nama'             => 'MESIN PACKING/ STARPPING MACHINE',
            ],
            [
                'id_aset'          => 1851,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '079',
                'nama'             => 'TELEVISION CONTROL OPERASIONAL LIFT',
            ],
            [
                'id_aset'          => 1852,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '080',
                'nama'             => 'MESIN ANTRIAN',
            ],
            [
                'id_aset'          => 1853,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '081',
                'nama'             => 'PAPAN PENGUMUMAN',
            ],
            [
                'id_aset'          => 1854,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '082',
                'nama'             => 'MESIN FOGGING',
            ],
            [
                'id_aset'          => 1855,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '083',
                'nama'             => 'TERALIS',
            ],
            [
                'id_aset'          => 1856,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERKAKAS KANTOR LAINNYA',
            ],
            [
                'id_aset'          => 1857,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KANTOR LAINNYA',
            ],
            [
                'id_aset'          => 1858,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KANTOR LAINNYA',
            ],
            [
                'id_aset'          => 1859,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT RUMAH TANGGA',
            ],
            [
                'id_aset'          => 1860,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'MEUBELAIR',
            ],
            [
                'id_aset'          => 1861,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MEJA KERJA BESI/METAL',
            ],
            [
                'id_aset'          => 1862,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MEJA KERJA KAYU',
            ],
            [
                'id_aset'          => 1863,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KURSI BESI/METAL',
            ],
            [
                'id_aset'          => 1864,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'KURSI KAYU',
            ],
            [
                'id_aset'          => 1865,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'SICE',
            ],
            [
                'id_aset'          => 1866,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'BANGKU PANJANG BESI/METAL',
            ],
            [
                'id_aset'          => 1867,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'BANGKU PANJANG KAYU',
            ],
            [
                'id_aset'          => 1868,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MEJA RAPAT',
            ],
            [
                'id_aset'          => 1869,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MEJA KOMPUTER',
            ],
            [
                'id_aset'          => 1870,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TEMPAT TIDUR BESI',
            ],
            [
                'id_aset'          => 1871,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TEMPAT TIDUR KAYU',
            ],
            [
                'id_aset'          => 1872,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '012',
                'nama'             => 'MEJA KETIK',
            ],
            [
                'id_aset'          => 1873,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '013',
                'nama'             => 'MEJA TELEPON',
            ],
            [
                'id_aset'          => 1874,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '014',
                'nama'             => 'MEJA RESEPSIONIS',
            ],
            [
                'id_aset'          => 1875,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '015',
                'nama'             => 'MEJA MARMER',
            ],
            [
                'id_aset'          => 1876,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '016',
                'nama'             => 'KASUR/SPRING BED',
            ],
            [
                'id_aset'          => 1877,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '017',
                'nama'             => 'SKETSEL',
            ],
            [
                'id_aset'          => 1878,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '018',
                'nama'             => 'MEJA MAKAN BESI',
            ],
            [
                'id_aset'          => 1879,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '019',
                'nama'             => 'MEJA MAKAN KAYU',
            ],
            [
                'id_aset'          => 1880,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '020',
                'nama'             => 'KURSI FIBER GLAS/PLASTIK',
            ],
            [
                'id_aset'          => 1881,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '021',
                'nama'             => 'POT BUNGA',
            ],
            [
                'id_aset'          => 1882,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '022',
                'nama'             => 'PARTISI',
            ],
            [
                'id_aset'          => 1883,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '023',
                'nama'             => 'PUBLIK ASTARI (PEMBATAS ANTRIAN)',
            ],
            [
                'id_aset'          => 1884,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '024',
                'nama'             => 'RAK SEPATU ( ALMUNIUM )',
            ],
            [
                'id_aset'          => 1885,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '025',
                'nama'             => 'GANTUNGAN JAS',
            ],
            [
                'id_aset'          => 1886,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '026',
                'nama'             => 'NAKAS',
            ],
            [
                'id_aset'          => 1887,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '027',
                'nama'             => 'CUBIKAL',
            ],
            [
                'id_aset'          => 1888,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '028',
                'nama'             => 'WORKSTATION',
            ],
            [
                'id_aset'          => 1889,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'MEUBELAIR LAINNYA',
            ],
            [
                'id_aset'          => 1890,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENGUKUR WAKTU',
            ],
            [
                'id_aset'          => 1891,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'JAM MEKANIS',
            ],
            [
                'id_aset'          => 1892,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'JAM LISTRIK',
            ],
            [
                'id_aset'          => 1893,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'JAM ELEKTRONIK',
            ],
            [
                'id_aset'          => 1894,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'CONTROL CLOCK',
            ],
            [
                'id_aset'          => 1895,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENGUKUR WAKTU LAINNYA',
            ],
            [
                'id_aset'          => 1896,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PEMBERSIH',
            ],
            [
                'id_aset'          => 1897,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MESIN PENGHISAP DEBU/VACUUM CLEANER',
            ],
            [
                'id_aset'          => 1898,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MESIN PEL/POLES',
            ],
            [
                'id_aset'          => 1899,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN PEMOTONG RUMPUT',
            ],
            [
                'id_aset'          => 1900,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN CUCI',
            ],
            [
                'id_aset'          => 1901,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'AIR CLEANER',
            ],
            [
                'id_aset'          => 1902,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'ALAT PEMBERSIH SALJU',
            ],
            [
                'id_aset'          => 1903,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PEMBERSIH LAINNYA',
            ],
            [
                'id_aset'          => 1904,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT PENDINGIN',
            ],
            [
                'id_aset'          => 1905,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'LEMARI ES',
            ],
            [
                'id_aset'          => 1906,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'A.C. SENTRAL',
            ],
            [
                'id_aset'          => 1907,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'A.C. WINDOW',
            ],
            [
                'id_aset'          => 1908,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'A.C. SPLIT',
            ],
            [
                'id_aset'          => 1909,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PORTABLE AIR CONDITIONER (ALAT PENDINGIN)',
            ],
            [
                'id_aset'          => 1910,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '006',
                'nama'             => 'KIPAS ANGIN',
            ],
            [
                'id_aset'          => 1911,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '007',
                'nama'             => 'EXHAUSE FAN',
            ],
            [
                'id_aset'          => 1912,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '008',
                'nama'             => 'COLD STORAGE (ALAT PENDINGIN)',
            ],
            [
                'id_aset'          => 1913,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '009',
                'nama'             => 'REACH IN FREZZER',
            ],
            [
                'id_aset'          => 1914,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '010',
                'nama'             => 'REACH IN CHILLER',
            ],
            [
                'id_aset'          => 1915,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '011',
                'nama'             => 'UP RIGHT CHILLER/FREZZER',
            ],
            [
                'id_aset'          => 1916,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '012',
                'nama'             => 'COLD ROOM FREZZER',
            ],
            [
                'id_aset'          => 1917,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '013',
                'nama'             => 'AIR CURTAIN',
            ],
            [
                'id_aset'          => 1918,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '014',
                'nama'             => 'AIR HANDLING UNIT',
            ],
            [
                'id_aset'          => 1919,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT PENDINGIN LAINNYA',
            ],
            [
                'id_aset'          => 1920,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT DAPUR',
            ],
            [
                'id_aset'          => 1921,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'KOMPOR LISTRIK (ALAT DAPUR)',
            ],
            [
                'id_aset'          => 1922,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'KOMPOR GAS (ALAT DAPUR)',
            ],
            [
                'id_aset'          => 1923,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'KOMPOR MINYAK',
            ],
            [
                'id_aset'          => 1924,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TEKO LISTRIK',
            ],
            [
                'id_aset'          => 1925,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'RICE COOKER (ALAT DAPUR)',
            ],
            [
                'id_aset'          => 1926,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'OVEN LISTRIK',
            ],
            [
                'id_aset'          => 1927,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'RICE WARMER',
            ],
            [
                'id_aset'          => 1928,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'KITCHEN SET',
            ],
            [
                'id_aset'          => 1929,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TABUNG GAS',
            ],
            [
                'id_aset'          => 1930,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MESIN GILING BUMBU',
            ],
            [
                'id_aset'          => 1931,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '011',
                'nama'             => 'TRENG AIR/TANDON AIR',
            ],
            [
                'id_aset'          => 1932,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '012',
                'nama'             => 'MESIN PARUTAN KELAPA',
            ],
            [
                'id_aset'          => 1933,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '013',
                'nama'             => 'KOMPOR KOMPRESOR',
            ],
            [
                'id_aset'          => 1934,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '014',
                'nama'             => 'ALAT PEMANGGANG ROTI/SATE',
            ],
            [
                'id_aset'          => 1935,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '015',
                'nama'             => 'RAK PIRING ALUMUNIUM',
            ],
            [
                'id_aset'          => 1936,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '016',
                'nama'             => 'ALAT PENYIMPAN BERAS',
            ],
            [
                'id_aset'          => 1937,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '017',
                'nama'             => 'PANCI',
            ],
            [
                'id_aset'          => 1938,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '018',
                'nama'             => 'BLENDER',
            ],
            [
                'id_aset'          => 1939,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '019',
                'nama'             => 'MIXER',
            ],
            [
                'id_aset'          => 1940,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '020',
                'nama'             => 'OVEN GAS',
            ],
            [
                'id_aset'          => 1941,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '021',
                'nama'             => 'PRESTO COOKER',
            ],
            [
                'id_aset'          => 1942,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '022',
                'nama'             => 'WONDER PAN',
            ],
            [
                'id_aset'          => 1943,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '023',
                'nama'             => 'MESIN GILING DAGING',
            ],
            [
                'id_aset'          => 1944,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '024',
                'nama'             => 'HEATING SET',
            ],
            [
                'id_aset'          => 1945,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '025',
                'nama'             => 'THERMOS AIR',
            ],
            [
                'id_aset'          => 1946,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT DAPUR LAINNYA',
            ],
            [
                'id_aset'          => 1947,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT RUMAH TANGGA LAINNYA ( HOME USE )',
            ],
            [
                'id_aset'          => 1948,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'RADIO',
            ],
            [
                'id_aset'          => 1949,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TELEVISI',
            ],
            [
                'id_aset'          => 1950,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'VIDEO CASSETTE',
            ],
            [
                'id_aset'          => 1951,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TAPE RECORDER (ALAT RUMAH TANGGA LAINNYA ( HOME USE ))',
            ],
            [
                'id_aset'          => 1952,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '005',
                'nama'             => 'AMPLIFIER',
            ],
            [
                'id_aset'          => 1953,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '006',
                'nama'             => 'EQUALIZER',
            ],
            [
                'id_aset'          => 1954,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '007',
                'nama'             => 'LOUDSPEAKER',
            ],
            [
                'id_aset'          => 1955,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '008',
                'nama'             => 'SOUND SYSTEM',
            ],
            [
                'id_aset'          => 1956,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '009',
                'nama'             => 'COMPACT DISC',
            ],
            [
                'id_aset'          => 1957,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '010',
                'nama'             => 'LASER DISC',
            ],
            [
                'id_aset'          => 1958,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '011',
                'nama'             => 'KARAOKE',
            ],
            [
                'id_aset'          => 1959,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '012',
                'nama'             => 'WIRELESS',
            ],
            [
                'id_aset'          => 1960,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '013',
                'nama'             => 'MEGAPHONE',
            ],
            [
                'id_aset'          => 1961,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '014',
                'nama'             => 'MICROPHONE',
            ],
            [
                'id_aset'          => 1962,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '015',
                'nama'             => 'MICROPHONE TABLE STAND',
            ],
            [
                'id_aset'          => 1963,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '016',
                'nama'             => 'MIC CONFERENCE',
            ],
            [
                'id_aset'          => 1964,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '017',
                'nama'             => 'UNIT POWER SUPPLY',
            ],
            [
                'id_aset'          => 1965,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '018',
                'nama'             => 'STEP UP/DOWN (ALAT RUMAH TANGGA LAINNYA ( HOME USE ))',
            ],
            [
                'id_aset'          => 1966,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '019',
                'nama'             => 'STABILISATOR',
            ],
            [
                'id_aset'          => 1967,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '020',
                'nama'             => 'CAMERA VIDEO',
            ],
            [
                'id_aset'          => 1968,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '021',
                'nama'             => 'TUSTEL',
            ],
            [
                'id_aset'          => 1969,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '022',
                'nama'             => 'MESIN JAHIT',
            ],
            [
                'id_aset'          => 1970,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '023',
                'nama'             => 'TIMBANGAN ORANG',
            ],
            [
                'id_aset'          => 1971,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '024',
                'nama'             => 'TIMBANGAN BARANG',
            ],
            [
                'id_aset'          => 1972,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '025',
                'nama'             => 'ALAT HIASAN',
            ],
            [
                'id_aset'          => 1973,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '026',
                'nama'             => 'LAMBANG GARUDA PANCASILA',
            ],
            [
                'id_aset'          => 1974,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '027',
                'nama'             => 'GAMBAR PRESIDEN/WAKIL PRESIDEN',
            ],
            [
                'id_aset'          => 1975,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '028',
                'nama'             => 'LAMBANG KORPRI/DHARMA WANITA',
            ],
            [
                'id_aset'          => 1976,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '029',
                'nama'             => 'AQUARIUM (ALAT RUMAH TANGGA LAINNYA ( HOME USE ))',
            ],
            [
                'id_aset'          => 1977,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '030',
                'nama'             => 'TIANG BENDERA',
            ],
            [
                'id_aset'          => 1978,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '031',
                'nama'             => 'PATAKA',
            ],
            [
                'id_aset'          => 1979,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '032',
                'nama'             => 'SETERIKA',
            ],
            [
                'id_aset'          => 1980,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '033',
                'nama'             => 'WATER FILTER',
            ],
            [
                'id_aset'          => 1981,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '034',
                'nama'             => 'TANGGA ALUMINIUM',
            ],
            [
                'id_aset'          => 1982,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '035',
                'nama'             => 'KACA HIAS',
            ],
            [
                'id_aset'          => 1983,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '036',
                'nama'             => 'DISPENSER',
            ],
            [
                'id_aset'          => 1984,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '037',
                'nama'             => 'MIMBAR/PODIUM',
            ],
            [
                'id_aset'          => 1985,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '038',
                'nama'             => 'GUCCI',
            ],
            [
                'id_aset'          => 1986,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '039',
                'nama'             => 'TANGGA HIDROLIK',
            ],
            [
                'id_aset'          => 1987,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '040',
                'nama'             => 'PALU SIDANG',
            ],
            [
                'id_aset'          => 1988,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '041',
                'nama'             => 'MESIN PENGERING PAKAIAN',
            ],
            [
                'id_aset'          => 1989,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '042',
                'nama'             => 'LAMBANG INSTANSI',
            ],
            [
                'id_aset'          => 1990,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '043',
                'nama'             => 'LONCENG/GENTA',
            ],
            [
                'id_aset'          => 1991,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '044',
                'nama'             => 'MESIN PEMOTONG KERAMIK',
            ],
            [
                'id_aset'          => 1992,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '045',
                'nama'             => 'COFFEE MAKER',
            ],
            [
                'id_aset'          => 1993,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '046',
                'nama'             => 'HANDY CAM',
            ],
            [
                'id_aset'          => 1994,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '047',
                'nama'             => 'MESIN OBRAS',
            ],
            [
                'id_aset'          => 1995,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '048',
                'nama'             => 'MESIN POTONG KAIN',
            ],
            [
                'id_aset'          => 1996,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '049',
                'nama'             => 'MESIN PELUBANG KANCING',
            ],
            [
                'id_aset'          => 1997,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '050',
                'nama'             => 'MEJA POTONG',
            ],
            [
                'id_aset'          => 1998,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '051',
                'nama'             => 'RADER',
            ],
            [
                'id_aset'          => 1999,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '052',
                'nama'             => 'MANEQUIN (BONEKA)',
            ],
            [
                'id_aset'          => 2000,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '053',
                'nama'             => 'PINSET (PISAU LOBANG KANCING)',
            ],
            [
                'id_aset'          => 2001,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '054',
                'nama'             => 'MINI COMPO',
            ],
            [
                'id_aset'          => 2002,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '055',
                'nama'             => 'HEATER (ALAT RUMAH TANGGA LAINNYA ( HOME USE ))',
            ],
            [
                'id_aset'          => 2003,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '056',
                'nama'             => 'KARPET',
            ],
            [
                'id_aset'          => 2004,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '057',
                'nama'             => 'VERTIKAL BLIND',
            ],
            [
                'id_aset'          => 2005,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '058',
                'nama'             => 'GORDYIN/KRAY',
            ],
            [
                'id_aset'          => 2006,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '059',
                'nama'             => 'KABEL ROLL',
            ],
            [
                'id_aset'          => 2007,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '060',
                'nama'             => 'ASBAK TINGGI',
            ],
            [
                'id_aset'          => 2008,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '061',
                'nama'             => 'KESET KAKI',
            ],
            [
                'id_aset'          => 2009,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '062',
                'nama'             => 'SUN SCREEN',
            ],
            [
                'id_aset'          => 2010,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '063',
                'nama'             => 'ALAT PEMANAS RUANGAN',
            ],
            [
                'id_aset'          => 2011,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '064',
                'nama'             => 'LEMARI PLASTIK',
            ],
            [
                'id_aset'          => 2012,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '065',
                'nama'             => 'MESIN PENGERING TANGAN',
            ],
            [
                'id_aset'          => 2013,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '066',
                'nama'             => 'PANGGUNG',
            ],
            [
                'id_aset'          => 2014,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '067',
                'nama'             => 'MESIN PEDDING',
            ],
            [
                'id_aset'          => 2015,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '068',
                'nama'             => 'DVD PLAYER',
            ],
            [
                'id_aset'          => 2016,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '069',
                'nama'             => 'LAMPU BELAJAR',
            ],
            [
                'id_aset'          => 2017,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '070',
                'nama'             => 'TANGGA',
            ],
            [
                'id_aset'          => 2018,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '071',
                'nama'             => 'KABEL',
            ],
            [
                'id_aset'          => 2019,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '072',
                'nama'             => 'LAMPU',
            ],
            [
                'id_aset'          => 2020,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '073',
                'nama'             => 'JEMURAN',
            ],
            [
                'id_aset'          => 2021,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '074',
                'nama'             => 'PATUNG PERAGA PAKAIAN',
            ],
            [
                'id_aset'          => 2022,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '075',
                'nama'             => 'GENDOLA',
            ],
            [
                'id_aset'          => 2023,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '076',
                'nama'             => 'GUNTING RUMPUT NON MESIN',
            ],
            [
                'id_aset'          => 2024,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '077',
                'nama'             => 'BENDERA NEGARA',
            ],
            [
                'id_aset'          => 2025,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '078',
                'nama'             => 'BINGKAI FOTO',
            ],
            [
                'id_aset'          => 2026,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '079',
                'nama'             => 'ALAT PANGKAS RAMBUT LISTRIK',
            ],
            [
                'id_aset'          => 2027,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '080',
                'nama'             => 'BRACKET STANDING PERALATAN',
            ],
            [
                'id_aset'          => 2028,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '081',
                'nama'             => 'TANGKI AIR',
            ],
            [
                'id_aset'          => 2029,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '082',
                'nama'             => 'HOME THEATER',
            ],
            [
                'id_aset'          => 2030,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT RUMAH TANGGA LAINNYA ( HOME USE )',
            ],
            [
                'id_aset'          => 2031,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT RUMAH TANGGA LAINNYA',
            ],
            [
                'id_aset'          => 2032,
                'golongan'         => '3',
                'bidang'           => '05',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT RUMAH TANGGA LAINNYA',
            ],
            [
                'id_aset'          => 2033,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '00',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT STUDIO',
            ],
            [
                'id_aset'          => 2034,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT STUDIO',
            ],
            [
                'id_aset'          => 2035,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN STUDIO AUDIO',
            ],
            [
                'id_aset'          => 2036,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'AUDIO MIXING CONSOLE',
            ],
            [
                'id_aset'          => 2037,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'AUDIO MIXING PORTABLE',
            ],
            [
                'id_aset'          => 2038,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'AUDIO MIXING STATIONER',
            ],
            [
                'id_aset'          => 2039,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'AUDIO ATTENUATOR',
            ],
            [
                'id_aset'          => 2040,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'AUDIO AMPLIFIER',
            ],
            [
                'id_aset'          => 2041,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'AUDIO ERASE UNIT',
            ],
            [
                'id_aset'          => 2042,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'AUDIO VIDEO SELECTOR (PERALATAN STUDIO AUDIO)',
            ],
            [
                'id_aset'          => 2043,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'AUDIO MONITOR ACTIVE',
            ],
            [
                'id_aset'          => 2044,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'AUDIO MONITOR PASSIVE',
            ],
            [
                'id_aset'          => 2045,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'AUDIO REVERBERATION',
            ],
            [
                'id_aset'          => 2046,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'AUDIO PATCH PANEL',
            ],
            [
                'id_aset'          => 2047,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '012',
                'nama'             => 'AUDIO DISTRIBUTION',
            ],
            [
                'id_aset'          => 2048,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '013',
                'nama'             => 'AUDIO TONE GENERATOR',
            ],
            [
                'id_aset'          => 2049,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '014',
                'nama'             => 'AUDIO CATRIDGE RECORDER',
            ],
            [
                'id_aset'          => 2050,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '015',
                'nama'             => 'AUDIO LOGGING RECORDER',
            ],
            [
                'id_aset'          => 2051,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '016',
                'nama'             => 'COMPACT DISC PLAYER',
            ],
            [
                'id_aset'          => 2052,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '017',
                'nama'             => 'CASSETTE DUPLICATOR',
            ],
            [
                'id_aset'          => 2053,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '018',
                'nama'             => 'DISC RECORD PLAYER',
            ],
            [
                'id_aset'          => 2054,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '019',
                'nama'             => 'MULTITRACK RECORDER',
            ],
            [
                'id_aset'          => 2055,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '020',
                'nama'             => 'REEL TAPE DUPLICATOR',
            ],
            [
                'id_aset'          => 2056,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '021',
                'nama'             => 'COMPACT DISC JUKE BOX SYSTEM',
            ],
            [
                'id_aset'          => 2057,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '022',
                'nama'             => 'TELEPHONE HYBRID',
            ],
            [
                'id_aset'          => 2058,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '023',
                'nama'             => 'AUDIO PHONE IN',
            ],
            [
                'id_aset'          => 2059,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '024',
                'nama'             => 'PROFANITY DELAY SYSTEM',
            ],
            [
                'id_aset'          => 2060,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '025',
                'nama'             => 'AUDIO VISUAL',
            ],
            [
                'id_aset'          => 2061,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '026',
                'nama'             => 'AUDIO FILTER',
            ],
            [
                'id_aset'          => 2062,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '027',
                'nama'             => 'AUDIO LIMITER',
            ],
            [
                'id_aset'          => 2063,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '028',
                'nama'             => 'AUDIO COMPRESSOR',
            ],
            [
                'id_aset'          => 2064,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '029',
                'nama'             => 'TURN TABLE',
            ],
            [
                'id_aset'          => 2065,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '030',
                'nama'             => 'TALK BACK UNIT',
            ],
            [
                'id_aset'          => 2066,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '031',
                'nama'             => 'INTERCOM UNIT',
            ],
            [
                'id_aset'          => 2067,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '032',
                'nama'             => 'BUZZER',
            ],
            [
                'id_aset'          => 2068,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '033',
                'nama'             => 'SET STUDIO LIGHT SIGNAL',
            ],
            [
                'id_aset'          => 2069,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '034',
                'nama'             => 'DOLBY NOISE REDUCTION',
            ],
            [
                'id_aset'          => 2070,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '035',
                'nama'             => 'MODULATION MONITOR SPEAKER KABARET',
            ],
            [
                'id_aset'          => 2071,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '036',
                'nama'             => 'MICROPHONE/WIRELESS MIC',
            ],
            [
                'id_aset'          => 2072,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '037',
                'nama'             => 'MICROPHONE/BOOM STAND',
            ],
            [
                'id_aset'          => 2073,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '038',
                'nama'             => 'MICROPHONE CONNECTOR BOX',
            ],
            [
                'id_aset'          => 2074,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '039',
                'nama'             => 'LIGHT SIGNAL',
            ],
            [
                'id_aset'          => 2075,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '040',
                'nama'             => 'POWER SUPPLY MICROPHONE',
            ],
            [
                'id_aset'          => 2076,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '041',
                'nama'             => 'PROFESSIONAL SOUND SYSTEM',
            ],
            [
                'id_aset'          => 2077,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '042',
                'nama'             => 'AUDIO MASTER CONTROL UNIT',
            ],
            [
                'id_aset'          => 2078,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '043',
                'nama'             => 'TIME INDETIFICATION UNIT',
            ],
            [
                'id_aset'          => 2079,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '044',
                'nama'             => 'AUDIO ANNOUNCER DESK',
            ],
            [
                'id_aset'          => 2080,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '045',
                'nama'             => 'MASTER CLOCK (PERALATAN STUDIO AUDIO)',
            ],
            [
                'id_aset'          => 2081,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '046',
                'nama'             => 'SLAVE CLOCK (PERALATAN STUDIO AUDIO)',
            ],
            [
                'id_aset'          => 2082,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '047',
                'nama'             => 'AUDIO COMMAND DESK',
            ],
            [
                'id_aset'          => 2083,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '048',
                'nama'             => 'UNINTERRUPTIBLE POWER SUPPLY (UPS)',
            ],
            [
                'id_aset'          => 2084,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '049',
                'nama'             => 'MASTER CONTROL DESK',
            ],
            [
                'id_aset'          => 2085,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '050',
                'nama'             => 'HEAD COMPENSATOR',
            ],
            [
                'id_aset'          => 2086,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '051',
                'nama'             => 'AUTOMATIC VOLTAGE REGULATOR (AVR)',
            ],
            [
                'id_aset'          => 2087,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '053',
                'nama'             => 'HUM/CABLE CONPENSATOR',
            ],
            [
                'id_aset'          => 2088,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '054',
                'nama'             => 'EDITING & DUBBING SYSTEM',
            ],
            [
                'id_aset'          => 2089,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '055',
                'nama'             => 'ANALOG DELAY (PERALATAN STUDIO AUDIO)',
            ],
            [
                'id_aset'          => 2090,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '056',
                'nama'             => 'BATTERY CHARGER (PERALATAN STUDIO AUDIO)',
            ],
            [
                'id_aset'          => 2091,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '057',
                'nama'             => 'BLANK PANEL',
            ],
            [
                'id_aset'          => 2092,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '058',
                'nama'             => 'CONTROL UNIT HF',
            ],
            [
                'id_aset'          => 2093,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '059',
                'nama'             => 'DELAY UNIT',
            ],
            [
                'id_aset'          => 2094,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '060',
                'nama'             => 'POWER AMPLIFIER',
            ],
            [
                'id_aset'          => 2095,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '061',
                'nama'             => 'PAGING MIC',
            ],
            [
                'id_aset'          => 2096,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '062',
                'nama'             => 'COMPACT MONITOR PANEL FOR STEREO',
            ],
            [
                'id_aset'          => 2097,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '063',
                'nama'             => 'PISTOL GRIP',
            ],
            [
                'id_aset'          => 2098,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '064',
                'nama'             => 'MOUNTING BREAKEN',
            ],
            [
                'id_aset'          => 2099,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '065',
                'nama'             => 'CHAIRMAN/AUDIO CONFERENCE',
            ],
            [
                'id_aset'          => 2100,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '066',
                'nama'             => 'TIME SWITCHING',
            ],
            [
                'id_aset'          => 2101,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '067',
                'nama'             => 'TERMINAL BOARD',
            ],
            [
                'id_aset'          => 2102,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '068',
                'nama'             => 'ENCODER/DECODER',
            ],
            [
                'id_aset'          => 2103,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '069',
                'nama'             => 'WIND SHIELD',
            ],
            [
                'id_aset'          => 2104,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '070',
                'nama'             => 'RECEIVER HF/LF',
            ],
            [
                'id_aset'          => 2105,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '071',
                'nama'             => 'RECEIVER VHF/FM',
            ],
            [
                'id_aset'          => 2106,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '072',
                'nama'             => 'AUDIO TAPE REEL RECORDER',
            ],
            [
                'id_aset'          => 2107,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '073',
                'nama'             => 'AUDIO CASSETTE RECORDER',
            ],
            [
                'id_aset'          => 2108,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '074',
                'nama'             => 'COMPACT DISC RECORDER',
            ],
            [
                'id_aset'          => 2109,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '075',
                'nama'             => 'DIGITAL AUDIO STORAGE SYSTEM',
            ],
            [
                'id_aset'          => 2110,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '076',
                'nama'             => 'DIGITAL AUDIO TAPERECORDER',
            ],
            [
                'id_aset'          => 2111,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '077',
                'nama'             => 'BLITZZER',
            ],
            [
                'id_aset'          => 2112,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '078',
                'nama'             => 'AUDIO MAXIMIZER',
            ],
            [
                'id_aset'          => 2113,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '079',
                'nama'             => 'MICROPHONE CABLE',
            ],
            [
                'id_aset'          => 2114,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '080',
                'nama'             => 'SIGNAL INSTRUMENT SWITCER',
            ],
            [
                'id_aset'          => 2115,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '081',
                'nama'             => 'CELLING MOUNT BRACKET',
            ],
            [
                'id_aset'          => 2116,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '082',
                'nama'             => 'INTERFACEBOARD',
            ],
            [
                'id_aset'          => 2117,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '083',
                'nama'             => 'VIDEO PRESENTER',
            ],
            [
                'id_aset'          => 2118,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '084',
                'nama'             => 'MULTISCAN PROYECTOR',
            ],
            [
                'id_aset'          => 2119,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '085',
                'nama'             => 'CABLE',
            ],
            [
                'id_aset'          => 2120,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '086',
                'nama'             => 'SCANNER COIR',
            ],
            [
                'id_aset'          => 2121,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '087',
                'nama'             => 'KOMP. INTERFACE BOAR',
            ],
            [
                'id_aset'          => 2122,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '088',
                'nama'             => 'VOICE RECORDER',
            ],
            [
                'id_aset'          => 2123,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '089',
                'nama'             => 'AM/FM MEASUREMENT',
            ],
            [
                'id_aset'          => 2124,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '090',
                'nama'             => 'SIGNAL ON AIR',
            ],
            [
                'id_aset'          => 2125,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '091',
                'nama'             => 'DIGITAL LED RUNNING TEXT',
            ],
            [
                'id_aset'          => 2126,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '092',
                'nama'             => 'ANALOG/DIGITAL RECEIVER',
            ],
            [
                'id_aset'          => 2127,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '093',
                'nama'             => 'DIGITAL KEYBOARD TECHNICS',
            ],
            [
                'id_aset'          => 2128,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '094',
                'nama'             => 'EXPLORIST 600',
            ],
            [
                'id_aset'          => 2129,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN STUDIO AUDIO LAINNYA',
            ],
            [
                'id_aset'          => 2130,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN STUDIO VIDEO DAN FILM',
            ],
            [
                'id_aset'          => 2131,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ASSIGNMENT SWITCHER',
            ],
            [
                'id_aset'          => 2132,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'OFF AIR TV MONITOR',
            ],
            [
                'id_aset'          => 2133,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'CAMERA ELECTRONIC',
            ],
            [
                'id_aset'          => 2134,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PULSE GENERATOR (PERALATAN STUDIO VIDEO DAN FILM)',
            ],
            [
                'id_aset'          => 2135,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PULSE DISTRIBUTION AMPLIFIER',
            ],
            [
                'id_aset'          => 2136,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PULSE SWITCHER',
            ],
            [
                'id_aset'          => 2137,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PULSE DELAY LINE',
            ],
            [
                'id_aset'          => 2138,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '008',
                'nama'             => 'CHARACTER GENERATOR (PERALATAN STUDIO VIDEO DAN FILM)',
            ],
            [
                'id_aset'          => 2139,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '009',
                'nama'             => 'CAPTION GENERATOR',
            ],
            [
                'id_aset'          => 2140,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '010',
                'nama'             => 'TELECINE',
            ],
            [
                'id_aset'          => 2141,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '011',
                'nama'             => 'VIDEO DISTRIBUTION AMPLIFIER',
            ],
            [
                'id_aset'          => 2142,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '012',
                'nama'             => 'VIDEO MONITOR',
            ],
            [
                'id_aset'          => 2143,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '013',
                'nama'             => 'VIDEO TAPE RECORDER PORTABLE',
            ],
            [
                'id_aset'          => 2144,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '014',
                'nama'             => 'VIDEO TAPE RECORDER STATIONER',
            ],
            [
                'id_aset'          => 2145,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '015',
                'nama'             => 'VIDEO MIXER',
            ],
            [
                'id_aset'          => 2146,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '016',
                'nama'             => 'VIDEO SWITCHER',
            ],
            [
                'id_aset'          => 2147,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '017',
                'nama'             => 'VIDEO EQUALIZER AMPLIFIER',
            ],
            [
                'id_aset'          => 2148,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '018',
                'nama'             => 'VIDEO COLOR BAR GENERATOR',
            ],
            [
                'id_aset'          => 2149,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '019',
                'nama'             => 'VIDEO CROSS BAR SWITCH',
            ],
            [
                'id_aset'          => 2150,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '020',
                'nama'             => 'VIDEO TEST SIGNAL GENERATOR',
            ],
            [
                'id_aset'          => 2151,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '021',
                'nama'             => 'VIDEO CORRECTOR',
            ],
            [
                'id_aset'          => 2152,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '022',
                'nama'             => 'VIDEO CAPTION ADDER',
            ],
            [
                'id_aset'          => 2153,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '023',
                'nama'             => 'VIDEO HUM COMPENSATOR',
            ],
            [
                'id_aset'          => 2154,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '024',
                'nama'             => 'VIDEO PROCESSOR',
            ],
            [
                'id_aset'          => 2155,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '025',
                'nama'             => 'VIDEO STATION ID GENERATOR',
            ],
            [
                'id_aset'          => 2156,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '026',
                'nama'             => 'VIDEO PATCH PANEL',
            ],
            [
                'id_aset'          => 2157,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '027',
                'nama'             => 'VIDEO DELAY UNIT',
            ],
            [
                'id_aset'          => 2158,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '028',
                'nama'             => 'VIDEO PROCESSING AMPLIFIER',
            ],
            [
                'id_aset'          => 2159,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '029',
                'nama'             => 'VIDEO EQUALIZER',
            ],
            [
                'id_aset'          => 2160,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '030',
                'nama'             => 'VIDEO TAPE EVALUATOR',
            ],
            [
                'id_aset'          => 2161,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '031',
                'nama'             => 'VIDEO EFFECT GENERATOR',
            ],
            [
                'id_aset'          => 2162,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '032',
                'nama'             => 'VITS INSERTER GENERATOR',
            ],
            [
                'id_aset'          => 2163,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '033',
                'nama'             => 'CAMERA WALL BOX',
            ],
            [
                'id_aset'          => 2164,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '034',
                'nama'             => 'TELEPROMPTER',
            ],
            [
                'id_aset'          => 2165,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '035',
                'nama'             => 'TIME BASE CORRECTOR',
            ],
            [
                'id_aset'          => 2166,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '036',
                'nama'             => 'GUN SMOKE',
            ],
            [
                'id_aset'          => 2167,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '037',
                'nama'             => 'AUTOMATIC EDITING CONTROL (PERALATAN STUDIO VIDEO DAN FILM)',
            ],
            [
                'id_aset'          => 2168,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '038',
                'nama'             => 'POWER SUPPLY (PERALATAN STUDIO VIDEO DAN FILM)',
            ],
            [
                'id_aset'          => 2169,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '039',
                'nama'             => 'EDITING ELECTRONIC',
            ],
            [
                'id_aset'          => 2170,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '040',
                'nama'             => 'RECTIFIER UNIT',
            ],
            [
                'id_aset'          => 2171,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '041',
                'nama'             => 'REMOTE CONTROL UNIT',
            ],
            [
                'id_aset'          => 2172,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '042',
                'nama'             => 'RAK PERALATAN',
            ],
            [
                'id_aset'          => 2173,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '043',
                'nama'             => 'STABILIZING AMPLIFIER',
            ],
            [
                'id_aset'          => 2174,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '044',
                'nama'             => 'DIGITAL VIDEO EFFECT',
            ],
            [
                'id_aset'          => 2175,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '045',
                'nama'             => 'TRIPOD CAMERA',
            ],
            [
                'id_aset'          => 2176,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '046',
                'nama'             => 'DIMMER',
            ],
            [
                'id_aset'          => 2177,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '047',
                'nama'             => 'CHILLER',
            ],
            [
                'id_aset'          => 2178,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '048',
                'nama'             => 'SLAVE CLOCK (PERALATAN STUDIO VIDEO DAN FILM)',
            ],
            [
                'id_aset'          => 2179,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '049',
                'nama'             => 'MASTER CLOCK (PERALATAN STUDIO VIDEO DAN FILM)',
            ],
            [
                'id_aset'          => 2180,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '050',
                'nama'             => 'TELEDYNE',
            ],
            [
                'id_aset'          => 2181,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '051',
                'nama'             => 'FLYING SPOT SCANNER',
            ],
            [
                'id_aset'          => 2182,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '052',
                'nama'             => 'SYNCHRONIZING PULSE GENERATOR',
            ],
            [
                'id_aset'          => 2183,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '053',
                'nama'             => 'DC CONVERTER',
            ],
            [
                'id_aset'          => 2184,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '054',
                'nama'             => 'BLACK BURST GENERATOR',
            ],
            [
                'id_aset'          => 2185,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '055',
                'nama'             => 'LIGHTING STAND TRIPOD',
            ],
            [
                'id_aset'          => 2186,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '056',
                'nama'             => 'FILM PROJECTOR',
            ],
            [
                'id_aset'          => 2187,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '057',
                'nama'             => 'SLIDE PROJECTOR',
            ],
            [
                'id_aset'          => 2188,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '058',
                'nama'             => 'COMMAND DESK',
            ],
            [
                'id_aset'          => 2189,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '059',
                'nama'             => 'ANNOUNCER DESK',
            ],
            [
                'id_aset'          => 2190,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '060',
                'nama'             => 'CAMERA FILM',
            ],
            [
                'id_aset'          => 2191,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '061',
                'nama'             => 'LENSA KAMERA',
            ],
            [
                'id_aset'          => 2192,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '062',
                'nama'             => 'FILM MAGAZINE',
            ],
            [
                'id_aset'          => 2193,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '063',
                'nama'             => 'CLAPER',
            ],
            [
                'id_aset'          => 2194,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '064',
                'nama'             => 'CHANGING BAG',
            ],
            [
                'id_aset'          => 2195,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '065',
                'nama'             => 'CONDITIONER',
            ],
            [
                'id_aset'          => 2196,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '066',
                'nama'             => 'COLOUR FILM ANALYZER',
            ],
            [
                'id_aset'          => 2197,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '068',
                'nama'             => 'FILM SOUND RECORDER',
            ],
            [
                'id_aset'          => 2198,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '069',
                'nama'             => 'TELE RECORDER',
            ],
            [
                'id_aset'          => 2199,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '070',
                'nama'             => 'CAMERA VIEW FINDER',
            ],
            [
                'id_aset'          => 2200,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '071',
                'nama'             => 'SERVO ZOOM LENS',
            ],
            [
                'id_aset'          => 2201,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '072',
                'nama'             => 'CAMERA ADAPTOR',
            ],
            [
                'id_aset'          => 2202,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '073',
                'nama'             => 'PHOTO PROCESSING SET',
            ],
            [
                'id_aset'          => 2203,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '074',
                'nama'             => 'MICRO FILM',
            ],
            [
                'id_aset'          => 2204,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '075',
                'nama'             => 'MIXER PVC',
            ],
            [
                'id_aset'          => 2205,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '076',
                'nama'             => 'UNIT REPLENIESER TANK',
            ],
            [
                'id_aset'          => 2206,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '077',
                'nama'             => 'HORIZONTAL MOTORIZED FILM REWINDER',
            ],
            [
                'id_aset'          => 2207,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '078',
                'nama'             => 'VERTICAL MOTORIZED FILM REWINDER',
            ],
            [
                'id_aset'          => 2208,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '079',
                'nama'             => 'MANUAL FILM REWINDER',
            ],
            [
                'id_aset'          => 2209,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '080',
                'nama'             => 'MESIN PROSESING FILM NEGATIF',
            ],
            [
                'id_aset'          => 2210,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '081',
                'nama'             => 'MESIN PROSESING FILM POSITIF',
            ],
            [
                'id_aset'          => 2211,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '082',
                'nama'             => 'MESIN PROSESING FILM WARNA NEGATIF (ECN)',
            ],
            [
                'id_aset'          => 2212,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '083',
                'nama'             => 'MESIN PROSESING FILM WARNA POSITIF (ECP)',
            ],
            [
                'id_aset'          => 2213,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '084',
                'nama'             => 'MESIN FILM COLOR ANALYZER',
            ],
            [
                'id_aset'          => 2214,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '085',
                'nama'             => 'ANALITICAL BALANCE (PERALATAN STUDIO VIDEO DAN FILM)',
            ],
            [
                'id_aset'          => 2215,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '086',
                'nama'             => 'ALAT PEMANAS PROSESING ( WATER HEATER )',
            ],
            [
                'id_aset'          => 2216,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '087',
                'nama'             => 'STAPLER FILM',
            ],
            [
                'id_aset'          => 2217,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '088',
                'nama'             => 'MAGNETIC STIP',
            ],
            [
                'id_aset'          => 2218,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '089',
                'nama'             => 'SPLITZER TAPE',
            ],
            [
                'id_aset'          => 2219,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '090',
                'nama'             => 'MEJA EDITING FILM',
            ],
            [
                'id_aset'          => 2220,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '091',
                'nama'             => 'DIGITAL TBC',
            ],
            [
                'id_aset'          => 2221,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '092',
                'nama'             => 'TITANIUM TANK SINGLE SHAFT',
            ],
            [
                'id_aset'          => 2222,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '093',
                'nama'             => 'TEMPERATUR CONTROL C/W',
            ],
            [
                'id_aset'          => 2223,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '094',
                'nama'             => 'GEAR BOX SUN ASSY',
            ],
            [
                'id_aset'          => 2224,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '095',
                'nama'             => 'TACHO GENERATOR FOR DRIVE MOTOR RACHING',
            ],
            [
                'id_aset'          => 2225,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '096',
                'nama'             => 'CIRCULATION SYSTEM COMPLET',
            ],
            [
                'id_aset'          => 2226,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '097',
                'nama'             => 'CHILLER WATER COMPLET',
            ],
            [
                'id_aset'          => 2227,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '098',
                'nama'             => 'VIDEO AUDIO JACK PANEL',
            ],
            [
                'id_aset'          => 2228,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '099',
                'nama'             => 'AUTOMATIC EMERGENCY LIGHT',
            ],
            [
                'id_aset'          => 2229,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '100',
                'nama'             => 'FILM CHAIN MULTIPLIER',
            ],
            [
                'id_aset'          => 2230,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '101',
                'nama'             => 'PHOTO TUSTEL',
            ],
            [
                'id_aset'          => 2231,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '102',
                'nama'             => 'PHOTO TUSTEL POLAROID',
            ],
            [
                'id_aset'          => 2232,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '103',
                'nama'             => 'BETACAM RECORDER/PLAYER',
            ],
            [
                'id_aset'          => 2233,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '104',
                'nama'             => 'SLIDE RAIL',
            ],
            [
                'id_aset'          => 2234,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '105',
                'nama'             => 'WEAPON & METAL DETECTOR ( CHECK GATE )',
            ],
            [
                'id_aset'          => 2235,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '107',
                'nama'             => 'LAYAR FILM/PROJECTOR',
            ],
            [
                'id_aset'          => 2236,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '108',
                'nama'             => 'CAMERA TUNE SIMULATOR',
            ],
            [
                'id_aset'          => 2237,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '109',
                'nama'             => 'DRY SPLITZER FILM',
            ],
            [
                'id_aset'          => 2238,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '110',
                'nama'             => 'VIDEO TONE CLEANER',
            ],
            [
                'id_aset'          => 2239,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '111',
                'nama'             => 'MINI VIEWER',
            ],
            [
                'id_aset'          => 2240,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '112',
                'nama'             => 'PUSH BUTTON CONTROL PANEL',
            ],
            [
                'id_aset'          => 2241,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '113',
                'nama'             => 'RAK TERMINAL VENCING',
            ],
            [
                'id_aset'          => 2242,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '114',
                'nama'             => 'STANDARD TRUE SIGNAL/MASTER RACK',
            ],
            [
                'id_aset'          => 2243,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '115',
                'nama'             => 'MOTOR DRIVER',
            ],
            [
                'id_aset'          => 2244,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '116',
                'nama'             => 'ANALOG DELAY (PERALATAN STUDIO VIDEO DAN FILM)',
            ],
            [
                'id_aset'          => 2245,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '117',
                'nama'             => 'STANDARD POINT ANIMATION',
            ],
            [
                'id_aset'          => 2246,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '118',
                'nama'             => 'HEAD SET',
            ],
            [
                'id_aset'          => 2247,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '119',
                'nama'             => 'CHARACTER EFFECT INTERFACE',
            ],
            [
                'id_aset'          => 2248,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '120',
                'nama'             => 'LIGHTING HEAD BODY',
            ],
            [
                'id_aset'          => 2249,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '121',
                'nama'             => 'LIGHTING MECHANIC',
            ],
            [
                'id_aset'          => 2250,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '122',
                'nama'             => 'ALOS 321 FICHE READER',
            ],
            [
                'id_aset'          => 2251,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '123',
                'nama'             => 'ALOS 321 ALOS READER',
            ],
            [
                'id_aset'          => 2252,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '124',
                'nama'             => 'INSERTER JACKET FILMNES MODEL FRF-160 & 3500',
            ],
            [
                'id_aset'          => 2253,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '125',
                'nama'             => 'DIASO PRINTER',
            ],
            [
                'id_aset'          => 2254,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '126',
                'nama'             => 'DIASO PROCESSOR 404 DAN 404 D',
            ],
            [
                'id_aset'          => 2255,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '127',
                'nama'             => 'CAMERA UNDER WATER',
            ],
            [
                'id_aset'          => 2256,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '128',
                'nama'             => 'CAMERA DIGITAL',
            ],
            [
                'id_aset'          => 2257,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '129',
                'nama'             => 'TAS KAMERA',
            ],
            [
                'id_aset'          => 2258,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '130',
                'nama'             => 'LAMPU BLITZ KAMERA',
            ],
            [
                'id_aset'          => 2259,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '131',
                'nama'             => 'LENSA FILTER',
            ],
            [
                'id_aset'          => 2260,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '132',
                'nama'             => 'VIDEO CONFERENCE',
            ],
            [
                'id_aset'          => 2261,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '133',
                'nama'             => 'TURBO IDDR (INTELLIGENT DIGITAL DISK RECORDER)',
            ],
            [
                'id_aset'          => 2262,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '134',
                'nama'             => 'VIDEO ROUTER',
            ],
            [
                'id_aset'          => 2263,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '135',
                'nama'             => 'LCD MONITOR',
            ],
            [
                'id_aset'          => 2264,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '136',
                'nama'             => 'SDI RASTERISER',
            ],
            [
                'id_aset'          => 2265,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '137',
                'nama'             => 'AUDIO MONITORING UNIT',
            ],
            [
                'id_aset'          => 2266,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '138',
                'nama'             => 'FRAME SYNCHRONIZER',
            ],
            [
                'id_aset'          => 2267,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '139',
                'nama'             => 'AUDIO TRANSCODER',
            ],
            [
                'id_aset'          => 2268,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '140',
                'nama'             => 'AUDIO CONVERTER',
            ],
            [
                'id_aset'          => 2269,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '141',
                'nama'             => 'AUTOMATION MAIN',
            ],
            [
                'id_aset'          => 2270,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '142',
                'nama'             => 'RECORDING WORKSTATION',
            ],
            [
                'id_aset'          => 2271,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '143',
                'nama'             => 'EDITOR WORKSTATION',
            ],
            [
                'id_aset'          => 2272,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '144',
                'nama'             => 'ON AIR RECORDING',
            ],
            [
                'id_aset'          => 2273,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '145',
                'nama'             => 'CONNECTORS',
            ],
            [
                'id_aset'          => 2274,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '146',
                'nama'             => 'PATCH CORD',
            ],
            [
                'id_aset'          => 2275,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '147',
                'nama'             => 'AUDIO EMBEDDER',
            ],
            [
                'id_aset'          => 2276,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '148',
                'nama'             => 'VTR RECORDER',
            ],
            [
                'id_aset'          => 2277,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '149',
                'nama'             => 'ANALOG VIDEO ROUTER',
            ],
            [
                'id_aset'          => 2278,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '150',
                'nama'             => 'BROADBAND AMLIFIER',
            ],
            [
                'id_aset'          => 2279,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '151',
                'nama'             => 'SPLITTER',
            ],
            [
                'id_aset'          => 2280,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '152',
                'nama'             => 'RF CABLE',
            ],
            [
                'id_aset'          => 2281,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '153',
                'nama'             => 'F CONNECTOR',
            ],
            [
                'id_aset'          => 2282,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '154',
                'nama'             => 'TV CONNECTOR',
            ],
            [
                'id_aset'          => 2283,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '155',
                'nama'             => 'THERMO BIND MACHINE',
            ],
            [
                'id_aset'          => 2284,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '156',
                'nama'             => 'KAMERA STILE',
            ],
            [
                'id_aset'          => 2285,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '157',
                'nama'             => 'MINI DV',
            ],
            [
                'id_aset'          => 2286,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '158',
                'nama'             => 'MONOPOD',
            ],
            [
                'id_aset'          => 2287,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '159',
                'nama'             => 'CLIPP ON',
            ],
            [
                'id_aset'          => 2288,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '160',
                'nama'             => 'COMPUTER EDITING',
            ],
            [
                'id_aset'          => 2289,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '161',
                'nama'             => 'CUT EDITING',
            ],
            [
                'id_aset'          => 2290,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '162',
                'nama'             => 'DUPLICATOR VCD',
            ],
            [
                'id_aset'          => 2291,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '163',
                'nama'             => 'DUPLICATOR DVD',
            ],
            [
                'id_aset'          => 2292,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '164',
                'nama'             => 'VIDEO SPLITTER',
            ],
            [
                'id_aset'          => 2293,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '165',
                'nama'             => 'CAMERA CONFERENCE',
            ],
            [
                'id_aset'          => 2294,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN STUDIO VIDEO DAN FILM LAINNYA',
            ],
            [
                'id_aset'          => 2295,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN STUDIO GAMBAR',
            ],
            [
                'id_aset'          => 2296,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MEJA GAMBAR',
            ],
            [
                'id_aset'          => 2297,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'LICHDRUCK APPARAAT',
            ],
            [
                'id_aset'          => 2298,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'SABLON SET',
            ],
            [
                'id_aset'          => 2299,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ALAT TULIS GAMBAR',
            ],
            [
                'id_aset'          => 2300,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '005',
                'nama'             => 'BUSUR GAMBAR',
            ],
            [
                'id_aset'          => 2301,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '006',
                'nama'             => 'JANGKA GAMBAR',
            ],
            [
                'id_aset'          => 2302,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN STUDIO GAMBAR LAINNYA',
            ],
            [
                'id_aset'          => 2303,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN CETAK',
            ],
            [
                'id_aset'          => 2304,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MEJA MEMBUAT KLISE',
            ],
            [
                'id_aset'          => 2305,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MEJA CETAK TANGAN',
            ],
            [
                'id_aset'          => 2306,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MESIN CETAK LISTRIK SHEET',
            ],
            [
                'id_aset'          => 2307,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN CETAK LISTRIK ROLL',
            ],
            [
                'id_aset'          => 2308,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MESIN CETAK ELEKTRONIK',
            ],
            [
                'id_aset'          => 2309,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN CETAK',
            ],
            [
                'id_aset'          => 2310,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN CETAK OFFSET SHEET',
            ],
            [
                'id_aset'          => 2311,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MESIN CETAK OFFSET ROLL',
            ],
            [
                'id_aset'          => 2312,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MESIN CETAK OFFSET MINI',
            ],
            [
                'id_aset'          => 2313,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MESIN PEMOTONG BIASA',
            ],
            [
                'id_aset'          => 2314,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '011',
                'nama'             => 'MESIN PEMOTONG BIASA TIGA PISAU',
            ],
            [
                'id_aset'          => 2315,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '012',
                'nama'             => 'MESIN JILID BUNDAR',
            ],
            [
                'id_aset'          => 2316,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '013',
                'nama'             => 'MESIN JILID BESAR',
            ],
            [
                'id_aset'          => 2317,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '014',
                'nama'             => 'MESIN JILID',
            ],
            [
                'id_aset'          => 2318,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '015',
                'nama'             => 'MESIN LIPAT',
            ],
            [
                'id_aset'          => 2319,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '016',
                'nama'             => 'MESIN PEMBUAT HURUF',
            ],
            [
                'id_aset'          => 2320,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '017',
                'nama'             => 'MESIN PENYUSUN HURUF BIASA',
            ],
            [
                'id_aset'          => 2321,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '018',
                'nama'             => 'MESIN PENYUSUN HURUF FOTO (FOTO TYPE SETTING)',
            ],
            [
                'id_aset'          => 2322,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '019',
                'nama'             => 'MESIN PELUBANG (PERALATAN CETAK)',
            ],
            [
                'id_aset'          => 2323,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '020',
                'nama'             => 'MESIN PROOF',
            ],
            [
                'id_aset'          => 2324,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '021',
                'nama'             => 'CAMERA VERTICAL',
            ],
            [
                'id_aset'          => 2325,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '022',
                'nama'             => 'MESIN PRES',
            ],
            [
                'id_aset'          => 2326,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '023',
                'nama'             => 'MESIN JAHIT KAWAT',
            ],
            [
                'id_aset'          => 2327,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '024',
                'nama'             => 'MESIN JAHIT BENANG',
            ],
            [
                'id_aset'          => 2328,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '025',
                'nama'             => 'MESIN PILUNG',
            ],
            [
                'id_aset'          => 2329,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '026',
                'nama'             => 'MESIN GARIS',
            ],
            [
                'id_aset'          => 2330,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '027',
                'nama'             => 'MESIN PEREKAM STENSIL FOLIO',
            ],
            [
                'id_aset'          => 2331,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '028',
                'nama'             => 'MESIN PEREKAM STENSIL DOUBLE FOLIO',
            ],
            [
                'id_aset'          => 2332,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '029',
                'nama'             => 'MESIN PLATE MAKER FOLIO',
            ],
            [
                'id_aset'          => 2333,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '030',
                'nama'             => 'MESIN PLATE MAKER DOUBLE FOLIO',
            ],
            [
                'id_aset'          => 2334,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '031',
                'nama'             => 'MESIN POTONG',
            ],
            [
                'id_aset'          => 2335,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '032',
                'nama'             => 'MESIN HANDPRESS',
            ],
            [
                'id_aset'          => 2336,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '033',
                'nama'             => 'MESIN STAHD',
            ],
            [
                'id_aset'          => 2337,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '034',
                'nama'             => 'MESIN KERTAS',
            ],
            [
                'id_aset'          => 2338,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '035',
                'nama'             => 'KACIP POTONG SUDUT',
            ],
            [
                'id_aset'          => 2339,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '036',
                'nama'             => 'ALAT PEMBUAT VORMSTAND',
            ],
            [
                'id_aset'          => 2340,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '037',
                'nama'             => 'MESIN PASET',
            ],
            [
                'id_aset'          => 2341,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '038',
                'nama'             => 'MESIN PRASISE KLISE',
            ],
            [
                'id_aset'          => 2342,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '039',
                'nama'             => 'MESIN PEMBOLONG FILM SETENGAH PLANO',
            ],
            [
                'id_aset'          => 2343,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '040',
                'nama'             => 'MESIN CETAK MAS',
            ],
            [
                'id_aset'          => 2344,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '041',
                'nama'             => 'MESIN CETAK STEREO TYPER',
            ],
            [
                'id_aset'          => 2345,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '042',
                'nama'             => 'MESIN CETAK BRAILLE',
            ],
            [
                'id_aset'          => 2346,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '043',
                'nama'             => 'MESIN FONDS',
            ],
            [
                'id_aset'          => 2347,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '044',
                'nama'             => 'MESIN FOLDING',
            ],
            [
                'id_aset'          => 2348,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '045',
                'nama'             => 'MESIN BARCODE',
            ],
            [
                'id_aset'          => 2349,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '046',
                'nama'             => 'MESIN PROFESIONAL VELOBINDER',
            ],
            [
                'id_aset'          => 2350,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '047',
                'nama'             => 'MESIN CACAH',
            ],
            [
                'id_aset'          => 2351,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '048',
                'nama'             => 'IMAGE SETTER',
            ],
            [
                'id_aset'          => 2352,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '049',
                'nama'             => 'MESIN SPARASI',
            ],
            [
                'id_aset'          => 2353,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '050',
                'nama'             => 'CAMERA HORIZONTAL',
            ],
            [
                'id_aset'          => 2354,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '051',
                'nama'             => 'ALAT COVER CREASING',
            ],
            [
                'id_aset'          => 2355,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '052',
                'nama'             => 'MESIN PEMBUAT ID CARD',
            ],
            [
                'id_aset'          => 2356,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN CETAK LAINNYA',
            ],
            [
                'id_aset'          => 2357,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN STUDIO PEMETAAN/PERALATAN UKUR TANAH',
            ],
            [
                'id_aset'          => 2358,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'AUTOGRAPH UNIT',
            ],
            [
                'id_aset'          => 2359,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'AVIOGRAPH PLUS PLOTING TABLE',
            ],
            [
                'id_aset'          => 2360,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PLANITOP',
            ],
            [
                'id_aset'          => 2361,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'POINT TRANTER DEVICE',
            ],
            [
                'id_aset'          => 2362,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '005',
                'nama'             => 'TRESTIRIAL CAMERA',
            ],
            [
                'id_aset'          => 2363,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '006',
                'nama'             => 'SLOHED TEMLET',
            ],
            [
                'id_aset'          => 2364,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '007',
                'nama'             => 'SKETCH MASTER',
            ],
            [
                'id_aset'          => 2365,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '008',
                'nama'             => 'RECTIFIER (PERALATAN STUDIO PEMETAAN/PERALATAN UKUR TANAH)',
            ],
            [
                'id_aset'          => 2366,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '009',
                'nama'             => 'OPTICAL PANTOGRAPH',
            ],
            [
                'id_aset'          => 2367,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '010',
                'nama'             => 'CONTACT PRINTER',
            ],
            [
                'id_aset'          => 2368,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '011',
                'nama'             => 'PENGERING PHOTO',
            ],
            [
                'id_aset'          => 2369,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '012',
                'nama'             => 'VACUM FRAME',
            ],
            [
                'id_aset'          => 2370,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '013',
                'nama'             => 'COORDINATOGRAPH',
            ],
            [
                'id_aset'          => 2371,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '014',
                'nama'             => 'PEMOTONG FILM',
            ],
            [
                'id_aset'          => 2372,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '015',
                'nama'             => 'STREOSCOPE TANAH',
            ],
            [
                'id_aset'          => 2373,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '016',
                'nama'             => 'WATERPAS',
            ],
            [
                'id_aset'          => 2374,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '017',
                'nama'             => 'THEODOLITE (PERALATAN STUDIO PEMETAAN/PERALATAN UKUR TANAH)',
            ],
            [
                'id_aset'          => 2375,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '018',
                'nama'             => 'DISTOMAT',
            ],
            [
                'id_aset'          => 2376,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '019',
                'nama'             => 'B.T.M',
            ],
            [
                'id_aset'          => 2377,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '020',
                'nama'             => 'LEVEL',
            ],
            [
                'id_aset'          => 2378,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '021',
                'nama'             => 'JALON',
            ],
            [
                'id_aset'          => 2379,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '022',
                'nama'             => 'RAMBU/BAK UKUR',
            ],
            [
                'id_aset'          => 2380,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '023',
                'nama'             => 'KOMPAS GEOLOGI',
            ],
            [
                'id_aset'          => 2381,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '024',
                'nama'             => 'CLINOMETER',
            ],
            [
                'id_aset'          => 2382,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '025',
                'nama'             => 'ALTIMETER (PERALATAN STUDIO PEMETAAN/PERALATAN UKUR TANAH)',
            ],
            [
                'id_aset'          => 2383,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '026',
                'nama'             => 'HOLIOMETER',
            ],
            [
                'id_aset'          => 2384,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '027',
                'nama'             => 'TELESCOPE (PERALATAN STUDIO PEMETAAN/PERALATAN UKUR TANAH)',
            ],
            [
                'id_aset'          => 2385,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '028',
                'nama'             => 'PASSER DOSS',
            ],
            [
                'id_aset'          => 2386,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '029',
                'nama'             => 'CURVERMETER',
            ],
            [
                'id_aset'          => 2387,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '030',
                'nama'             => 'ROLLMETER',
            ],
            [
                'id_aset'          => 2388,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '031',
                'nama'             => 'MEET BAND',
            ],
            [
                'id_aset'          => 2389,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '032',
                'nama'             => 'BUSUR DERAJAT',
            ],
            [
                'id_aset'          => 2390,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '033',
                'nama'             => 'CHRONOMETER (PERALATAN STUDIO PEMETAAN/PERALATAN UKUR TANAH)',
            ],
            [
                'id_aset'          => 2391,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '034',
                'nama'             => 'GAWANG LOKASI',
            ],
            [
                'id_aset'          => 2392,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '035',
                'nama'             => 'KOMPAS (PERALATAN STUDIO PEMETAAN/PERALATAN UKUR TANAH)',
            ],
            [
                'id_aset'          => 2393,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '036',
                'nama'             => 'SEXTANT',
            ],
            [
                'id_aset'          => 2394,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '037',
                'nama'             => 'TEROPONG/KEKER',
            ],
            [
                'id_aset'          => 2395,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '038',
                'nama'             => 'GPS RECEIVER',
            ],
            [
                'id_aset'          => 2396,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '039',
                'nama'             => 'GROUND PARETRATING RADAR',
            ],
            [
                'id_aset'          => 2397,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '040',
                'nama'             => 'TEKEN SCHAAL/JANGKA TUSUK',
            ],
            [
                'id_aset'          => 2398,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '041',
                'nama'             => 'PANTOGRAPH',
            ],
            [
                'id_aset'          => 2399,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '042',
                'nama'             => 'PLANI METER',
            ],
            [
                'id_aset'          => 2400,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '043',
                'nama'             => 'PRISMA ROELAK',
            ],
            [
                'id_aset'          => 2401,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '044',
                'nama'             => 'PRISMA METER',
            ],
            [
                'id_aset'          => 2402,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '045',
                'nama'             => 'PRISMA UKUR',
            ],
            [
                'id_aset'          => 2403,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '046',
                'nama'             => 'RUITER PLAAT',
            ],
            [
                'id_aset'          => 2404,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '047',
                'nama'             => 'KAMERA UDARA',
            ],
            [
                'id_aset'          => 2405,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '048',
                'nama'             => 'STEREOPLOTTER',
            ],
            [
                'id_aset'          => 2406,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '049',
                'nama'             => 'PLANICOMP',
            ],
            [
                'id_aset'          => 2407,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '050',
                'nama'             => 'MEJA SINAR',
            ],
            [
                'id_aset'          => 2408,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '051',
                'nama'             => 'GRAVER',
            ],
            [
                'id_aset'          => 2409,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '052',
                'nama'             => 'PEN HOLDER',
            ],
            [
                'id_aset'          => 2410,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN STUDIO PEMETAAN/PERALATAN UKUR TANAH LAINNYA',
            ],
            [
                'id_aset'          => 2411,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT STUDIO LAINNYA',
            ],
            [
                'id_aset'          => 2412,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '01',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT STUDIO LAINNYA',
            ],
            [
                'id_aset'          => 2413,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI',
            ],
            [
                'id_aset'          => 2414,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI TELEPHONE',
            ],
            [
                'id_aset'          => 2415,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TELEPHONE (PABX)',
            ],
            [
                'id_aset'          => 2416,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'INTERMEDIATE TELEPHONE/KEY TELEPHONE',
            ],
            [
                'id_aset'          => 2417,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PESAWAT TELEPHONE',
            ],
            [
                'id_aset'          => 2418,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TELEPHONE MOBILE',
            ],
            [
                'id_aset'          => 2419,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PAGER',
            ],
            [
                'id_aset'          => 2420,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '006',
                'nama'             => 'HANDY TALKY (HT)',
            ],
            [
                'id_aset'          => 2421,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TELEX',
            ],
            [
                'id_aset'          => 2422,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '008',
                'nama'             => 'SELECTIVE COLLING',
            ],
            [
                'id_aset'          => 2423,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '009',
                'nama'             => 'PERALATAN SPECH PLAS',
            ],
            [
                'id_aset'          => 2424,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '010',
                'nama'             => 'FACSIMILE',
            ],
            [
                'id_aset'          => 2425,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '011',
                'nama'             => 'BIDDING PIT',
            ],
            [
                'id_aset'          => 2426,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '012',
                'nama'             => 'LOCAL BATTERY TELEPHONE',
            ],
            [
                'id_aset'          => 2427,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '013',
                'nama'             => 'SENHUB FIXED',
            ],
            [
                'id_aset'          => 2428,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '014',
                'nama'             => 'SENHUB MOBILE',
            ],
            [
                'id_aset'          => 2429,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '015',
                'nama'             => 'TELEPON LAPANGAN',
            ],
            [
                'id_aset'          => 2430,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '016',
                'nama'             => 'SENTRAL TELEPON LAPANGAN',
            ],
            [
                'id_aset'          => 2431,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '017',
                'nama'             => 'TELEPON SATELIT',
            ],
            [
                'id_aset'          => 2432,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '018',
                'nama'             => 'KOM DATA',
            ],
            [
                'id_aset'          => 2433,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '019',
                'nama'             => 'PDA',
            ],
            [
                'id_aset'          => 2434,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '020',
                'nama'             => 'TELEPON DIGITAL',
            ],
            [
                'id_aset'          => 2435,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '021',
                'nama'             => 'TELEPON ANALOG',
            ],
            [
                'id_aset'          => 2436,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI TELEPHONE LAINNYA',
            ],
            [
                'id_aset'          => 2437,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI RADIO SSB',
            ],
            [
                'id_aset'          => 2438,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANCEIVER SSB PORTABLE',
            ],
            [
                'id_aset'          => 2439,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANCEIVER SSB TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2440,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANCEIVER SSB STATIONERY',
            ],
            [
                'id_aset'          => 2441,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI RADIO SSB LAINNYA',
            ],
            [
                'id_aset'          => 2442,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI RADIO HF/FM',
            ],
            [
                'id_aset'          => 2443,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANCEIVER HF PORTABLE',
            ],
            [
                'id_aset'          => 2444,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANCEIVER HF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2445,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANCEIVER HF STATIONERY',
            ],
            [
                'id_aset'          => 2446,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '004',
                'nama'             => 'UNIT TRANCEIVER FM',
            ],
            [
                'id_aset'          => 2447,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI RADIO HF/FM LAINNYA',
            ],
            [
                'id_aset'          => 2448,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI RADIO VHF',
            ],
            [
                'id_aset'          => 2449,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANCEIVER VHF PORTABLE',
            ],
            [
                'id_aset'          => 2450,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANCEIVER VHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2451,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANCEIVER VHF STATIONARY',
            ],
            [
                'id_aset'          => 2452,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI RADIO VHF LAINNYA',
            ],
            [
                'id_aset'          => 2453,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI RADIO UHF',
            ],
            [
                'id_aset'          => 2454,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANCEIVER UHF PORTABLE',
            ],
            [
                'id_aset'          => 2455,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANCEIVER UHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2456,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANCEIVER UHF STATIONARY',
            ],
            [
                'id_aset'          => 2457,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI RADIO UHF LAINNYA',
            ],
            [
                'id_aset'          => 2458,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI SOSIAL',
            ],
            [
                'id_aset'          => 2459,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PUBLIK ADDRESS (LAPANGAN)',
            ],
            [
                'id_aset'          => 2460,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'WIRELESS AMPLIFIER',
            ],
            [
                'id_aset'          => 2461,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'SLIDE PROJECTOR (LAPANGAN)',
            ],
            [
                'id_aset'          => 2462,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MULTIPLEX SYSTEM',
            ],
            [
                'id_aset'          => 2463,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '005',
                'nama'             => 'FREQUENCY SYSTHESIZER UNIT',
            ],
            [
                'id_aset'          => 2464,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PATCHING BOARD',
            ],
            [
                'id_aset'          => 2465,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI SOSIAL LAINNYA',
            ],
            [
                'id_aset'          => 2466,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT-ALAT SANDI',
            ],
            [
                'id_aset'          => 2467,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MORSE KEYER',
            ],
            [
                'id_aset'          => 2468,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'AUTOMATIC DEORSE KEYER',
            ],
            [
                'id_aset'          => 2469,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ALAT SEMBOYAN',
            ],
            [
                'id_aset'          => 2470,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '004',
                'nama'             => 'MESIN SANDI DAN KELENGKAPANNYA',
            ],
            [
                'id_aset'          => 2471,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '005',
                'nama'             => 'FINGER PRINTER TIME AND ATTANDANCE ACCES CONTROL SYSTEM',
            ],
            [
                'id_aset'          => 2472,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '006',
                'nama'             => 'MESIN SANDI TEKS',
            ],
            [
                'id_aset'          => 2473,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '007',
                'nama'             => 'MESIN SANDI SUARA',
            ],
            [
                'id_aset'          => 2474,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MESIN SANDI DATA',
            ],
            [
                'id_aset'          => 2475,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MESIN SANDI BERBASIS SOFTWARE',
            ],
            [
                'id_aset'          => 2476,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MESIN SANDI BERBASIS HARDWARE',
            ],
            [
                'id_aset'          => 2477,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '011',
                'nama'             => 'MESIN SANDI BERBASIS SOFTWARE DAN HARDWARE',
            ],
            [
                'id_aset'          => 2478,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '012',
                'nama'             => 'ALAT PEMBANGKIT KUNCI',
            ],
            [
                'id_aset'          => 2479,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '013',
                'nama'             => 'ALAT PENDISTRIBUSI KUNCI',
            ],
            [
                'id_aset'          => 2480,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '014',
                'nama'             => 'CRYPTHOPONE',
            ],
            [
                'id_aset'          => 2481,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '015',
                'nama'             => 'CRYTOFAX',
            ],
            [
                'id_aset'          => 2482,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '016',
                'nama'             => 'SERVER ENCRIPTION',
            ],
            [
                'id_aset'          => 2483,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '017',
                'nama'             => 'HANDPHONE ENCRIPTION',
            ],
            [
                'id_aset'          => 2484,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '018',
                'nama'             => 'GSM JAMMER',
            ],
            [
                'id_aset'          => 2485,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '019',
                'nama'             => 'CDMA JAMMER',
            ],
            [
                'id_aset'          => 2486,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT-ALAT SANDI LAINNYA',
            ],
            [
                'id_aset'          => 2487,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI KHUSUS',
            ],
            [
                'id_aset'          => 2488,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ALAT DF RADIO SSB',
            ],
            [
                'id_aset'          => 2489,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SUPER BROOM',
            ],
            [
                'id_aset'          => 2490,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ALAT DF RADIO HF/FM',
            ],
            [
                'id_aset'          => 2491,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '004',
                'nama'             => 'SCANLOCK PLUS CEBERUS',
            ],
            [
                'id_aset'          => 2492,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '005',
                'nama'             => 'ALAT DF RADIO VHF',
            ],
            [
                'id_aset'          => 2493,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '006',
                'nama'             => 'STELATH DIGITAL REPEATER',
            ],
            [
                'id_aset'          => 2494,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '007',
                'nama'             => 'ALAT DF RADIO UHF',
            ],
            [
                'id_aset'          => 2495,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '008',
                'nama'             => 'TRANKING',
            ],
            [
                'id_aset'          => 2496,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '009',
                'nama'             => 'TELEPON TAPING',
            ],
            [
                'id_aset'          => 2497,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '010',
                'nama'             => 'STELATH',
            ],
            [
                'id_aset'          => 2498,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '011',
                'nama'             => 'VISATELIT',
            ],
            [
                'id_aset'          => 2499,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '012',
                'nama'             => 'MAINFRAME (ALAT KOMUNIKASI KHUSUS)',
            ],
            [
                'id_aset'          => 2500,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '013',
                'nama'             => 'SAFE LIGHT FILTER',
            ],
            [
                'id_aset'          => 2501,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '014',
                'nama'             => 'ANTI SADAP TELEPON (SCANBLER)',
            ],
            [
                'id_aset'          => 2502,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '015',
                'nama'             => 'BILLINF SYSTEM',
            ],
            [
                'id_aset'          => 2503,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '016',
                'nama'             => 'ROOM MONITORING MC06',
            ],
            [
                'id_aset'          => 2504,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '017',
                'nama'             => 'WATCH TRANSMITER',
            ],
            [
                'id_aset'          => 2505,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '018',
                'nama'             => 'ASHTRAY',
            ],
            [
                'id_aset'          => 2506,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '019',
                'nama'             => 'NON DIRECTION BEACON (NDB)',
            ],
            [
                'id_aset'          => 2507,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '020',
                'nama'             => 'RADIO LINK',
            ],
            [
                'id_aset'          => 2508,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '021',
                'nama'             => 'LOCALIZER',
            ],
            [
                'id_aset'          => 2509,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '022',
                'nama'             => 'GLADE PATH',
            ],
            [
                'id_aset'          => 2510,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '023',
                'nama'             => 'MIDLE MARKER',
            ],
            [
                'id_aset'          => 2511,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '024',
                'nama'             => 'RADIO COMMUNICATION MATCHING SWITCH (RCMS)',
            ],
            [
                'id_aset'          => 2512,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '025',
                'nama'             => 'DIRECTION VERY OMNI RANGE (DVOR)',
            ],
            [
                'id_aset'          => 2513,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '026',
                'nama'             => 'INTEGRATED GROUND CAOMMUNICATION SYSTEM (SGRS)',
            ],
            [
                'id_aset'          => 2514,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '027',
                'nama'             => 'SWITCHING GROUND RECEIVER SYSTEM (SGRS)',
            ],
            [
                'id_aset'          => 2515,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '028',
                'nama'             => 'ALAT RX RADIO SSB',
            ],
            [
                'id_aset'          => 2516,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '029',
                'nama'             => 'ALAT RX RADIO HF/FM',
            ],
            [
                'id_aset'          => 2517,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '030',
                'nama'             => 'ALAT RX RADIO VHF',
            ],
            [
                'id_aset'          => 2518,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '031',
                'nama'             => 'ALAT RX RADIO UHF',
            ],
            [
                'id_aset'          => 2519,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '032',
                'nama'             => 'ALAT JAMMING RADIO SSB',
            ],
            [
                'id_aset'          => 2520,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '033',
                'nama'             => 'ALAT JAMMING RADIO HF/FM',
            ],
            [
                'id_aset'          => 2521,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '034',
                'nama'             => 'ALAT JAMMING RADIO VHF',
            ],
            [
                'id_aset'          => 2522,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '035',
                'nama'             => 'ALAT JAMMING RADIO UHF',
            ],
            [
                'id_aset'          => 2523,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '036',
                'nama'             => 'ALAT SPEKTRUM FREK MONITOR SSB',
            ],
            [
                'id_aset'          => 2524,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '037',
                'nama'             => 'ALAT SPEKTRUM FREK MONITOR HF/FM',
            ],
            [
                'id_aset'          => 2525,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '038',
                'nama'             => 'ALAT SPEKTRUM FREK MONITOR VHF',
            ],
            [
                'id_aset'          => 2526,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '039',
                'nama'             => 'ALAT SPEKTRUM FREK MONITOR UHF',
            ],
            [
                'id_aset'          => 2527,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '040',
                'nama'             => 'ALAT TRAFFIC ANALYSIS',
            ],
            [
                'id_aset'          => 2528,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '041',
                'nama'             => 'ALAT COUNTERSURVEILLANCE',
            ],
            [
                'id_aset'          => 2529,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '042',
                'nama'             => 'ALAT SURVEILLANCE',
            ],
            [
                'id_aset'          => 2530,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '043',
                'nama'             => 'ALAT JAMMING FREKUENSI',
            ],
            [
                'id_aset'          => 2531,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '044',
                'nama'             => 'ALAT PENGENDALI PANCARAN GELOMBANG ELEKTROMAGNETIK (TEMPEST)',
            ],
            [
                'id_aset'          => 2532,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI KHUSUS LAINNYA',
            ],
            [
                'id_aset'          => 2533,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI DIGITAL DAN KONVENSIONAL',
            ],
            [
                'id_aset'          => 2534,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SYSTEM CONTROL NODE MULTI SITE SYSTEM',
            ],
            [
                'id_aset'          => 2535,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SITE BASE STATAION MULTI SITE SYSTEM',
            ],
            [
                'id_aset'          => 2536,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '003',
                'nama'             => 'CONTROLL CENTER',
            ],
            [
                'id_aset'          => 2537,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '004',
                'nama'             => 'E2EENCRYPTION MANAGEMENT TOOLS',
            ],
            [
                'id_aset'          => 2538,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '005',
                'nama'             => 'NETWORK MONITORING SYSTEM',
            ],
            [
                'id_aset'          => 2539,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '006',
                'nama'             => 'SWITCHING MATRIX AND SERVER',
            ],
            [
                'id_aset'          => 2540,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '007',
                'nama'             => 'DIGITAL RECORDING SYSTEM',
            ],
            [
                'id_aset'          => 2541,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '008',
                'nama'             => 'OFFICIAL PHERIPHERAL',
            ],
            [
                'id_aset'          => 2542,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '009',
                'nama'             => 'MOBILE UNIT',
            ],
            [
                'id_aset'          => 2543,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '010',
                'nama'             => 'MOBILE GATEWAY',
            ],
            [
                'id_aset'          => 2544,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '011',
                'nama'             => 'CONVERT BODY',
            ],
            [
                'id_aset'          => 2545,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '012',
                'nama'             => 'REPEATER RX/TX',
            ],
            [
                'id_aset'          => 2546,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '013',
                'nama'             => 'REPEATER MULTIBAND COMBINER 4 IN 4OUT',
            ],
            [
                'id_aset'          => 2547,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '014',
                'nama'             => 'REPEATER MULTIBAND COMBINER 4 IN 2OUT',
            ],
            [
                'id_aset'          => 2548,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '015',
                'nama'             => 'REPEATER MULTIBAND COMBINER 2 IN 2OUT',
            ],
            [
                'id_aset'          => 2549,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '016',
                'nama'             => 'REPEATER CDMA 80PO MHZ',
            ],
            [
                'id_aset'          => 2550,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '017',
                'nama'             => 'REPEATER CDS 1800 MHZ',
            ],
            [
                'id_aset'          => 2551,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI DIGITAL DAN KONVENSIONAL LAINNYA',
            ],
            [
                'id_aset'          => 2552,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI SATELIT',
            ],
            [
                'id_aset'          => 2553,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '001',
                'nama'             => 'FULLY SYSTEM HUB',
            ],
            [
                'id_aset'          => 2554,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '002',
                'nama'             => 'VSAT SYSTEM FOR REMOTE TERMINAL',
            ],
            [
                'id_aset'          => 2555,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '003',
                'nama'             => 'COMMOB (COMMUNICATION MOBILE) VSAT',
            ],
            [
                'id_aset'          => 2556,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '004',
                'nama'             => 'WIRELESS BASE STATION + SURVEILLANCE MANPACK KIT',
            ],
            [
                'id_aset'          => 2557,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '005',
                'nama'             => 'FLYAWAY',
            ],
            [
                'id_aset'          => 2558,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '006',
                'nama'             => 'ENCRYPTION',
            ],
            [
                'id_aset'          => 2559,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '007',
                'nama'             => 'REMOTE DATA CONNECTION DISTRIBUTION',
            ],
            [
                'id_aset'          => 2560,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '008',
                'nama'             => 'REMOTE VOIP GATEWAY E1 CARD INTERFACE',
            ],
            [
                'id_aset'          => 2561,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '009',
                'nama'             => 'SPECTRUM ANALYZER FOR HUB STATION',
            ],
            [
                'id_aset'          => 2562,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '010',
                'nama'             => 'SPECTRUM ANALYZER PORTABLE FOR FIELD USE',
            ],
            [
                'id_aset'          => 2563,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '011',
                'nama'             => 'UPS 15 KVA FOR HUB STATION',
            ],
            [
                'id_aset'          => 2564,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '012',
                'nama'             => 'UPS 1 KVA FOR REMOTE STATION',
            ],
            [
                'id_aset'          => 2565,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI SATELIT LAINNYA',
            ],
            [
                'id_aset'          => 2566,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '000',
                'nama'             => 'ALAT KOMUNIKASI LAINNYA',
            ],
            [
                'id_aset'          => 2567,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '02',
                'sub_kelompok'     => '99',
                'sub_sub_kelompok' => '999',
                'nama'             => 'ALAT KOMUNIKASI LAINNYA',
            ],
            [
                'id_aset'          => 2568,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '00',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR',
            ],
            [
                'id_aset'          => 2569,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR MF/MW',
            ],
            [
                'id_aset'          => 2570,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PEMANCAR MF/MW PORTABLE',
            ],
            [
                'id_aset'          => 2571,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT PEMANCAR MF/MW TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2572,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT PEMANCAR MF/MW STATIONARY',
            ],
            [
                'id_aset'          => 2573,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '01',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR MF/MW LAINNYA',
            ],
            [
                'id_aset'          => 2574,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR HF/SW',
            ],
            [
                'id_aset'          => 2575,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PEMANCAR HF/SW PORTABLE',
            ],
            [
                'id_aset'          => 2576,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT PEMANCAR HF/SW TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2577,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT PEMANCAR HF/SW STATIONARY',
            ],
            [
                'id_aset'          => 2578,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '02',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR HF/SW LAINNYA',
            ],
            [
                'id_aset'          => 2579,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR VHF/FM',
            ],
            [
                'id_aset'          => 2580,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PEMANCAR VHF/FM PORTABLE',
            ],
            [
                'id_aset'          => 2581,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT PEMANCAR VHF/FM TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2582,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT PEMANCAR VHF/FM STATIONARY',
            ],
            [
                'id_aset'          => 2583,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '03',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR VHF/FM LAINNYA',
            ],
            [
                'id_aset'          => 2584,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR UHF',
            ],
            [
                'id_aset'          => 2585,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PEMANCAR UHF PORTABLE',
            ],
            [
                'id_aset'          => 2586,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT PEMANCAR UHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2587,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT PEMANCAR UHF STATIONARY',
            ],
            [
                'id_aset'          => 2588,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PORTABLE REPORTER LINK',
            ],
            [
                'id_aset'          => 2589,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '04',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR UHF LAINNYA',
            ],
            [
                'id_aset'          => 2590,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR SHF',
            ],
            [
                'id_aset'          => 2591,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PEMANCAR SHF PORTABLE',
            ],
            [
                'id_aset'          => 2592,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT PEMANCAR SHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2593,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT PEMANCAR SHF STATIONARY',
            ],
            [
                'id_aset'          => 2594,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '004',
                'nama'             => 'SATELLITE LINK ( UP/DOWN LINK )',
            ],
            [
                'id_aset'          => 2595,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '05',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR SHF LAINNYA',
            ],
            [
                'id_aset'          => 2596,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN ANTENA MF/MW',
            ],
            [
                'id_aset'          => 2597,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ANTENE MF/MW PORTABLE',
            ],
            [
                'id_aset'          => 2598,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ANTENE MF/MW TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2599,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ANTENE MF/MW STATIONARY',
            ],
            [
                'id_aset'          => 2600,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '06',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN ANTENA MF/MW LAINNYA',
            ],
            [
                'id_aset'          => 2601,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN ANTENA HF/SW',
            ],
            [
                'id_aset'          => 2602,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ANTENE HF/SW PORTABLE',
            ],
            [
                'id_aset'          => 2603,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ANTENE HF/SW TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2604,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ANTENE HF/SW STATIONARY',
            ],
            [
                'id_aset'          => 2605,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '07',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN ANTENA HF/SW LAINNYA',
            ],
            [
                'id_aset'          => 2606,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN ANTENA VHF/FM',
            ],
            [
                'id_aset'          => 2607,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ANTENE VHF/FM PORTABLE',
            ],
            [
                'id_aset'          => 2608,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ANTENE VHF/FM TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2609,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ANTENE VHF/FM STATIONARY',
            ],
            [
                'id_aset'          => 2610,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '08',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN ANTENA VHF/FM LAINNYA',
            ],
            [
                'id_aset'          => 2611,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN ANTENA UHF',
            ],
            [
                'id_aset'          => 2612,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ANTENE UHF PORTABLE',
            ],
            [
                'id_aset'          => 2613,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ANTENE UHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2614,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ANTENE UHF STATIONARY',
            ],
            [
                'id_aset'          => 2615,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '09',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN ANTENA UHF LAINNYA',
            ],
            [
                'id_aset'          => 2616,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN ANTENA SHF/PARABOLA',
            ],
            [
                'id_aset'          => 2617,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ANTENE SHF PORTABLE',
            ],
            [
                'id_aset'          => 2618,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '002',
                'nama'             => 'ANTENE SHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2619,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ANTENE SHF STATIONARY',
            ],
            [
                'id_aset'          => 2620,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ANTENA ALL BAND',
            ],
            [
                'id_aset'          => 2621,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '005',
                'nama'             => 'ANTENA SSB',
            ],
            [
                'id_aset'          => 2622,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '10',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN ANTENA SHF/PARABOLA LAINNYA',
            ],
            [
                'id_aset'          => 2623,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN TRANSLATOR VHF/VHF',
            ],
            [
                'id_aset'          => 2624,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRANSLATOR VHF/VHF PORTABLE',
            ],
            [
                'id_aset'          => 2625,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TRANSLATOR VHF/VHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2626,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TRANSLATOR VHF/VHF STATIONARY',
            ],
            [
                'id_aset'          => 2627,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '11',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN TRANSLATOR VHF/VHF LAINNYA',
            ],
            [
                'id_aset'          => 2628,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN TRANSLATOR UHF/UHF',
            ],
            [
                'id_aset'          => 2629,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRANSLATOR UHF/UHF PORTABLE',
            ],
            [
                'id_aset'          => 2630,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TRANSLATOR UHF/UHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2631,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TRANSLATOR UHF/UHF STATIONARY',
            ],
            [
                'id_aset'          => 2632,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '12',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN TRANSLATOR UHF/UHF LAINNYA',
            ],
            [
                'id_aset'          => 2633,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN TRANSLATOR VHF/UHF',
            ],
            [
                'id_aset'          => 2634,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRANSLATOR VHF/UHF PORTABLE',
            ],
            [
                'id_aset'          => 2635,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TRANSLATOR VHF/UHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2636,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TRANSLATOR VHF/UHF STATIONARY',
            ],
            [
                'id_aset'          => 2637,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '13',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN TRANSLATOR VHF/UHF LAINNYA',
            ],
            [
                'id_aset'          => 2638,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN TRANSLATOR UHF/VHF',
            ],
            [
                'id_aset'          => 2639,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '001',
                'nama'             => 'TRANSLATOR UHF/VHF PORTABLE',
            ],
            [
                'id_aset'          => 2640,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '002',
                'nama'             => 'TRANSLATOR UHF/VHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2641,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '003',
                'nama'             => 'TRANSLATOR UHF/VHF STATIONARY',
            ],
            [
                'id_aset'          => 2642,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '14',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN TRANSLATOR UHF/VHF LAINNYA',
            ],
            [
                'id_aset'          => 2643,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '15',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN MICROWAVE F P U',
            ],
            [
                'id_aset'          => 2644,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '15',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MICROWAVE F P U PORTABLE',
            ],
            [
                'id_aset'          => 2645,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '15',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MICROWAVE F P U TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2646,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '15',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MICROWAVE F P U STATIONARY',
            ],
            [
                'id_aset'          => 2647,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '15',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN MICROWAVE F P U LAINNYA',
            ],
            [
                'id_aset'          => 2648,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '16',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN MICROWAVE TERESTRIAL',
            ],
            [
                'id_aset'          => 2649,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '16',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MICROWAVE TERESTRIAL PORTABLE',
            ],
            [
                'id_aset'          => 2650,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '16',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MICROWAVE TERESTRIAL TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2651,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '16',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MICROWAVE TERESTRIAL STATIONARY',
            ],
            [
                'id_aset'          => 2652,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '16',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN MICROWAVE TERESTRIAL LAINNYA',
            ],
            [
                'id_aset'          => 2653,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '17',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN MICROWAVE TVRO',
            ],
            [
                'id_aset'          => 2654,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '17',
                'sub_sub_kelompok' => '001',
                'nama'             => 'MICROWAVE TVRO PORTABLE',
            ],
            [
                'id_aset'          => 2655,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '17',
                'sub_sub_kelompok' => '002',
                'nama'             => 'MICROWAVE TVRO TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2656,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '17',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MICROWAVE TVRO STATIONARY',
            ],
            [
                'id_aset'          => 2657,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '17',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN MICROWAVE TVRO LAINNYA',
            ],
            [
                'id_aset'          => 2658,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '18',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN DUMMY LOAD',
            ],
            [
                'id_aset'          => 2659,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '18',
                'sub_sub_kelompok' => '001',
                'nama'             => 'DUMMY LOAD PENDINGIN UDARA',
            ],
            [
                'id_aset'          => 2660,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '18',
                'sub_sub_kelompok' => '002',
                'nama'             => 'DUMMY LOAD PENDINGIN AIR',
            ],
            [
                'id_aset'          => 2661,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '18',
                'sub_sub_kelompok' => '003',
                'nama'             => 'DUMMY LOAD PENDINGIN MINYAK',
            ],
            [
                'id_aset'          => 2662,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '18',
                'sub_sub_kelompok' => '004',
                'nama'             => 'DUMMY LOAD PENDINGIN GAS',
            ],
            [
                'id_aset'          => 2663,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '18',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN DUMMY LOAD LAINNYA',
            ],
            [
                'id_aset'          => 2664,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '19',
                'sub_sub_kelompok' => '000',
                'nama'             => 'SWITCHER ANTENA',
            ],
            [
                'id_aset'          => 2665,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '19',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SWITCHER COMBINATION',
            ],
            [
                'id_aset'          => 2666,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '19',
                'sub_sub_kelompok' => '002',
                'nama'             => 'SWITCHER MANUAL',
            ],
            [
                'id_aset'          => 2667,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '19',
                'sub_sub_kelompok' => '003',
                'nama'             => 'SWITCHER AUTOMATIC MOTOR',
            ],
            [
                'id_aset'          => 2668,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '19',
                'sub_sub_kelompok' => '999',
                'nama'             => 'SWITCHER ANTENA LAINNYA',
            ],
            [
                'id_aset'          => 2669,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '20',
                'sub_sub_kelompok' => '000',
                'nama'             => 'SWITCHER/MENARA ANTENA',
            ],
            [
                'id_aset'          => 2670,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '20',
                'sub_sub_kelompok' => '001',
                'nama'             => 'SELF SUPPORTING TOWER',
            ],
            [
                'id_aset'          => 2671,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '20',
                'sub_sub_kelompok' => '002',
                'nama'             => 'GUY TOWER',
            ],
            [
                'id_aset'          => 2672,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '20',
                'sub_sub_kelompok' => '003',
                'nama'             => 'MAST TOWER',
            ],
            [
                'id_aset'          => 2673,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '20',
                'sub_sub_kelompok' => '004',
                'nama'             => 'CONCRETE TOWER',
            ],
            [
                'id_aset'          => 2674,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '20',
                'sub_sub_kelompok' => '999',
                'nama'             => 'SWITCHER/MENARA ANTENA LAINNYA',
            ],
            [
                'id_aset'          => 2675,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '21',
                'sub_sub_kelompok' => '000',
                'nama'             => 'FEEDER',
            ],
            [
                'id_aset'          => 2676,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '21',
                'sub_sub_kelompok' => '001',
                'nama'             => 'OPEN WIRE',
            ],
            [
                'id_aset'          => 2677,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '21',
                'sub_sub_kelompok' => '002',
                'nama'             => 'COAXIAL FEEDER',
            ],
            [
                'id_aset'          => 2678,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '21',
                'sub_sub_kelompok' => '003',
                'nama'             => 'ANTENNA TUNING UNIT',
            ],
            [
                'id_aset'          => 2679,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '21',
                'sub_sub_kelompok' => '004',
                'nama'             => 'DEHYDRATOR',
            ],
            [
                'id_aset'          => 2680,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '21',
                'sub_sub_kelompok' => '999',
                'nama'             => 'FEEDER LAINNYA (ALAT STUDIO',
            ],
            [
                'id_aset'          => 2681,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '22',
                'sub_sub_kelompok' => '000',
                'nama'             => 'HUMIDITY CONTROL',
            ],
            [
                'id_aset'          => 2682,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '22',
                'sub_sub_kelompok' => '001',
                'nama'             => 'DEHUMIDIFIER (HUMIDITY CONTROL)',
            ],
            [
                'id_aset'          => 2683,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '22',
                'sub_sub_kelompok' => '999',
                'nama'             => 'HUMIDITY CONTROL LAINNYA',
            ],
            [
                'id_aset'          => 2684,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PROGRAM INPUT EQUIPMENT',
            ],
            [
                'id_aset'          => 2685,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '001',
                'nama'             => 'RECEIVER STL/VHF ( FM)',
            ],
            [
                'id_aset'          => 2686,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '002',
                'nama'             => 'RECEIVER STL/UHF',
            ],
            [
                'id_aset'          => 2687,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '003',
                'nama'             => 'RECEIVER STL/SHF',
            ],
            [
                'id_aset'          => 2688,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '004',
                'nama'             => 'TVRO',
            ],
            [
                'id_aset'          => 2689,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '005',
                'nama'             => 'LINE AMPLIFIER',
            ],
            [
                'id_aset'          => 2690,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '006',
                'nama'             => 'S R O',
            ],
            [
                'id_aset'          => 2691,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '007',
                'nama'             => 'LINE EQUALIZER',
            ],
            [
                'id_aset'          => 2692,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '008',
                'nama'             => 'AUTOMATIC GAIN CONTROL',
            ],
            [
                'id_aset'          => 2693,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '009',
                'nama'             => 'COMPRESSOR AMPLIFIER',
            ],
            [
                'id_aset'          => 2694,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '010',
                'nama'             => 'EXPANDER AMPLIFIER',
            ],
            [
                'id_aset'          => 2695,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '011',
                'nama'             => 'ATTENUATOR',
            ],
            [
                'id_aset'          => 2696,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '012',
                'nama'             => 'AUDIO PROCESSOR AM',
            ],
            [
                'id_aset'          => 2697,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '013',
                'nama'             => 'STEREO GENERATOR FM',
            ],
            [
                'id_aset'          => 2698,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '014',
                'nama'             => 'DISTRIBUTOR AMPLIFIER',
            ],
            [
                'id_aset'          => 2699,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '015',
                'nama'             => 'SWITCHER/PATCH PANEL',
            ],
            [
                'id_aset'          => 2700,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '016',
                'nama'             => 'AUDIO MONITOR',
            ],
            [
                'id_aset'          => 2701,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '017',
                'nama'             => 'AM MONITOR',
            ],
            [
                'id_aset'          => 2702,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '018',
                'nama'             => 'FM MONITOR',
            ],
            [
                'id_aset'          => 2703,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '019',
                'nama'             => 'POWER DISTRIBUTION BOARD',
            ],
            [
                'id_aset'          => 2704,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '020',
                'nama'             => 'LIGHTNING PROTECTOR',
            ],
            [
                'id_aset'          => 2705,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '021',
                'nama'             => 'ALL BAND RECEIVER',
            ],
            [
                'id_aset'          => 2706,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '022',
                'nama'             => 'CHANGE OVER SWITCH',
            ],
            [
                'id_aset'          => 2707,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '23',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PROGRAM INPUT EQUIPMENT LAINNYA',
            ],
            [
                'id_aset'          => 2708,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN ANTENE PENERIMA VHF',
            ],
            [
                'id_aset'          => 2709,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '001',
                'nama'             => 'ANTENE PENERIMA VHF',
            ],
            [
                'id_aset'          => 2710,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERALATAN ANTENA PENERIMA LF',
            ],
            [
                'id_aset'          => 2711,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERALATAN ANTENA PENERIMA MF',
            ],
            [
                'id_aset'          => 2712,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PERALATAN ANTENA PENERIMA HF',
            ],
            [
                'id_aset'          => 2713,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PERALATAN ANTENA PENERIMA MF+HF',
            ],
            [
                'id_aset'          => 2714,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PERALATAN ANTENA PENERIMA VHF',
            ],
            [
                'id_aset'          => 2715,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '007',
                'nama'             => 'PERALATAN ANTENA PENERIMA UHF',
            ],
            [
                'id_aset'          => 2716,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '008',
                'nama'             => 'PERALATAN ANTENA PENERIMA SSHF',
            ],
            [
                'id_aset'          => 2717,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '24',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN ANTENE PENERIMA VHF LAINNYA',
            ],
            [
                'id_aset'          => 2718,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '25',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR LF',
            ],
            [
                'id_aset'          => 2719,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '25',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PERALATAN PEMANCAR LF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2720,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '25',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERALATAN PEMANCAR LF PORTABLE',
            ],
            [
                'id_aset'          => 2721,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '25',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERALATAN PEMANCAR LF STATIONARY',
            ],
            [
                'id_aset'          => 2722,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '25',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR LF LAINNYA',
            ],
            [
                'id_aset'          => 2723,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '26',
                'sub_sub_kelompok' => '000',
                'nama'             => 'UNIT PEMANCAR MF+HF',
            ],
            [
                'id_aset'          => 2724,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '26',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT PEMANCAR MF+HF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2725,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '26',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT PEMANCAR MF+HF PORTABLE',
            ],
            [
                'id_aset'          => 2726,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '26',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT PEMANCAR MF+HF STATIONARY',
            ],
            [
                'id_aset'          => 2727,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '26',
                'sub_sub_kelompok' => '999',
                'nama'             => 'UNIT PEMANCAR MF+HF LAINNYA',
            ],
            [
                'id_aset'          => 2728,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '27',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN ANTENA PEMANCAR MF+HF',
            ],
            [
                'id_aset'          => 2729,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '27',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PERALATAN ANTENA PEMANCAR MF+HF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2730,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '27',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERALATAN ANTENA PEMANCAR MF+HF PORTABLE',
            ],
            [
                'id_aset'          => 2731,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '27',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERALATAN ANTENA PEMANCAR MF+HF STATIONARY',
            ],
            [
                'id_aset'          => 2732,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '27',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN ANTENA PEMANCAR MF+HF LAINNYA',
            ],
            [
                'id_aset'          => 2733,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '28',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PENERIMA',
            ],
            [
                'id_aset'          => 2734,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '28',
                'sub_sub_kelompok' => '001',
                'nama'             => 'PERALATAN PENERIMA LF',
            ],
            [
                'id_aset'          => 2735,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '28',
                'sub_sub_kelompok' => '002',
                'nama'             => 'PERALATAN PENERIMA MF',
            ],
            [
                'id_aset'          => 2736,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '28',
                'sub_sub_kelompok' => '003',
                'nama'             => 'PERALATAN PENERIMA HF',
            ],
            [
                'id_aset'          => 2737,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '28',
                'sub_sub_kelompok' => '004',
                'nama'             => 'PERALATAN PENERIMA MF+HF',
            ],
            [
                'id_aset'          => 2738,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '28',
                'sub_sub_kelompok' => '005',
                'nama'             => 'PERALATAN PENERIMA UHF',
            ],
            [
                'id_aset'          => 2739,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '28',
                'sub_sub_kelompok' => '006',
                'nama'             => 'PERALATAN PENERIMA SHF',
            ],
            [
                'id_aset'          => 2740,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '28',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PENERIMA LAINNYA',
            ],
            [
                'id_aset'          => 2741,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '29',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA LF',
            ],
            [
                'id_aset'          => 2742,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '29',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANSCEIVER LF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2743,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '29',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANSCEIVER LF PORTABLE',
            ],
            [
                'id_aset'          => 2744,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '29',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANSCEIVER LF STATIONARY',
            ],
            [
                'id_aset'          => 2745,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '29',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA LF LAINNYA',
            ],
            [
                'id_aset'          => 2746,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '30',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA MF',
            ],
            [
                'id_aset'          => 2747,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '30',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANSCEIVER MF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2748,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '30',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANSCEIVER MF PORTABLE',
            ],
            [
                'id_aset'          => 2749,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '30',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANSCEIVER MF STATIONARY',
            ],
            [
                'id_aset'          => 2750,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '30',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA MF LAINNYA',
            ],
            [
                'id_aset'          => 2751,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA HF',
            ],
            [
                'id_aset'          => 2752,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANSCEIVER HF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2753,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANSCEIVER HF PORTABLE',
            ],
            [
                'id_aset'          => 2754,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANSCEIVER HF STATIONARY',
            ],
            [
                'id_aset'          => 2755,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '004',
                'nama'             => 'RS SSB TRANCIEVER',
            ],
            [
                'id_aset'          => 2756,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '005',
                'nama'             => 'MINI RANGER',
            ],
            [
                'id_aset'          => 2757,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '006',
                'nama'             => 'ARTEMIS',
            ],
            [
                'id_aset'          => 2758,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '007',
                'nama'             => 'TELEROMETER',
            ],
            [
                'id_aset'          => 2759,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '31',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA HF LAINNYA',
            ],
            [
                'id_aset'          => 2760,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '32',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA MF+HF',
            ],
            [
                'id_aset'          => 2761,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '32',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANSCEIVER MF+HF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2762,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '32',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANSCEIVER MF+HF PORTABLE',
            ],
            [
                'id_aset'          => 2763,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '32',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANSCEIVER MF+HF STATIONARY',
            ],
            [
                'id_aset'          => 2764,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '32',
                'sub_sub_kelompok' => '004',
                'nama'             => 'DIFFERENTIAL OMEGA (PERALATAN PEMANCAR DAN PENERIMA MF+HF)',
            ],
            [
                'id_aset'          => 2765,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '32',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA MF+HF LAINNYA',
            ],
            [
                'id_aset'          => 2766,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '33',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA VHF',
            ],
            [
                'id_aset'          => 2767,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '33',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANSCEIVER VHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2768,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '33',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANSCEIVER VHF PORTABLE',
            ],
            [
                'id_aset'          => 2769,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '33',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANSCEIVER VHF STATIONARY',
            ],
            [
                'id_aset'          => 2770,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '33',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA VHF LAINNYA',
            ],
            [
                'id_aset'          => 2771,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA UHF',
            ],
            [
                'id_aset'          => 2772,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANSCEIVER UHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2773,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANSCEIVER UHF PORTABLE',
            ],
            [
                'id_aset'          => 2774,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '003',
                'nama'             => 'UNIT TRANSCEIVER UHF STATIONARY',
            ],
            [
                'id_aset'          => 2775,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '004',
                'nama'             => 'ULTRA HIGHT FREQUENCE LINK',
            ],
            [
                'id_aset'          => 2776,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '005',
                'nama'             => 'AUTO ALARM TUSTEL (AAT)',
            ],
            [
                'id_aset'          => 2777,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '006',
                'nama'             => 'DISTRIBUTION BOARD AND SIGNAL UNIT',
            ],
            [
                'id_aset'          => 2778,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '007',
                'nama'             => 'REMOTE TERMINAL UNIT',
            ],
            [
                'id_aset'          => 2779,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '008',
                'nama'             => 'MULTIPLEX TERMINAL EQUIPMENT',
            ],
            [
                'id_aset'          => 2780,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '009',
                'nama'             => 'SIGNAL VELVOGER GROUNDING',
            ],
            [
                'id_aset'          => 2781,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '010',
                'nama'             => 'BRIDGE MERGER TESTING',
            ],
            [
                'id_aset'          => 2782,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '011',
                'nama'             => 'MESSAGE REPEATER',
            ],
            [
                'id_aset'          => 2783,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '012',
                'nama'             => 'ELECTRIC CLEANER',
            ],
            [
                'id_aset'          => 2784,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '013',
                'nama'             => 'AOTOMATIC AERLALE',
            ],
            [
                'id_aset'          => 2785,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '014',
                'nama'             => 'POWER AND AWR METER ROUND',
            ],
            [
                'id_aset'          => 2786,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '015',
                'nama'             => 'VOLTAGE REGULATOR',
            ],
            [
                'id_aset'          => 2787,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '016',
                'nama'             => 'GYRO COMPASS',
            ],
            [
                'id_aset'          => 2788,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '017',
                'nama'             => 'FREQUENCE SYNTHESIZER UNIT',
            ],
            [
                'id_aset'          => 2789,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '018',
                'nama'             => 'VODAS (VOICE DEVISE ANTI SINGING)',
            ],
            [
                'id_aset'          => 2790,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '019',
                'nama'             => 'ANEMOMETER (PERALATAN PEMANCAR DAN PENERIMA UHF)',
            ],
            [
                'id_aset'          => 2791,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '020',
                'nama'             => 'CLEAR VIEW SCREEN',
            ],
            [
                'id_aset'          => 2792,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '021',
                'nama'             => 'ARQ UNIT',
            ],
            [
                'id_aset'          => 2793,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '022',
                'nama'             => 'RADIO DIRECTION FINDER',
            ],
            [
                'id_aset'          => 2794,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '023',
                'nama'             => 'POWER TRANSMITTER',
            ],
            [
                'id_aset'          => 2795,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '024',
                'nama'             => 'TELE CONTROLLER',
            ],
            [
                'id_aset'          => 2796,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '025',
                'nama'             => 'LOCAL TERMINAL',
            ],
            [
                'id_aset'          => 2797,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '026',
                'nama'             => 'DIGITAL SELECTIVE CALLING (DSC)',
            ],
            [
                'id_aset'          => 2798,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '34',
                'sub_sub_kelompok' => '999',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA UHF LAINNYA',
            ],
            [
                'id_aset'          => 2799,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '35',
                'sub_sub_kelompok' => '000',
                'nama'             => 'PERALATAN PEMANCAR DAN PENERIMA SHF',
            ],
            [
                'id_aset'          => 2800,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '35',
                'sub_sub_kelompok' => '001',
                'nama'             => 'UNIT TRANSCEIVER SHF TRANSPORTABLE',
            ],
            [
                'id_aset'          => 2801,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '35',
                'sub_sub_kelompok' => '002',
                'nama'             => 'UNIT TRANSCEIVER SHF PORTABLE',
            ],
            [
                'id_aset'          => 2802,
                'golongan'         => '3',
                'bidang'           => '06',
                'kelompok'         => '03',
                'sub_kelompok'     => '35',
                'sub_sub_kelompok' => '003',
                'n